/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.AuthorizationInfoData;
import discord4j.discordjson.json.PartialApplicationInfoData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableAuthorizationInfoData
implements AuthorizationInfoData {
    private final PartialApplicationInfoData application;
    private final List<String> scopes;
    private final String expires;
    private final UserData user_value;
    private final boolean user_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAuthorizationInfoData(PartialApplicationInfoData application, Iterable<String> scopes, String expires, Possible<UserData> user) {
        this.application = Objects.requireNonNull(application, "application");
        this.scopes = ImmutableAuthorizationInfoData.createUnmodifiableList(false, ImmutableAuthorizationInfoData.createSafeList(scopes, true, false));
        this.expires = Objects.requireNonNull(expires, "expires");
        Possible<UserData> user$impl = user;
        this.user_value = user$impl.toOptional().orElse(null);
        this.user_absent = user$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableAuthorizationInfoData(ImmutableAuthorizationInfoData original, PartialApplicationInfoData application, List<String> scopes, String expires, Possible<UserData> user) {
        this.application = application;
        this.scopes = scopes;
        this.expires = expires;
        Possible<UserData> user$impl = user;
        this.user_value = user$impl.toOptional().orElse(null);
        this.user_absent = user$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="application")
    public PartialApplicationInfoData application() {
        return this.application;
    }

    @Override
    @JsonProperty(value="scopes")
    public List<String> scopes() {
        return this.scopes;
    }

    @Override
    @JsonProperty(value="expires")
    public String expires() {
        return this.expires;
    }

    @Override
    @JsonProperty(value="user")
    public Possible<UserData> user() {
        return this.user_absent ? Possible.absent() : Possible.of((Object)this.user_value);
    }

    public final ImmutableAuthorizationInfoData withApplication(PartialApplicationInfoData value) {
        if (this.application == value) {
            return this;
        }
        PartialApplicationInfoData newValue = Objects.requireNonNull(value, "application");
        return new ImmutableAuthorizationInfoData(this, newValue, this.scopes, this.expires, this.user());
    }

    public final ImmutableAuthorizationInfoData withScopes(String ... elements) {
        List<String> newValue = ImmutableAuthorizationInfoData.createUnmodifiableList(false, ImmutableAuthorizationInfoData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAuthorizationInfoData(this, this.application, newValue, this.expires, this.user());
    }

    public final ImmutableAuthorizationInfoData withScopes(Iterable<String> elements) {
        if (this.scopes == elements) {
            return this;
        }
        List<String> newValue = ImmutableAuthorizationInfoData.createUnmodifiableList(false, ImmutableAuthorizationInfoData.createSafeList(elements, true, false));
        return new ImmutableAuthorizationInfoData(this, this.application, newValue, this.expires, this.user());
    }

    public final ImmutableAuthorizationInfoData withExpires(String value) {
        String newValue = Objects.requireNonNull(value, "expires");
        if (this.expires.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorizationInfoData(this, this.application, this.scopes, newValue, this.user());
    }

    public ImmutableAuthorizationInfoData withUser(Possible<UserData> value) {
        Possible<UserData> newValue = Objects.requireNonNull(value);
        return new ImmutableAuthorizationInfoData(this, this.application, this.scopes, this.expires, newValue);
    }

    public ImmutableAuthorizationInfoData withUser(UserData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableAuthorizationInfoData(this, this.application, this.scopes, this.expires, (Possible<UserData>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthorizationInfoData && this.equalTo(0, (ImmutableAuthorizationInfoData)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthorizationInfoData another) {
        return this.application.equals(another.application) && this.scopes.equals(another.scopes) && this.expires.equals(another.expires) && this.user().equals(another.user());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.application.hashCode();
        h += (h << 5) + this.scopes.hashCode();
        h += (h << 5) + this.expires.hashCode();
        h += (h << 5) + this.user().hashCode();
        return h;
    }

    public String toString() {
        return "AuthorizationInfoData{application=" + this.application + ", scopes=" + this.scopes + ", expires=" + this.expires + ", user=" + this.user().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuthorizationInfoData fromJson(Json json) {
        Builder builder = ImmutableAuthorizationInfoData.builder();
        if (json.application != null) {
            builder.application(json.application);
        }
        if (json.scopes != null) {
            builder.addAllScopes(json.scopes);
        }
        if (json.expires != null) {
            builder.expires(json.expires);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        return builder.build();
    }

    public static ImmutableAuthorizationInfoData of(PartialApplicationInfoData application, List<String> scopes, String expires, Possible<UserData> user) {
        return ImmutableAuthorizationInfoData.of(application, scopes, expires, user);
    }

    public static ImmutableAuthorizationInfoData of(PartialApplicationInfoData application, Iterable<String> scopes, String expires, Possible<UserData> user) {
        return new ImmutableAuthorizationInfoData(application, scopes, expires, user);
    }

    public static ImmutableAuthorizationInfoData copyOf(AuthorizationInfoData instance) {
        if (instance instanceof ImmutableAuthorizationInfoData) {
            return (ImmutableAuthorizationInfoData)instance;
        }
        return ImmutableAuthorizationInfoData.builder().from(instance).build();
    }

    public boolean isUserPresent() {
        return !this.user_absent;
    }

    public UserData userOrElse(UserData defaultValue) {
        return !this.user_absent ? this.user_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION = 1L;
        private static final long INIT_BIT_EXPIRES = 2L;
        private long initBits = 3L;
        private Possible<UserData> user_possible = Possible.absent();
        @Nullable
        private PartialApplicationInfoData application;
        private List<String> scopes = new ArrayList<String>();
        @Nullable
        private String expires;

        private Builder() {
        }

        public final Builder from(AuthorizationInfoData instance) {
            Objects.requireNonNull(instance, "instance");
            this.application(instance.application());
            this.addAllScopes(instance.scopes());
            this.expires(instance.expires());
            this.user(instance.user());
            return this;
        }

        @JsonProperty(value="application")
        public final Builder application(PartialApplicationInfoData application) {
            this.application = Objects.requireNonNull(application, "application");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addScope(String element) {
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        public final Builder addScopes(String ... elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @JsonProperty(value="scopes")
        public final Builder scopes(Iterable<String> elements) {
            this.scopes.clear();
            return this.addAllScopes(elements);
        }

        public final Builder addAllScopes(Iterable<String> elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @JsonProperty(value="expires")
        public final Builder expires(String expires) {
            this.expires = Objects.requireNonNull(expires, "expires");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="user")
        public Builder user(Possible<UserData> value) {
            this.user_possible = value;
            return this;
        }

        public Builder user(UserData value) {
            this.user_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableAuthorizationInfoData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthorizationInfoData(null, this.application, ImmutableAuthorizationInfoData.createUnmodifiableList(true, this.scopes), this.expires, this.user_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("application");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expires");
            }
            return "Cannot build AuthorizationInfoData, some of required attributes are not set " + attributes;
        }

        private Possible<UserData> user_build() {
            return this.user_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements AuthorizationInfoData {
        @Nullable
        PartialApplicationInfoData application;
        @Nullable
        List<String> scopes = Collections.emptyList();
        @Nullable
        String expires;
        Possible<UserData> user = Possible.absent();

        Json() {
        }

        @JsonProperty(value="application")
        public void setApplication(PartialApplicationInfoData application) {
            this.application = application;
        }

        @JsonProperty(value="scopes")
        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        @JsonProperty(value="expires")
        public void setExpires(String expires) {
            this.expires = expires;
        }

        @JsonProperty(value="user")
        public void setUser(Possible<UserData> user) {
            this.user = user;
        }

        @Override
        public PartialApplicationInfoData application() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> scopes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String expires() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<UserData> user() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build AuthorizationInfoData, attribute initializers form cycle " + attributes;
        }
    }
}

