/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ApplicationTeamMemberData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableApplicationTeamMemberData
implements ApplicationTeamMemberData {
    private final int membershipState;
    private final long teamId_value;
    private final UserData user;
    private final String role_value;
    private final boolean role_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableApplicationTeamMemberData(int membershipState, Id teamId, UserData user, Possible<String> role) {
        this.membershipState = membershipState;
        Id teamId$impl = teamId;
        this.user = Objects.requireNonNull(user, "user");
        Possible<String> role$impl = role;
        this.teamId_value = teamId$impl.asLong();
        this.role_value = role$impl.toOptional().orElse(null);
        this.role_absent = role$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableApplicationTeamMemberData(ImmutableApplicationTeamMemberData original, int membershipState, Id teamId, UserData user, Possible<String> role) {
        this.membershipState = membershipState;
        Id teamId$impl = teamId;
        this.user = user;
        Possible<String> role$impl = role;
        this.teamId_value = teamId$impl.asLong();
        this.role_value = role$impl.toOptional().orElse(null);
        this.role_absent = role$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="membership_state")
    public int membershipState() {
        return this.membershipState;
    }

    @Override
    @JsonProperty(value="team_id")
    public Id teamId() {
        return Id.of((long)this.teamId_value);
    }

    @Override
    @JsonProperty(value="user")
    public UserData user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="role")
    public Possible<String> role() {
        return this.role_absent ? Possible.absent() : Possible.of((Object)this.role_value);
    }

    public final ImmutableApplicationTeamMemberData withMembershipState(int value) {
        if (this.membershipState == value) {
            return this;
        }
        return new ImmutableApplicationTeamMemberData(this, value, this.teamId(), this.user, this.role());
    }

    public ImmutableApplicationTeamMemberData withTeamId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableApplicationTeamMemberData(this, this.membershipState, newValue, this.user, this.role());
    }

    public ImmutableApplicationTeamMemberData withTeamId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableApplicationTeamMemberData(this, this.membershipState, newValue, this.user, this.role());
    }

    public final ImmutableApplicationTeamMemberData withUser(UserData value) {
        if (this.user == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutableApplicationTeamMemberData(this, this.membershipState, this.teamId(), newValue, this.role());
    }

    public ImmutableApplicationTeamMemberData withRole(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableApplicationTeamMemberData(this, this.membershipState, this.teamId(), this.user, newValue);
    }

    public ImmutableApplicationTeamMemberData withRole(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableApplicationTeamMemberData(this, this.membershipState, this.teamId(), this.user, (Possible<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApplicationTeamMemberData && this.equalTo(0, (ImmutableApplicationTeamMemberData)another);
    }

    private boolean equalTo(int synthetic, ImmutableApplicationTeamMemberData another) {
        return this.membershipState == another.membershipState && Objects.equals(this.teamId_value, another.teamId_value) && this.user.equals(another.user) && this.role().equals(another.role());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.membershipState;
        h += (h << 5) + Objects.hashCode(this.teamId_value);
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.role().hashCode();
        return h;
    }

    public String toString() {
        return "ApplicationTeamMemberData{membershipState=" + this.membershipState + ", teamId=" + Objects.toString(this.teamId_value) + ", user=" + this.user + ", role=" + this.role().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApplicationTeamMemberData fromJson(Json json) {
        Builder builder = ImmutableApplicationTeamMemberData.builder();
        if (json.membershipStateIsSet) {
            builder.membershipState(json.membershipState);
        }
        if (json.teamId != null) {
            builder.teamId(json.teamId);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.role != null) {
            builder.role(json.role);
        }
        return builder.build();
    }

    public static ImmutableApplicationTeamMemberData of(int membershipState, Id teamId, UserData user, Possible<String> role) {
        return new ImmutableApplicationTeamMemberData(membershipState, teamId, user, role);
    }

    public static ImmutableApplicationTeamMemberData copyOf(ApplicationTeamMemberData instance) {
        if (instance instanceof ImmutableApplicationTeamMemberData) {
            return (ImmutableApplicationTeamMemberData)instance;
        }
        return ImmutableApplicationTeamMemberData.builder().from(instance).build();
    }

    public boolean isRolePresent() {
        return !this.role_absent;
    }

    public String roleOrElse(String defaultValue) {
        return !this.role_absent ? this.role_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MEMBERSHIP_STATE = 1L;
        private static final long INIT_BIT_USER = 2L;
        private long initBits = 3L;
        private Id teamId_id = null;
        private Possible<String> role_possible = Possible.absent();
        private int membershipState;
        @Nullable
        private UserData user;

        private Builder() {
        }

        public final Builder from(ApplicationTeamMemberData instance) {
            Objects.requireNonNull(instance, "instance");
            this.membershipState(instance.membershipState());
            this.teamId(instance.teamId());
            this.user(instance.user());
            this.role(instance.role());
            return this;
        }

        @JsonProperty(value="membership_state")
        public final Builder membershipState(int membershipState) {
            this.membershipState = membershipState;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder teamId(String value) {
            this.teamId_id = Id.of((String)value);
            return this;
        }

        public Builder teamId(long value) {
            this.teamId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="team_id")
        public Builder teamId(Id value) {
            this.teamId_id = value;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(UserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="role")
        public Builder role(Possible<String> value) {
            this.role_possible = value;
            return this;
        }

        public Builder role(String value) {
            this.role_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableApplicationTeamMemberData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApplicationTeamMemberData(null, this.membershipState, this.teamId_build(), this.user, this.role_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("membershipState");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("user");
            }
            return "Cannot build ApplicationTeamMemberData, some of required attributes are not set " + attributes;
        }

        private Id teamId_build() {
            return this.teamId_id;
        }

        private Possible<String> role_build() {
            return this.role_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ApplicationTeamMemberData {
        int membershipState;
        boolean membershipStateIsSet;
        @Nullable
        Id teamId;
        @Nullable
        UserData user;
        Possible<String> role = Possible.absent();

        Json() {
        }

        @JsonProperty(value="membership_state")
        public void setMembershipState(int membershipState) {
            this.membershipState = membershipState;
            this.membershipStateIsSet = true;
        }

        @JsonProperty(value="team_id")
        public void setTeamId(Id teamId) {
            this.teamId = teamId;
        }

        @JsonProperty(value="user")
        public void setUser(UserData user) {
            this.user = user;
        }

        @JsonProperty(value="role")
        public void setRole(Possible<String> role) {
            this.role = role;
        }

        @Override
        public int membershipState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id teamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserData user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> role() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ApplicationTeamMemberData, attribute initializers form cycle " + attributes;
        }
    }
}

