/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice;

import discord4j.voice.crypto.Aes256GcmEncryptionAdapter;
import discord4j.voice.crypto.EncryptionAdapter;
import discord4j.voice.crypto.EncryptionMode;
import discord4j.voice.crypto.Xchacha20Poly1305EncryptionAdapter;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

final class PacketTransformer {
    private static final Logger LOGGER = Loggers.getLogger(PacketTransformer.class);
    private static final int RTP_HEADER_LENGTH = 12;
    private final int ssrc;
    private final EncryptionAdapter encryptionAdapter;
    private char seq = '\u0000';
    private int encryptCounter;

    PacketTransformer(int ssrc, EncryptionMode encryptionMode, byte[] secretKey) throws GeneralSecurityException {
        this.ssrc = ssrc;
        switch (encryptionMode) {
            case AEAD_AES256_GCM: {
                this.encryptionAdapter = new Aes256GcmEncryptionAdapter(secretKey);
                break;
            }
            case AEAD_XCHACHA20_POLY1305: {
                this.encryptionAdapter = new Xchacha20Poly1305EncryptionAdapter(secretKey);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown encryption mode: " + (Object)((Object)encryptionMode));
            }
        }
        SecureRandom random = new SecureRandom();
        this.encryptCounter = Math.abs(random.nextInt()) % 513 + 1;
    }

    @Nullable
    byte[] nextSend(byte[] audio) {
        byte[] encrypted;
        char c = this.seq;
        this.seq = (char)(c + '\u0001');
        byte[] header = this.getRtpHeader(c);
        byte[] nonce = new byte[this.encryptionAdapter.getNonceLength()];
        nonce[0] = (byte)(this.encryptCounter >>> 24 & 0xFF);
        nonce[1] = (byte)(this.encryptCounter >>> 16 & 0xFF);
        nonce[2] = (byte)(this.encryptCounter >>> 8 & 0xFF);
        nonce[3] = (byte)(this.encryptCounter & 0xFF);
        try {
            encrypted = this.encryptionAdapter.encrypt(header, audio, nonce);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Failed to encrypt audio", (Throwable)e);
            return null;
        }
        byte[] finalPacket = new byte[header.length + encrypted.length + 4];
        System.arraycopy(header, 0, finalPacket, 0, header.length);
        System.arraycopy(encrypted, 0, finalPacket, header.length, encrypted.length);
        System.arraycopy(nonce, 0, finalPacket, header.length + encrypted.length, 4);
        ++this.encryptCounter;
        return finalPacket;
    }

    @Nullable
    byte[] nextReceive(ByteBuf packet) {
        byte[] decrypted;
        short extension;
        byte extensionByte = packet.readByte();
        boolean hasExtension = (extensionByte & 0x10) != 0;
        int crscLen = extensionByte & 0xF;
        byte type = packet.readByte();
        char seq = packet.readChar();
        int timestamp = packet.readInt();
        int ssrc = packet.readInt();
        int[] csrc = new int[crscLen];
        for (int i = 0; i < csrc.length; ++i) {
            csrc[i] = packet.readInt();
        }
        if (hasExtension) {
            packet.skipBytes(2);
            extension = packet.readShort();
        } else {
            extension = 0;
        }
        int headerLenght = packet.readerIndex();
        if (type != 120) {
            throw new IllegalArgumentException("Unsupported packet type: " + type);
        }
        byte[] header = new byte[headerLenght];
        packet.getBytes(0, header);
        int nonceLenght = this.encryptionAdapter.getNonceLength();
        int audioOffset = packet.readableBytes();
        int audioLength = audioOffset - nonceLenght;
        byte[] encrypted = new byte[audioLength];
        packet.getBytes(headerLenght, encrypted, 0, audioLength);
        byte[] nonce = new byte[nonceLenght];
        packet.getBytes(headerLenght + audioLength, nonce);
        packet.release();
        try {
            decrypted = this.encryptionAdapter.decrypt(header, encrypted, nonce);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Failed to decrypt audio", (Throwable)e);
            return null;
        }
        int offset = 4 * extension;
        byte[] newPacket = new byte[headerLenght + decrypted.length - offset];
        System.arraycopy(header, 0, newPacket, 0, headerLenght);
        System.arraycopy(decrypted, offset, newPacket, headerLenght, decrypted.length - offset);
        return newPacket;
    }

    private byte[] getRtpHeader(char seq) {
        return ByteBuffer.allocate(12).put((byte)-128).put((byte)120).putChar(seq).putInt(seq * 960).putInt(this.ssrc).array();
    }
}

