/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.DiscordClient;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.spec.SubscriptionListRequestFluxGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class SubscriptionListRequestFlux
extends SubscriptionListRequestFluxGenerator {
    private final Snowflake userId_value;
    private final boolean userId_absent;
    private final Snowflake before_value;
    private final boolean before_absent;
    private final Snowflake after_value;
    private final boolean after_absent;
    private final Integer limit_value;
    private final boolean limit_absent;
    private final GatewayDiscordClient client;
    private final DiscordClient restClient;
    private final Snowflake entitlementId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SubscriptionListRequestFlux(GatewayDiscordClient client, DiscordClient restClient, Snowflake entitlementId) {
        this.client = Objects.requireNonNull(client, "client");
        this.restClient = Objects.requireNonNull(restClient, "restClient");
        this.entitlementId = Objects.requireNonNull(entitlementId, "entitlementId");
        Possible userId$impl = Possible.absent();
        Possible before$impl = Possible.absent();
        Possible after$impl = Possible.absent();
        Possible limit$impl = Possible.absent();
        this.userId_value = userId$impl.toOptional().orElse(null);
        this.userId_absent = userId$impl.isAbsent();
        this.before_value = before$impl.toOptional().orElse(null);
        this.before_absent = before$impl.isAbsent();
        this.after_value = after$impl.toOptional().orElse(null);
        this.after_absent = after$impl.isAbsent();
        this.limit_value = limit$impl.toOptional().orElse(null);
        this.limit_absent = limit$impl.isAbsent();
        this.initShim = null;
    }

    private SubscriptionListRequestFlux(Possible<Snowflake> userId, Possible<Snowflake> before, Possible<Snowflake> after, Possible<Integer> limit, GatewayDiscordClient client, DiscordClient restClient, Snowflake entitlementId) {
        Possible<Snowflake> userId$impl = userId;
        Possible<Snowflake> before$impl = before;
        Possible<Snowflake> after$impl = after;
        Possible<Integer> limit$impl = limit;
        this.client = client;
        this.restClient = restClient;
        this.entitlementId = entitlementId;
        this.userId_value = userId$impl.toOptional().orElse(null);
        this.userId_absent = userId$impl.isAbsent();
        this.before_value = before$impl.toOptional().orElse(null);
        this.before_absent = before$impl.isAbsent();
        this.after_value = after$impl.toOptional().orElse(null);
        this.after_absent = after$impl.isAbsent();
        this.limit_value = limit$impl.toOptional().orElse(null);
        this.limit_absent = limit$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<Snowflake> userId() {
        return this.userId_absent ? Possible.absent() : Possible.of((Object)this.userId_value);
    }

    @Override
    public Possible<Snowflake> before() {
        return this.before_absent ? Possible.absent() : Possible.of((Object)this.before_value);
    }

    @Override
    public Possible<Snowflake> after() {
        return this.after_absent ? Possible.absent() : Possible.of((Object)this.after_value);
    }

    @Override
    public Possible<Integer> limit() {
        return this.limit_absent ? Possible.absent() : Possible.of((Object)this.limit_value);
    }

    @Override
    public GatewayDiscordClient client() {
        return this.client;
    }

    @Override
    public DiscordClient restClient() {
        return this.restClient;
    }

    @Override
    public Snowflake entitlementId() {
        return this.entitlementId;
    }

    public SubscriptionListRequestFlux withUserId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new SubscriptionListRequestFlux(newValue, this.before(), this.after(), this.limit(), this.client, this.restClient, this.entitlementId);
    }

    public SubscriptionListRequestFlux withUserId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new SubscriptionListRequestFlux((Possible<Snowflake>)newValue, this.before(), this.after(), this.limit(), this.client, this.restClient, this.entitlementId);
    }

    public SubscriptionListRequestFlux withBefore(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new SubscriptionListRequestFlux(this.userId(), newValue, this.after(), this.limit(), this.client, this.restClient, this.entitlementId);
    }

    public SubscriptionListRequestFlux withBefore(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new SubscriptionListRequestFlux(this.userId(), (Possible<Snowflake>)newValue, this.after(), this.limit(), this.client, this.restClient, this.entitlementId);
    }

    public SubscriptionListRequestFlux withAfter(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new SubscriptionListRequestFlux(this.userId(), this.before(), newValue, this.limit(), this.client, this.restClient, this.entitlementId);
    }

    public SubscriptionListRequestFlux withAfter(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new SubscriptionListRequestFlux(this.userId(), this.before(), (Possible<Snowflake>)newValue, this.limit(), this.client, this.restClient, this.entitlementId);
    }

    public SubscriptionListRequestFlux withLimit(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new SubscriptionListRequestFlux(this.userId(), this.before(), this.after(), newValue, this.client, this.restClient, this.entitlementId);
    }

    public SubscriptionListRequestFlux withLimit(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new SubscriptionListRequestFlux(this.userId(), this.before(), this.after(), (Possible<Integer>)newValue, this.client, this.restClient, this.entitlementId);
    }

    public final SubscriptionListRequestFlux withClient(GatewayDiscordClient value) {
        if (this.client == value) {
            return this;
        }
        GatewayDiscordClient newValue = Objects.requireNonNull(value, "client");
        return new SubscriptionListRequestFlux(this.userId(), this.before(), this.after(), this.limit(), newValue, this.restClient, this.entitlementId);
    }

    public final SubscriptionListRequestFlux withRestClient(DiscordClient value) {
        if (this.restClient == value) {
            return this;
        }
        DiscordClient newValue = Objects.requireNonNull(value, "restClient");
        return new SubscriptionListRequestFlux(this.userId(), this.before(), this.after(), this.limit(), this.client, newValue, this.entitlementId);
    }

    public final SubscriptionListRequestFlux withEntitlementId(Snowflake value) {
        if (this.entitlementId == value) {
            return this;
        }
        Snowflake newValue = Objects.requireNonNull(value, "entitlementId");
        return new SubscriptionListRequestFlux(this.userId(), this.before(), this.after(), this.limit(), this.client, this.restClient, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SubscriptionListRequestFlux && this.equalTo(0, (SubscriptionListRequestFlux)another);
    }

    private boolean equalTo(int synthetic, SubscriptionListRequestFlux another) {
        return this.userId().equals(another.userId()) && this.before().equals(another.before()) && this.after().equals(another.after()) && this.limit().equals(another.limit()) && this.client.equals(another.client) && ((Object)((Object)this.restClient)).equals((Object)another.restClient) && this.entitlementId.equals((Object)another.entitlementId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userId().hashCode();
        h += (h << 5) + this.before().hashCode();
        h += (h << 5) + this.after().hashCode();
        h += (h << 5) + this.limit().hashCode();
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + ((Object)((Object)this.restClient)).hashCode();
        h += (h << 5) + this.entitlementId.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "SubscriptionListRequestFlux{userId=" + this.userId().toString() + ", before=" + this.before().toString() + ", after=" + this.after().toString() + ", limit=" + this.limit().toString() + ", client=" + this.client + ", restClient=" + (Object)((Object)this.restClient) + ", entitlementId=" + this.entitlementId + "}";
    }

    public static SubscriptionListRequestFlux of(GatewayDiscordClient client, DiscordClient restClient, Snowflake entitlementId) {
        return new SubscriptionListRequestFlux(client, restClient, entitlementId);
    }

    static SubscriptionListRequestFlux copyOf(SubscriptionListRequestFluxGenerator instance) {
        if (instance instanceof SubscriptionListRequestFlux) {
            return (SubscriptionListRequestFlux)instance;
        }
        return SubscriptionListRequestFlux.of(instance.client(), instance.restClient(), instance.entitlementId()).withUserId((Possible<Snowflake>)instance.userId()).withBefore((Possible<Snowflake>)instance.before()).withAfter((Possible<Snowflake>)instance.after()).withLimit((Possible<Integer>)instance.limit());
    }

    public boolean isUserIdPresent() {
        return !this.userId_absent;
    }

    public Snowflake userIdOrElse(Snowflake defaultValue) {
        return !this.userId_absent ? this.userId_value : defaultValue;
    }

    public boolean isBeforePresent() {
        return !this.before_absent;
    }

    public Snowflake beforeOrElse(Snowflake defaultValue) {
        return !this.before_absent ? this.before_value : defaultValue;
    }

    public boolean isAfterPresent() {
        return !this.after_absent;
    }

    public Snowflake afterOrElse(Snowflake defaultValue) {
        return !this.after_absent ? this.after_value : defaultValue;
    }

    public boolean isLimitPresent() {
        return !this.limit_absent;
    }

    public Integer limitOrElse(Integer defaultValue) {
        return !this.limit_absent ? this.limit_value : defaultValue;
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SubscriptionListRequestFlux, attribute initializers form cycle " + attributes;
        }
    }
}

