/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.ScheduledEvent;
import discord4j.core.spec.AuditSpec;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.RecurrenceRuleSpec;
import discord4j.core.spec.RecurrenceRuleSpecGenerator;
import discord4j.core.spec.ScheduledEventEntityMetadataSpec;
import discord4j.core.spec.ScheduledEventEntityMetadataSpecGenerator;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.GuildScheduledEventModifyRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.time.Instant;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface ScheduledEventEditSpecGenerator
extends AuditSpec<GuildScheduledEventModifyRequest> {
    public Possible<Optional<Snowflake>> channelId();

    public Possible<ScheduledEventEntityMetadataSpec> entityMetadata();

    public Possible<String> name();

    public Possible<ScheduledEvent.PrivacyLevel> privacyLevel();

    public Possible<Instant> scheduledStartTime();

    public Possible<Instant> scheduledEndTime();

    public Possible<String> description();

    public Possible<ScheduledEvent.EntityType> entityType();

    public Possible<ScheduledEvent.Status> status();

    public Possible<Image> image();

    public Possible<Optional<RecurrenceRuleSpec>> recurrenceRule();

    @Override
    default public GuildScheduledEventModifyRequest asRequest() {
        return GuildScheduledEventModifyRequest.builder().channelId(InternalSpecUtils.mapPossible(this.channelId(), optional -> optional.map(snowflake -> Id.of((long)snowflake.asLong())))).entityMetadata(InternalSpecUtils.mapPossible(this.entityMetadata(), ScheduledEventEntityMetadataSpecGenerator::asRequest)).name(this.name()).privacyLevel(InternalSpecUtils.mapPossible(this.privacyLevel(), ScheduledEvent.PrivacyLevel::getValue)).scheduledStartTime(this.scheduledStartTime()).scheduledEndTime(this.scheduledEndTime()).description(this.description()).entityType(InternalSpecUtils.mapPossible(this.entityType(), ScheduledEvent.EntityType::getValue)).status(InternalSpecUtils.mapPossible(this.status(), ScheduledEvent.Status::getValue)).image(InternalSpecUtils.mapPossible(this.image(), Image::getDataUri)).recurrenceRule(InternalSpecUtils.mapPossible(this.recurrenceRule(), optional -> optional.map(RecurrenceRuleSpecGenerator::asRequest))).build();
    }
}

