/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.EmbedCreateFields;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@ParametersAreNonnullByDefault
@Generated(from="EmbedCreateFields", generator="Immutables")
final class ImmutableEmbedCreateFields {
    private ImmutableEmbedCreateFields() {
    }

    @CheckReturnValue
    @Generated(from="EmbedCreateFields.Field", generator="Immutables")
    @Immutable
    static final class Field
    implements EmbedCreateFields.Field {
        private final String name;
        private final String value;
        private final boolean inline;

        private Field(String name, String value, boolean inline) {
            this.name = Objects.requireNonNull(name, "name");
            this.value = Objects.requireNonNull(value, "value");
            this.inline = inline;
        }

        private Field(Field original, String name, String value, boolean inline) {
            this.name = name;
            this.value = value;
            this.inline = inline;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public boolean inline() {
            return this.inline;
        }

        public final Field withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new Field(this, newValue, this.value, this.inline);
        }

        public final Field withValue(String value) {
            String newValue = Objects.requireNonNull(value, "value");
            if (this.value.equals(newValue)) {
                return this;
            }
            return new Field(this, this.name, newValue, this.inline);
        }

        public final Field withInline(boolean value) {
            if (this.inline == value) {
                return this;
            }
            return new Field(this, this.name, this.value, value);
        }

        public boolean equals(@javax.annotation.Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Field && this.equalTo(0, (Field)another);
        }

        private boolean equalTo(int synthetic, Field another) {
            return this.name.equals(another.name) && this.value.equals(another.value) && this.inline == another.inline;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.value.hashCode();
            h += (h << 5) + Boolean.hashCode(this.inline);
            return h;
        }

        public String toString() {
            return "Field{name=" + this.name + ", value=" + this.value + ", inline=" + this.inline + "}";
        }

        public static Field of(String name, String value, boolean inline) {
            return new Field(name, value, inline);
        }

        public static Field copyOf(EmbedCreateFields.Field instance) {
            if (instance instanceof Field) {
                return (Field)instance;
            }
            return Field.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EmbedCreateFields.Field", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private static final long INIT_BIT_VALUE = 2L;
            private static final long INIT_BIT_INLINE = 4L;
            private long initBits = 7L;
            @javax.annotation.Nullable
            private String name;
            @javax.annotation.Nullable
            private String value;
            private boolean inline;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EmbedCreateFields.Field instance) {
                Objects.requireNonNull(instance, "instance");
                this.name(instance.name());
                this.value(instance.value());
                this.inline(instance.inline());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder value(String value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder inline(boolean inline) {
                this.inline = inline;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Field build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Field(null, this.name, this.value, this.inline);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("value");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("inline");
                }
                return "Cannot build Field, some of required attributes are not set " + attributes;
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EmbedCreateFields.Author", generator="Immutables")
    @Immutable
    static final class Author
    implements EmbedCreateFields.Author {
        private final String name;
        @Nullable
        private final String url;
        @Nullable
        private final String iconUrl;

        private Author(String name, @Nullable String url, @Nullable String iconUrl) {
            this.name = Objects.requireNonNull(name, "name");
            this.url = url;
            this.iconUrl = iconUrl;
        }

        private Author(Author original, String name, @Nullable String url, @Nullable String iconUrl) {
            this.name = name;
            this.url = url;
            this.iconUrl = iconUrl;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        @Nullable
        public String url() {
            return this.url;
        }

        @Override
        @Nullable
        public String iconUrl() {
            return this.iconUrl;
        }

        public final Author withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new Author(this, newValue, this.url, this.iconUrl);
        }

        public final Author withUrl(@Nullable String value) {
            if (Objects.equals(this.url, value)) {
                return this;
            }
            return new Author(this, this.name, value, this.iconUrl);
        }

        public final Author withIconUrl(@Nullable String value) {
            if (Objects.equals(this.iconUrl, value)) {
                return this;
            }
            return new Author(this, this.name, this.url, value);
        }

        public boolean equals(@javax.annotation.Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Author && this.equalTo(0, (Author)another);
        }

        private boolean equalTo(int synthetic, Author another) {
            return this.name.equals(another.name) && Objects.equals(this.url, another.url) && Objects.equals(this.iconUrl, another.iconUrl);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + Objects.hashCode(this.url);
            h += (h << 5) + Objects.hashCode(this.iconUrl);
            return h;
        }

        public String toString() {
            return "Author{name=" + this.name + ", url=" + this.url + ", iconUrl=" + this.iconUrl + "}";
        }

        public static Author of(String name, @Nullable String url, @Nullable String iconUrl) {
            return new Author(name, url, iconUrl);
        }

        public static Author copyOf(EmbedCreateFields.Author instance) {
            if (instance instanceof Author) {
                return (Author)instance;
            }
            return Author.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EmbedCreateFields.Author", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private long initBits = 1L;
            @javax.annotation.Nullable
            private String name;
            @javax.annotation.Nullable
            private String url;
            @javax.annotation.Nullable
            private String iconUrl;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EmbedCreateFields.Author instance) {
                String iconUrlValue;
                Objects.requireNonNull(instance, "instance");
                this.name(instance.name());
                String urlValue = instance.url();
                if (urlValue != null) {
                    this.url(urlValue);
                }
                if ((iconUrlValue = instance.iconUrl()) != null) {
                    this.iconUrl(iconUrlValue);
                }
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder url(@Nullable String url) {
                this.url = url;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder iconUrl(@Nullable String iconUrl) {
                this.iconUrl = iconUrl;
                return this;
            }

            public Author build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Author(null, this.name, this.url, this.iconUrl);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                return "Cannot build Author, some of required attributes are not set " + attributes;
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EmbedCreateFields.Footer", generator="Immutables")
    @Immutable
    static final class Footer
    implements EmbedCreateFields.Footer {
        private final String text;
        @Nullable
        private final String iconUrl;

        private Footer(String text, @Nullable String iconUrl) {
            this.text = Objects.requireNonNull(text, "text");
            this.iconUrl = iconUrl;
        }

        private Footer(Footer original, String text, @Nullable String iconUrl) {
            this.text = text;
            this.iconUrl = iconUrl;
        }

        @Override
        public String text() {
            return this.text;
        }

        @Override
        @Nullable
        public String iconUrl() {
            return this.iconUrl;
        }

        public final Footer withText(String value) {
            String newValue = Objects.requireNonNull(value, "text");
            if (this.text.equals(newValue)) {
                return this;
            }
            return new Footer(this, newValue, this.iconUrl);
        }

        public final Footer withIconUrl(@Nullable String value) {
            if (Objects.equals(this.iconUrl, value)) {
                return this;
            }
            return new Footer(this, this.text, value);
        }

        public boolean equals(@javax.annotation.Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Footer && this.equalTo(0, (Footer)another);
        }

        private boolean equalTo(int synthetic, Footer another) {
            return this.text.equals(another.text) && Objects.equals(this.iconUrl, another.iconUrl);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.text.hashCode();
            h += (h << 5) + Objects.hashCode(this.iconUrl);
            return h;
        }

        public String toString() {
            return "Footer{text=" + this.text + ", iconUrl=" + this.iconUrl + "}";
        }

        public static Footer of(String text, @Nullable String iconUrl) {
            return new Footer(text, iconUrl);
        }

        public static Footer copyOf(EmbedCreateFields.Footer instance) {
            if (instance instanceof Footer) {
                return (Footer)instance;
            }
            return Footer.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EmbedCreateFields.Footer", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TEXT = 1L;
            private long initBits = 1L;
            @javax.annotation.Nullable
            private String text;
            @javax.annotation.Nullable
            private String iconUrl;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EmbedCreateFields.Footer instance) {
                Objects.requireNonNull(instance, "instance");
                this.text(instance.text());
                String iconUrlValue = instance.iconUrl();
                if (iconUrlValue != null) {
                    this.iconUrl(iconUrlValue);
                }
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder text(String text) {
                this.text = Objects.requireNonNull(text, "text");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder iconUrl(@Nullable String iconUrl) {
                this.iconUrl = iconUrl;
                return this;
            }

            public Footer build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Footer(null, this.text, this.iconUrl);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("text");
                }
                return "Cannot build Footer, some of required attributes are not set " + attributes;
            }
        }
    }
}

