/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.retriever;

import discord4j.common.store.Store;
import discord4j.common.store.action.read.ReadActions;
import discord4j.common.store.api.StoreAction;
import discord4j.common.store.api.object.ExactResultNotAvailableException;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.ScheduledEventUser;
import discord4j.core.object.VoiceState;
import discord4j.core.object.automod.AutoModRule;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.core.object.entity.GuildSticker;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.ScheduledEvent;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.retriever.EntityRetriever;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.AutoModRuleData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.GuildScheduledEventData;
import discord4j.discordjson.json.GuildScheduledEventUserData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.VoiceStateData;
import java.util.Collections;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StoreEntityRetriever
implements EntityRetriever {
    private final GatewayDiscordClient gateway;
    private final Store store;

    public StoreEntityRetriever(GatewayDiscordClient gateway) {
        this.gateway = gateway;
        this.store = gateway.getGatewayResources().getStore();
    }

    @Override
    public Mono<Channel> getChannelById(Snowflake channelId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getChannelById((long)channelId.asLong()))).map(data -> EntityUtil.getChannel(this.gateway, data));
    }

    @Override
    public Mono<Guild> getGuildById(Snowflake guildId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getGuildById((long)guildId.asLong()))).map(data -> new Guild(this.gateway, (GuildData)data));
    }

    @Override
    public Mono<GuildSticker> getGuildStickerById(Snowflake guildId, Snowflake stickerId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getStickerById((long)guildId.asLong(), (long)stickerId.asLong()))).map(data -> new GuildSticker(this.gateway, (StickerData)data, guildId.asLong()));
    }

    @Override
    public Mono<GuildEmoji> getGuildEmojiById(Snowflake guildId, Snowflake emojiId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getEmojiById((long)guildId.asLong(), (long)emojiId.asLong()))).map(data -> new GuildEmoji(this.gateway, (EmojiData)data, guildId.asLong()));
    }

    @Override
    public Mono<Member> getMemberById(Snowflake guildId, Snowflake userId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getMemberById((long)guildId.asLong(), (long)userId.asLong()))).map(data -> new Member(this.gateway, (MemberData)data, guildId.asLong())).onErrorResume(ExactResultNotAvailableException.class, ignored -> this.gateway.requestMembers(guildId, Collections.singleton(userId)).filter(member -> member.getId().equals((Object)userId)).next());
    }

    @Override
    public Mono<Message> getMessageById(Snowflake channelId, Snowflake messageId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getMessageById((long)channelId.asLong(), (long)messageId.asLong()))).map(data -> new Message(this.gateway, (MessageData)data));
    }

    @Override
    public Mono<Role> getRoleById(Snowflake guildId, Snowflake roleId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getRoleById((long)guildId.asLong(), (long)roleId.asLong()))).map(data -> new Role(this.gateway, (RoleData)data, guildId.asLong()));
    }

    @Override
    public Mono<User> getUserById(Snowflake userId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getUserById((long)userId.asLong()))).map(data -> new User(this.gateway, (UserData)data));
    }

    @Override
    public Flux<Guild> getGuilds() {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getGuilds())).map(data -> new Guild(this.gateway, (GuildData)data));
    }

    @Override
    public Mono<User> getSelf() {
        return this.getUserById(this.gateway.getSelfId());
    }

    @Override
    public Mono<Member> getSelfMember(Snowflake guildId) {
        return this.getMemberById(guildId, this.gateway.getSelfId());
    }

    @Override
    public Flux<Member> getGuildMembers(Snowflake guildId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getExactMembersInGuild((long)guildId.asLong()))).map(data -> new Member(this.gateway, (MemberData)data, guildId.asLong())).onErrorResume(ExactResultNotAvailableException.class, e -> this.gateway.requestMembers(guildId));
    }

    @Override
    public Flux<GuildChannel> getGuildChannels(Snowflake guildId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getChannelsInGuild((long)guildId.asLong()))).map(channelData -> EntityUtil.getChannel(this.gateway, channelData)).ofType(GuildChannel.class);
    }

    @Override
    public Flux<Role> getGuildRoles(Snowflake guildId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getRolesInGuild((long)guildId.asLong()))).map(roleData -> new Role(this.gateway, (RoleData)roleData, guildId.asLong()));
    }

    @Override
    public Flux<GuildEmoji> getGuildEmojis(Snowflake guildId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getEmojisInGuild((long)guildId.asLong()))).map(emojiData -> new GuildEmoji(this.gateway, (EmojiData)emojiData, guildId.asLong()));
    }

    @Override
    public Flux<GuildSticker> getGuildStickers(Snowflake guildId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getStickersInGuild((long)guildId.asLong()))).map(data -> new GuildSticker(this.gateway, (StickerData)data, guildId.asLong()));
    }

    @Override
    public Flux<AutoModRule> getGuildAutoModRules(Snowflake guildId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getAutoModRulesInGuild((long)guildId.asLong()))).map(data -> new AutoModRule(this.gateway, (AutoModRuleData)data));
    }

    @Override
    public Mono<ScheduledEvent> getScheduledEventById(Snowflake guildId, Snowflake eventId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getScheduledEventById((long)guildId.asLong(), (long)eventId.asLong()))).map(data -> new ScheduledEvent(this.gateway, (GuildScheduledEventData)data));
    }

    @Override
    public Flux<ScheduledEvent> getScheduledEvents(Snowflake guildId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getScheduledEventsInGuild((long)guildId.asLong()))).map(data -> new ScheduledEvent(this.gateway, (GuildScheduledEventData)data));
    }

    @Override
    public Flux<ScheduledEventUser> getScheduledEventUsers(Snowflake guildId, Snowflake eventId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getScheduledEventsUsers((long)guildId.asLong(), (long)eventId.asLong()))).flatMap(id -> Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getUserById((long)id.asLong())))).map(userData -> new ScheduledEventUser(this.gateway, (GuildScheduledEventUserData)GuildScheduledEventUserData.builder().user(userData).guildScheduledEventId(eventId.asLong()).build(), guildId));
    }

    @Override
    public Mono<VoiceState> getVoiceStateById(Snowflake guildId, Snowflake userId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getVoiceStateById((long)guildId.asLong(), (long)userId.asLong()))).map(bean -> new VoiceState(this.gateway, (VoiceStateData)bean));
    }
}

