/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.command.ApplicationCommandOptionChoice;
import discord4j.core.object.entity.channel.Channel;
import discord4j.discordjson.json.ApplicationCommandOptionChoiceData;
import discord4j.discordjson.json.ApplicationCommandOptionData;
import discord4j.discordjson.possible.Possible;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Experimental
public class ApplicationCommandOption
implements DiscordObject {
    public static final int MAX_NAME_LENGTH = 32;
    public static final int MAX_DESCRIPTION_LENGTH = 100;
    private final GatewayDiscordClient gateway;
    private final ApplicationCommandOptionData data;

    public ApplicationCommandOption(GatewayDiscordClient gateway, ApplicationCommandOptionData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public String getName() {
        return this.data.name();
    }

    public Map<Locale, String> getLocalizedNames() {
        return Possible.flatOpt((Possible)this.data.nameLocalizations()).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(entry -> new Locale.Builder().setLanguageTag((String)entry.getKey()).build(), Map.Entry::getValue));
    }

    public String getDescription() {
        return this.data.description();
    }

    public Map<Locale, String> getLocalizedDescriptions() {
        return Possible.flatOpt((Possible)this.data.descriptionLocalizations()).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(entry -> new Locale.Builder().setLanguageTag((String)entry.getKey()).build(), Map.Entry::getValue));
    }

    public boolean isRequired() {
        return this.data.required().toOptional().orElse(false);
    }

    public List<ApplicationCommandOptionChoice> getChoices() {
        return this.data.choices().toOptional().orElse(Collections.emptyList()).stream().map(data -> new ApplicationCommandOptionChoice(this.gateway, (ApplicationCommandOptionChoiceData)data)).collect(Collectors.toList());
    }

    public Optional<ApplicationCommandOptionChoice> getChoice(String name) {
        return this.data.choices().toOptional().orElse(Collections.emptyList()).stream().filter(choice -> choice.name().equals(name)).findFirst().map(data -> new ApplicationCommandOptionChoice(this.gateway, (ApplicationCommandOptionChoiceData)data));
    }

    public List<ApplicationCommandOption> getOptions() {
        return this.data.options().toOptional().orElse(Collections.emptyList()).stream().map(data -> new ApplicationCommandOption(this.gateway, (ApplicationCommandOptionData)data)).collect(Collectors.toList());
    }

    public Optional<ApplicationCommandOption> getOption(String name) {
        return this.data.options().toOptional().orElse(Collections.emptyList()).stream().filter(option -> option.name().equals(name)).findFirst().map(data -> new ApplicationCommandOption(this.gateway, (ApplicationCommandOptionData)data));
    }

    public List<Channel.Type> getAllowedChannelTypes() {
        return this.data.channelTypes().toOptional().orElse(Collections.emptyList()).stream().map(Channel.Type::of).collect(Collectors.toList());
    }

    public boolean hasAutocompleteEnabled() {
        return this.data.autocomplete().toOptional().orElse(false);
    }

    public Optional<Double> getMinimumValue() {
        return this.data.minValue().toOptional();
    }

    public Optional<Double> getMaximumValue() {
        return this.data.maxValue().toOptional();
    }

    public Optional<Integer> getMinimumLength() {
        return this.data.minLength().toOptional();
    }

    public Optional<Integer> getMaximumLength() {
        return this.data.maxLength().toOptional();
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public static enum Type {
        UNKNOWN(-1),
        SUB_COMMAND(1),
        SUB_COMMAND_GROUP(2),
        STRING(3),
        INTEGER(4),
        BOOLEAN(5),
        USER(6),
        CHANNEL(7),
        ROLE(8),
        MENTIONABLE(9),
        NUMBER(10),
        ATTACHMENT(11);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return SUB_COMMAND;
                }
                case 2: {
                    return SUB_COMMAND_GROUP;
                }
                case 3: {
                    return STRING;
                }
                case 4: {
                    return INTEGER;
                }
                case 5: {
                    return BOOLEAN;
                }
                case 6: {
                    return USER;
                }
                case 7: {
                    return CHANNEL;
                }
                case 8: {
                    return ROLE;
                }
                case 9: {
                    return MENTIONABLE;
                }
                case 10: {
                    return NUMBER;
                }
                case 11: {
                    return ATTACHMENT;
                }
            }
            return UNKNOWN;
        }
    }
}

