/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.automod;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.automod.AutoModRuleAction;
import discord4j.core.object.automod.AutoModRuleTriggerMetaData;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.User;
import discord4j.core.spec.AutoModRuleEditSpec;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AutoModActionData;
import discord4j.discordjson.json.AutoModRuleData;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class AutoModRule
implements Entity {
    private final GatewayDiscordClient gateway;
    private final AutoModRuleData data;

    public AutoModRule(GatewayDiscordClient gateway, AutoModRuleData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public AutoModRuleData getData() {
        return this.data;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public Snowflake getGuildId() {
        return Snowflake.of((Id)this.data.guildId());
    }

    public Snowflake getCreatorId() {
        return Snowflake.of((Id)this.data.creatorId());
    }

    public Mono<User> getCreatorUser() {
        return this.getClient().getUserById(this.getCreatorId());
    }

    public boolean isEnabled() {
        return this.data.enabled();
    }

    public String getName() {
        return this.data.name();
    }

    public TriggerType getTriggerType() {
        return TriggerType.of(this.data.triggerType());
    }

    public AutoModRuleTriggerMetaData getTriggerMetaData() {
        return new AutoModRuleTriggerMetaData(this.gateway, this.data.triggerMetadata());
    }

    public List<AutoModRuleAction> getActions() {
        return this.data.actions().stream().map(data -> new AutoModRuleAction(this.gateway, (AutoModActionData)data)).collect(Collectors.toList());
    }

    public EventType getEventType() {
        return EventType.of(this.data.eventType());
    }

    public List<Snowflake> getExemptRolesIds() {
        return this.data.exemptRoles().stream().map(Snowflake::of).collect(Collectors.toList());
    }

    public List<Snowflake> getExemptChannelsIds() {
        return this.data.exemptChannels().stream().map(Snowflake::of).collect(Collectors.toList());
    }

    public Mono<AutoModRule> edit(AutoModRuleEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.gateway.getRestClient().getAutoModService().modifyAutoModRule(this.getGuildId().asLong(), this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> new AutoModRule(this.gateway, (AutoModRuleData)data));
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.gateway.getRestClient().getAutoModService().deleteAutoModRule(this.getGuildId().asLong(), this.getId().asLong(), reason);
    }

    public static enum EventType {
        UNKNOWN(-1),
        MESSAGE_SEND(1),
        MEMBER_UPDATE(2);

        private final int value;

        private EventType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static EventType of(int value) {
            for (EventType eventType : EventType.values()) {
                if (eventType.getValue() != value) continue;
                return eventType;
            }
            return UNKNOWN;
        }
    }

    public static enum TriggerType {
        UNKNOWN(-1),
        KEYWORD(1),
        HARMFUL_LINK(2),
        SPAM(3),
        KEYWORD_PRESET(4),
        MENTION_SPAM(5),
        MEMBER_PROFILE(6);

        private final int value;

        private TriggerType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static TriggerType of(int value) {
            for (TriggerType type : TriggerType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

