/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.discordjson.json.ApplicationRoleConnectionMetadataData;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class ApplicationRoleConnectionMetadata {
    private final ApplicationRoleConnectionMetadataData data;

    public ApplicationRoleConnectionMetadata(ApplicationRoleConnectionMetadataData data) {
        this.data = data;
    }

    public ApplicationRoleConnectionMetadataData getData() {
        return this.data;
    }

    public Type getType() {
        return Type.from(this.data.type());
    }

    public String getKey() {
        return this.data.key();
    }

    public String getName() {
        return this.data.name();
    }

    public String getDescription() {
        return this.data.description();
    }

    public Map<Locale, String> getLocalizedNames() {
        return this.data.nameLocalizations().toOptional().orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(entry -> new Locale.Builder().setLanguageTag((String)entry.getKey()).build(), Map.Entry::getValue));
    }

    public Map<Locale, String> getLocalizedDescriptions() {
        return this.data.descriptionLocalizations().toOptional().orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(entry -> new Locale.Builder().setLanguageTag((String)entry.getKey()).build(), Map.Entry::getValue));
    }

    public static enum Type {
        UNKNOWN(-1),
        INTEGER_LESS_THAN_OR_EQUAL(1),
        INTEGER_GREATER_THAN_OR_EQUAL(2),
        INTEGER_EQUAL(3),
        INTEGER_NOT_EQUAL(4),
        DATETIME_LESS_THAN_OR_EQUAL(5),
        DATETIME_GREATER_THAN_OR_EQUAL(6),
        BOOLEAN_EQUAL(7),
        BOOLEAN_NOT_EQUAL(8);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type from(int value) {
            switch (value) {
                case 1: {
                    return INTEGER_LESS_THAN_OR_EQUAL;
                }
                case 2: {
                    return INTEGER_GREATER_THAN_OR_EQUAL;
                }
                case 3: {
                    return INTEGER_EQUAL;
                }
                case 4: {
                    return INTEGER_NOT_EQUAL;
                }
                case 5: {
                    return DATETIME_LESS_THAN_OR_EQUAL;
                }
                case 6: {
                    return DATETIME_GREATER_THAN_OR_EQUAL;
                }
                case 7: {
                    return BOOLEAN_EQUAL;
                }
                case 8: {
                    return BOOLEAN_NOT_EQUAL;
                }
            }
            return UNKNOWN;
        }
    }
}

