/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.channel.ChannelEvent;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.gateway.ShardInfo;
import java.time.Instant;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class TypingStartEvent
extends ChannelEvent {
    private final long channelId;
    @Nullable
    private final Long guildId;
    private final long userId;
    private final Instant startTime;
    @Nullable
    private final Member member;

    public TypingStartEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long channelId, @Nullable Long guildId, long userId, Instant startTime, @Nullable Member member) {
        super(gateway, shardInfo);
        this.channelId = channelId;
        this.guildId = guildId;
        this.userId = userId;
        this.startTime = startTime;
        this.member = member;
    }

    public Snowflake getChannelId() {
        return Snowflake.of((long)this.channelId);
    }

    public Optional<Snowflake> getGuildId() {
        return Optional.ofNullable(this.guildId).map(Snowflake::of);
    }

    public Mono<MessageChannel> getChannel() {
        return this.getClient().getChannelById(this.getChannelId()).cast(MessageChannel.class);
    }

    public Snowflake getUserId() {
        return Snowflake.of((long)this.userId);
    }

    public Mono<User> getUser() {
        return this.getClient().getUserById(this.getUserId());
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Optional<Member> getMember() {
        return Optional.ofNullable(this.member);
    }

    public String toString() {
        return "TypingStartEvent{channelId=" + this.channelId + ", guildId=" + this.guildId + ", userId=" + this.userId + ", startTime=" + this.startTime + ", member=" + this.member + '}';
    }
}

