/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.util;

import java.time.Instant;

public enum TimestampFormat {
    DEFAULT(""),
    SHORT_TIME("t"),
    LONG_TIME("T"),
    SHORT_DATE("d"),
    LONG_DATE("D"),
    SHORT_DATE_TIME("f"),
    LONG_DATE_TIME("F"),
    RELATIVE_TIME("R");

    private final String style;

    private TimestampFormat(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    public String format(Instant instant) {
        if (this.style.isEmpty()) {
            return "<t:" + instant.getEpochSecond() + ">";
        }
        return "<t:" + instant.getEpochSecond() + ":" + this.style + ">";
    }
}

