/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.close;

import reactor.util.annotation.Nullable;

public class DisconnectBehavior {
    private final Action action;
    private final Throwable cause;

    public static DisconnectBehavior retry(@Nullable Throwable cause) {
        return new DisconnectBehavior(Action.RETRY, cause);
    }

    public static DisconnectBehavior stop(@Nullable Throwable cause) {
        return new DisconnectBehavior(Action.STOP, cause);
    }

    public static DisconnectBehavior retryAbruptly(@Nullable Throwable cause) {
        return new DisconnectBehavior(Action.RETRY_ABRUPTLY, cause);
    }

    public static DisconnectBehavior stopAbruptly(@Nullable Throwable cause) {
        return new DisconnectBehavior(Action.STOP_ABRUPTLY, cause);
    }

    private DisconnectBehavior(Action action, @Nullable Throwable cause) {
        this.action = action;
        this.cause = cause;
    }

    public Action getAction() {
        return this.action;
    }

    @Nullable
    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        return String.format("%s%s", new Object[]{this.action, this.cause != null ? " due to " + this.cause : ""});
    }

    public static enum Action {
        RETRY,
        STOP,
        RETRY_ABRUPTLY,
        STOP_ABRUPTLY;

    }
}

