/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.legacy.LegacyAuditSpec;
import discord4j.discordjson.json.ChannelCreateRequest;
import discord4j.discordjson.json.ImmutableChannelCreateRequest;
import discord4j.discordjson.possible.Possible;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class LegacyNewsChannelCreateSpec
implements LegacyAuditSpec<ChannelCreateRequest> {
    private final ImmutableChannelCreateRequest.Builder requestBuilder = ChannelCreateRequest.builder().type(Integer.valueOf(Channel.Type.GUILD_NEWS.getValue()));
    @Nullable
    private String reason;

    public LegacyNewsChannelCreateSpec setName(String name) {
        this.requestBuilder.name(name);
        return this;
    }

    public LegacyNewsChannelCreateSpec setTopic(String topic) {
        this.requestBuilder.topic(topic);
        return this;
    }

    public LegacyNewsChannelCreateSpec setPosition(int position) {
        this.requestBuilder.position(Integer.valueOf(position));
        return this;
    }

    public LegacyNewsChannelCreateSpec setPermissionOverwrites(Set<? extends PermissionOverwrite> permissionOverwrites) {
        List raw = permissionOverwrites.stream().map(PermissionOverwrite::getData).collect(Collectors.toList());
        this.requestBuilder.permissionOverwrites(raw);
        return this;
    }

    public LegacyNewsChannelCreateSpec setParentId(@Nullable Snowflake parentId) {
        this.requestBuilder.parentId(parentId == null ? Possible.absent() : Possible.of((Object)parentId.asString()));
        return this;
    }

    public LegacyNewsChannelCreateSpec setNsfw(boolean nsfw) {
        this.requestBuilder.nsfw(Boolean.valueOf(nsfw));
        return this;
    }

    public LegacyNewsChannelCreateSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public ChannelCreateRequest asRequest() {
        return this.requestBuilder.build();
    }
}

