/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.common.util.Snowflake;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.legacy.LegacyRoleCreateSpec;
import discord4j.core.spec.legacy.LegacySpec;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.GuildCreateRequest;
import discord4j.discordjson.json.ImmutableGuildCreateRequest;
import discord4j.discordjson.json.PartialChannelCreateRequest;
import discord4j.discordjson.json.RoleCreateRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import reactor.util.annotation.Nullable;

public class LegacyGuildCreateSpec
implements LegacySpec<GuildCreateRequest> {
    private final ImmutableGuildCreateRequest.Builder builder = GuildCreateRequest.builder();
    private final List<RoleCreateRequest> roles = new ArrayList<RoleCreateRequest>();

    public LegacyGuildCreateSpec setName(String name) {
        this.builder.name(name);
        return this;
    }

    public LegacyGuildCreateSpec setRegion(Region.Id regionId) {
        this.builder.region(regionId.getValue());
        return this;
    }

    public LegacyGuildCreateSpec setRegion(@Nullable String regionId) {
        this.builder.region(regionId == null ? Possible.absent() : Possible.of((Object)regionId));
        return this;
    }

    public LegacyGuildCreateSpec setIcon(@Nullable Image icon) {
        this.builder.icon(icon == null ? Possible.absent() : Possible.of((Object)icon.getDataUri()));
        return this;
    }

    public LegacyGuildCreateSpec setVerificationLevel(@Nullable Guild.VerificationLevel verificationLevel) {
        this.builder.verificationLevel(verificationLevel == null ? Possible.absent() : Possible.of((Object)verificationLevel.getValue()));
        return this;
    }

    public LegacyGuildCreateSpec setDefaultMessageNotificationLevel(@Nullable Guild.NotificationLevel notificationLevel) {
        this.builder.defaultMessageNotifications(notificationLevel == null ? Possible.absent() : Possible.of((Object)notificationLevel.getValue()));
        return this;
    }

    public LegacyGuildCreateSpec setExplicitContentFilter(@Nullable Guild.ContentFilterLevel explicitContentFilter) {
        this.builder.explicitContentFilter(explicitContentFilter == null ? Possible.absent() : Possible.of((Object)explicitContentFilter.getValue()));
        return this;
    }

    public LegacyGuildCreateSpec addRole(Consumer<? super LegacyRoleCreateSpec> legacyroleSpec) {
        LegacyRoleCreateSpec mutatedSpec = new LegacyRoleCreateSpec();
        legacyroleSpec.accept(mutatedSpec);
        this.roles.add(mutatedSpec.asRequest());
        return this;
    }

    public LegacyGuildCreateSpec addEveryoneRole(Consumer<? super LegacyRoleCreateSpec> legacyroleSpec) {
        LegacyRoleCreateSpec mutatedSpec = new LegacyRoleCreateSpec();
        legacyroleSpec.accept(mutatedSpec);
        this.roles.add(0, mutatedSpec.asRequest());
        return this;
    }

    public LegacyGuildCreateSpec addChannel(String name, Channel.Type type) {
        this.builder.addChannel((PartialChannelCreateRequest)PartialChannelCreateRequest.builder().name(name).type(type.getValue()).build());
        return this;
    }

    public LegacyGuildCreateSpec setAfkChannelId(@Nullable Snowflake id) {
        this.builder.afkChannelId(id == null ? Possible.absent() : Possible.of((Object)Id.of((long)id.asLong())));
        return this;
    }

    public LegacyGuildCreateSpec setAfkTimeout(@Nullable Integer afkTimeout) {
        this.builder.afkTimeout(afkTimeout == null ? Possible.absent() : Possible.of((Object)afkTimeout));
        return this;
    }

    public LegacyGuildCreateSpec setSystemChannelId(@Nullable Snowflake id) {
        this.builder.systemChannelId(id == null ? Possible.absent() : Possible.of((Object)Id.of((long)id.asLong())));
        return this;
    }

    public LegacyGuildCreateSpec setSystemChannelFlags(Guild.SystemChannelFlag ... flags) {
        if (flags != null) {
            this.builder.systemChannelFlags(Possible.of((Object)Arrays.stream(flags).mapToInt(Guild.SystemChannelFlag::getValue).reduce(0, (left, right) -> left | right)));
        } else {
            this.builder.systemChannelFlags(Possible.absent());
        }
        return this;
    }

    @Override
    public GuildCreateRequest asRequest() {
        this.builder.roles(this.roles);
        return this.builder.build();
    }
}

