/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.SoundboardSoundEditSpecGenerator;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class SoundboardSoundEditSpec
implements SoundboardSoundEditSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final String sound_value;
    private final boolean sound_absent;
    private final Double volume_value;
    private final boolean volume_absent;
    private final EmojiData emoji_value;
    private final boolean emoji_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SoundboardSoundEditSpec(@reactor.util.annotation.Nullable String reason, Possible<String> name, Possible<String> sound, Possible<Optional<Double>> volume, Possible<Optional<EmojiData>> emoji) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<String> sound$impl = sound;
        Possible<Optional<Double>> volume$impl = volume;
        Possible<Optional<EmojiData>> emoji$impl = emoji;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.sound_value = sound$impl.toOptional().orElse(null);
        this.sound_absent = sound$impl.isAbsent();
        this.volume_value = Possible.flatOpt(volume$impl).orElse(null);
        this.volume_absent = volume$impl.isAbsent();
        this.emoji_value = Possible.flatOpt(emoji$impl).orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<String> sound() {
        return this.sound_absent ? Possible.absent() : Possible.of((Object)this.sound_value);
    }

    @Override
    public Possible<Optional<Double>> volume() {
        return this.volume_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.volume_value));
    }

    @Override
    public Possible<Optional<EmojiData>> emoji() {
        return this.emoji_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.emoji_value));
    }

    public final SoundboardSoundEditSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new SoundboardSoundEditSpec(value, this.name(), this.sound(), this.volume(), this.emoji());
    }

    public SoundboardSoundEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundEditSpec(this.reason, newValue, this.sound(), this.volume(), this.emoji());
    }

    public SoundboardSoundEditSpec withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return new SoundboardSoundEditSpec(this.reason, (Possible<String>)newValue, this.sound(), this.volume(), this.emoji());
    }

    public SoundboardSoundEditSpec withSound(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundEditSpec(this.reason, this.name(), newValue, this.volume(), this.emoji());
    }

    public SoundboardSoundEditSpec withSound(String value) {
        Possible newValue = Possible.of((Object)value);
        return new SoundboardSoundEditSpec(this.reason, this.name(), (Possible<String>)newValue, this.volume(), this.emoji());
    }

    public SoundboardSoundEditSpec withVolume(Possible<Optional<Double>> value) {
        Possible<Optional<Double>> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundEditSpec(this.reason, this.name(), this.sound(), newValue, this.emoji());
    }

    @Deprecated
    public SoundboardSoundEditSpec withVolume(@Nullable Double value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundEditSpec(this.reason, this.name(), this.sound(), (Possible<Optional<Double>>)newValue, this.emoji());
    }

    public SoundboardSoundEditSpec withVolumeOrNull(@Nullable Double value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundEditSpec(this.reason, this.name(), this.sound(), (Possible<Optional<Double>>)newValue, this.emoji());
    }

    public SoundboardSoundEditSpec withEmoji(Possible<Optional<EmojiData>> value) {
        Possible<Optional<EmojiData>> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundEditSpec(this.reason, this.name(), this.sound(), this.volume(), newValue);
    }

    @Deprecated
    public SoundboardSoundEditSpec withEmoji(@Nullable EmojiData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundEditSpec(this.reason, this.name(), this.sound(), this.volume(), (Possible<Optional<EmojiData>>)newValue);
    }

    public SoundboardSoundEditSpec withEmojiOrNull(@Nullable EmojiData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundEditSpec(this.reason, this.name(), this.sound(), this.volume(), (Possible<Optional<EmojiData>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SoundboardSoundEditSpec && this.equalTo(0, (SoundboardSoundEditSpec)another);
    }

    private boolean equalTo(int synthetic, SoundboardSoundEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.sound().equals(another.sound()) && this.volume().equals(another.volume()) && this.emoji().equals(another.emoji());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.sound().hashCode();
        h += (h << 5) + this.volume().hashCode();
        h += (h << 5) + this.emoji().hashCode();
        return h;
    }

    public String toString() {
        return "SoundboardSoundEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", sound=" + this.sound().toString() + ", volume=" + this.volume().toString() + ", emoji=" + this.emoji().toString() + "}";
    }

    public static SoundboardSoundEditSpec copyOf(SoundboardSoundEditSpecGenerator instance) {
        if (instance instanceof SoundboardSoundEditSpec) {
            return (SoundboardSoundEditSpec)instance;
        }
        return SoundboardSoundEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isSoundPresent() {
        return !this.sound_absent;
    }

    public String soundOrElse(String defaultValue) {
        return !this.sound_absent ? this.sound_value : defaultValue;
    }

    public boolean isVolumePresent() {
        return !this.volume_absent;
    }

    public Double volumeOrElse(Double defaultValue) {
        return !this.volume_absent ? this.volume_value : defaultValue;
    }

    public boolean isEmojiPresent() {
        return !this.emoji_absent;
    }

    public EmojiData emojiOrElse(EmojiData defaultValue) {
        return !this.emoji_absent ? this.emoji_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<String> sound_possible = Possible.absent();
        private Possible<Optional<Double>> volume_possible = Possible.absent();
        private Possible<Optional<EmojiData>> emoji_possible = Possible.absent();
        @Nullable
        private String reason;

        private Builder() {
        }

        public final Builder from(SoundboardSoundEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.sound(instance.sound());
            this.volume(instance.volume());
            this.emoji(instance.emoji());
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        public Builder sound(Possible<String> value) {
            this.sound_possible = value;
            return this;
        }

        public Builder sound(String value) {
            this.sound_possible = Possible.of((Object)value);
            return this;
        }

        public Builder volume(Possible<Optional<Double>> value) {
            this.volume_possible = value;
            return this;
        }

        @Deprecated
        public Builder volume(@Nullable Double value) {
            this.volume_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder volumeOrNull(@Nullable Double value) {
            this.volume_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder emoji(Possible<Optional<EmojiData>> value) {
            this.emoji_possible = value;
            return this;
        }

        @Deprecated
        public Builder emoji(@Nullable EmojiData value) {
            this.emoji_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder emojiOrNull(@Nullable EmojiData value) {
            this.emoji_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public SoundboardSoundEditSpec build() {
            return new SoundboardSoundEditSpec(this.reason, this.name_build(), this.sound_build(), this.volume_build(), this.emoji_build());
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<String> sound_build() {
            return this.sound_possible;
        }

        private Possible<Optional<Double>> volume_build() {
            return this.volume_possible;
        }

        private Possible<Optional<EmojiData>> emoji_build() {
            return this.emoji_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SoundboardSoundEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

