/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.ScheduledEvent;
import discord4j.core.spec.RecurrenceRuleSpec;
import discord4j.core.spec.ScheduledEventCreateSpecGenerator;
import discord4j.core.spec.ScheduledEventEntityMetadataSpec;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ScheduledEventCreateSpec
implements ScheduledEventCreateSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final Snowflake channelId_value;
    private final boolean channelId_absent;
    private final ScheduledEventEntityMetadataSpec entityMetadata_value;
    private final boolean entityMetadata_absent;
    private final String name;
    private final ScheduledEvent.PrivacyLevel privacyLevel;
    private final Instant scheduledStartTime;
    private final Instant scheduledEndTime_value;
    private final boolean scheduledEndTime_absent;
    private final String description_value;
    private final boolean description_absent;
    private final ScheduledEvent.EntityType entityType;
    private final Image image_value;
    private final boolean image_absent;
    private final RecurrenceRuleSpec recurrenceRule_value;
    private final boolean recurrenceRule_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ScheduledEventCreateSpec(String name, ScheduledEvent.PrivacyLevel privacyLevel, Instant scheduledStartTime, ScheduledEvent.EntityType entityType) {
        this.name = Objects.requireNonNull(name, "name");
        this.privacyLevel = Objects.requireNonNull(privacyLevel, "privacyLevel");
        this.scheduledStartTime = Objects.requireNonNull(scheduledStartTime, "scheduledStartTime");
        this.entityType = Objects.requireNonNull(entityType, "entityType");
        this.reason = null;
        Possible channelId$impl = Possible.absent();
        Possible entityMetadata$impl = Possible.absent();
        Possible scheduledEndTime$impl = Possible.absent();
        Possible description$impl = Possible.absent();
        Possible image$impl = Possible.absent();
        Possible recurrenceRule$impl = Possible.absent();
        this.channelId_value = channelId$impl.toOptional().orElse(null);
        this.channelId_absent = channelId$impl.isAbsent();
        this.entityMetadata_value = entityMetadata$impl.toOptional().orElse(null);
        this.entityMetadata_absent = entityMetadata$impl.isAbsent();
        this.scheduledEndTime_value = scheduledEndTime$impl.toOptional().orElse(null);
        this.scheduledEndTime_absent = scheduledEndTime$impl.isAbsent();
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.image_value = image$impl.toOptional().orElse(null);
        this.image_absent = image$impl.isAbsent();
        this.recurrenceRule_value = recurrenceRule$impl.toOptional().orElse(null);
        this.recurrenceRule_absent = recurrenceRule$impl.isAbsent();
        this.initShim = null;
    }

    private ScheduledEventCreateSpec(@reactor.util.annotation.Nullable String reason, Possible<Snowflake> channelId, Possible<ScheduledEventEntityMetadataSpec> entityMetadata, String name, ScheduledEvent.PrivacyLevel privacyLevel, Instant scheduledStartTime, Possible<Instant> scheduledEndTime, Possible<String> description, ScheduledEvent.EntityType entityType, Possible<Image> image, Possible<RecurrenceRuleSpec> recurrenceRule) {
        this.reason = reason;
        Possible<Snowflake> channelId$impl = channelId;
        Possible<ScheduledEventEntityMetadataSpec> entityMetadata$impl = entityMetadata;
        this.name = name;
        this.privacyLevel = privacyLevel;
        this.scheduledStartTime = scheduledStartTime;
        Possible<Instant> scheduledEndTime$impl = scheduledEndTime;
        Possible<String> description$impl = description;
        this.entityType = entityType;
        Possible<Image> image$impl = image;
        Possible<RecurrenceRuleSpec> recurrenceRule$impl = recurrenceRule;
        this.channelId_value = channelId$impl.toOptional().orElse(null);
        this.channelId_absent = channelId$impl.isAbsent();
        this.entityMetadata_value = entityMetadata$impl.toOptional().orElse(null);
        this.entityMetadata_absent = entityMetadata$impl.isAbsent();
        this.scheduledEndTime_value = scheduledEndTime$impl.toOptional().orElse(null);
        this.scheduledEndTime_absent = scheduledEndTime$impl.isAbsent();
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.image_value = image$impl.toOptional().orElse(null);
        this.image_absent = image$impl.isAbsent();
        this.recurrenceRule_value = recurrenceRule$impl.toOptional().orElse(null);
        this.recurrenceRule_absent = recurrenceRule$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<Snowflake> channelId() {
        return this.channelId_absent ? Possible.absent() : Possible.of((Object)this.channelId_value);
    }

    @Override
    public Possible<ScheduledEventEntityMetadataSpec> entityMetadata() {
        return this.entityMetadata_absent ? Possible.absent() : Possible.of((Object)this.entityMetadata_value);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ScheduledEvent.PrivacyLevel privacyLevel() {
        return this.privacyLevel;
    }

    @Override
    public Instant scheduledStartTime() {
        return this.scheduledStartTime;
    }

    @Override
    public Possible<Instant> scheduledEndTime() {
        return this.scheduledEndTime_absent ? Possible.absent() : Possible.of((Object)this.scheduledEndTime_value);
    }

    @Override
    public Possible<String> description() {
        return this.description_absent ? Possible.absent() : Possible.of((Object)this.description_value);
    }

    @Override
    public ScheduledEvent.EntityType entityType() {
        return this.entityType;
    }

    @Override
    public Possible<Image> image() {
        return this.image_absent ? Possible.absent() : Possible.of((Object)this.image_value);
    }

    @Override
    public Possible<RecurrenceRuleSpec> recurrenceRule() {
        return this.recurrenceRule_absent ? Possible.absent() : Possible.of((Object)this.recurrenceRule_value);
    }

    public final ScheduledEventCreateSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new ScheduledEventCreateSpec(value, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.recurrenceRule());
    }

    public ScheduledEventCreateSpec withChannelId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new ScheduledEventCreateSpec(this.reason, newValue, this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.recurrenceRule());
    }

    public ScheduledEventCreateSpec withChannelId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new ScheduledEventCreateSpec(this.reason, (Possible<Snowflake>)newValue, this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.recurrenceRule());
    }

    public ScheduledEventCreateSpec withEntityMetadata(Possible<ScheduledEventEntityMetadataSpec> value) {
        Possible<ScheduledEventEntityMetadataSpec> newValue = Objects.requireNonNull(value);
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), newValue, this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.recurrenceRule());
    }

    public ScheduledEventCreateSpec withEntityMetadata(ScheduledEventEntityMetadataSpec value) {
        Possible newValue = Possible.of((Object)value);
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), (Possible<ScheduledEventEntityMetadataSpec>)newValue, this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.recurrenceRule());
    }

    public final ScheduledEventCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), newValue, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.recurrenceRule());
    }

    public final ScheduledEventCreateSpec withPrivacyLevel(ScheduledEvent.PrivacyLevel value) {
        ScheduledEvent.PrivacyLevel newValue = Objects.requireNonNull(value, "privacyLevel");
        if (this.privacyLevel == newValue) {
            return this;
        }
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), this.name, newValue, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.recurrenceRule());
    }

    public final ScheduledEventCreateSpec withScheduledStartTime(Instant value) {
        if (this.scheduledStartTime == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "scheduledStartTime");
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, newValue, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.recurrenceRule());
    }

    public ScheduledEventCreateSpec withScheduledEndTime(Possible<Instant> value) {
        Possible<Instant> newValue = Objects.requireNonNull(value);
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, newValue, this.description(), this.entityType, this.image(), this.recurrenceRule());
    }

    public ScheduledEventCreateSpec withScheduledEndTime(Instant value) {
        Possible newValue = Possible.of((Object)value);
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, (Possible<Instant>)newValue, this.description(), this.entityType, this.image(), this.recurrenceRule());
    }

    public ScheduledEventCreateSpec withDescription(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), newValue, this.entityType, this.image(), this.recurrenceRule());
    }

    public ScheduledEventCreateSpec withDescription(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), (Possible<String>)newValue, this.entityType, this.image(), this.recurrenceRule());
    }

    public final ScheduledEventCreateSpec withEntityType(ScheduledEvent.EntityType value) {
        ScheduledEvent.EntityType newValue = Objects.requireNonNull(value, "entityType");
        if (this.entityType == newValue) {
            return this;
        }
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), newValue, this.image(), this.recurrenceRule());
    }

    public ScheduledEventCreateSpec withImage(Possible<Image> value) {
        Possible<Image> newValue = Objects.requireNonNull(value);
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, newValue, this.recurrenceRule());
    }

    public ScheduledEventCreateSpec withImage(Image value) {
        Possible newValue = Possible.of((Object)value);
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, (Possible<Image>)newValue, this.recurrenceRule());
    }

    public ScheduledEventCreateSpec withRecurrenceRule(Possible<RecurrenceRuleSpec> value) {
        Possible<RecurrenceRuleSpec> newValue = Objects.requireNonNull(value);
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), newValue);
    }

    public ScheduledEventCreateSpec withRecurrenceRule(RecurrenceRuleSpec value) {
        Possible newValue = Possible.of((Object)value);
        return new ScheduledEventCreateSpec(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), (Possible<RecurrenceRuleSpec>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScheduledEventCreateSpec && this.equalTo(0, (ScheduledEventCreateSpec)another);
    }

    private boolean equalTo(int synthetic, ScheduledEventCreateSpec another) {
        return Objects.equals(this.reason, another.reason) && this.channelId().equals(another.channelId()) && this.entityMetadata().equals(another.entityMetadata()) && this.name.equals(another.name) && this.privacyLevel.equals((Object)another.privacyLevel) && this.scheduledStartTime.equals(another.scheduledStartTime) && this.scheduledEndTime().equals(another.scheduledEndTime()) && this.description().equals(another.description()) && this.entityType.equals((Object)another.entityType) && this.image().equals(another.image()) && this.recurrenceRule().equals(another.recurrenceRule());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.channelId().hashCode();
        h += (h << 5) + this.entityMetadata().hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.privacyLevel.hashCode();
        h += (h << 5) + this.scheduledStartTime.hashCode();
        h += (h << 5) + this.scheduledEndTime().hashCode();
        h += (h << 5) + this.description().hashCode();
        h += (h << 5) + this.entityType.hashCode();
        h += (h << 5) + this.image().hashCode();
        h += (h << 5) + this.recurrenceRule().hashCode();
        return h;
    }

    public String toString() {
        return "ScheduledEventCreateSpec{reason=" + this.reason + ", channelId=" + this.channelId().toString() + ", entityMetadata=" + this.entityMetadata().toString() + ", name=" + this.name + ", privacyLevel=" + (Object)((Object)this.privacyLevel) + ", scheduledStartTime=" + this.scheduledStartTime + ", scheduledEndTime=" + this.scheduledEndTime().toString() + ", description=" + this.description().toString() + ", entityType=" + (Object)((Object)this.entityType) + ", image=" + this.image().toString() + ", recurrenceRule=" + this.recurrenceRule().toString() + "}";
    }

    public static ScheduledEventCreateSpec of(String name, ScheduledEvent.PrivacyLevel privacyLevel, Instant scheduledStartTime, ScheduledEvent.EntityType entityType) {
        return new ScheduledEventCreateSpec(name, privacyLevel, scheduledStartTime, entityType);
    }

    public static ScheduledEventCreateSpec copyOf(ScheduledEventCreateSpecGenerator instance) {
        if (instance instanceof ScheduledEventCreateSpec) {
            return (ScheduledEventCreateSpec)instance;
        }
        return ScheduledEventCreateSpec.builder().from(instance).build();
    }

    public boolean isChannelIdPresent() {
        return !this.channelId_absent;
    }

    public Snowflake channelIdOrElse(Snowflake defaultValue) {
        return !this.channelId_absent ? this.channelId_value : defaultValue;
    }

    public boolean isEntityMetadataPresent() {
        return !this.entityMetadata_absent;
    }

    public ScheduledEventEntityMetadataSpec entityMetadataOrElse(ScheduledEventEntityMetadataSpec defaultValue) {
        return !this.entityMetadata_absent ? this.entityMetadata_value : defaultValue;
    }

    public boolean isScheduledEndTimePresent() {
        return !this.scheduledEndTime_absent;
    }

    public Instant scheduledEndTimeOrElse(Instant defaultValue) {
        return !this.scheduledEndTime_absent ? this.scheduledEndTime_value : defaultValue;
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public boolean isImagePresent() {
        return !this.image_absent;
    }

    public Image imageOrElse(Image defaultValue) {
        return !this.image_absent ? this.image_value : defaultValue;
    }

    public boolean isRecurrenceRulePresent() {
        return !this.recurrenceRule_absent;
    }

    public RecurrenceRuleSpec recurrenceRuleOrElse(RecurrenceRuleSpec defaultValue) {
        return !this.recurrenceRule_absent ? this.recurrenceRule_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_PRIVACY_LEVEL = 2L;
        private static final long INIT_BIT_SCHEDULED_START_TIME = 4L;
        private static final long INIT_BIT_ENTITY_TYPE = 8L;
        private long initBits = 15L;
        private Possible<Snowflake> channelId_possible = Possible.absent();
        private Possible<ScheduledEventEntityMetadataSpec> entityMetadata_possible = Possible.absent();
        private Possible<Instant> scheduledEndTime_possible = Possible.absent();
        private Possible<String> description_possible = Possible.absent();
        private Possible<Image> image_possible = Possible.absent();
        private Possible<RecurrenceRuleSpec> recurrenceRule_possible = Possible.absent();
        @Nullable
        private String reason;
        @Nullable
        private String name;
        @Nullable
        private ScheduledEvent.PrivacyLevel privacyLevel;
        @Nullable
        private Instant scheduledStartTime;
        @Nullable
        private ScheduledEvent.EntityType entityType;

        private Builder() {
        }

        public final Builder from(ScheduledEventCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.channelId(instance.channelId());
            this.entityMetadata(instance.entityMetadata());
            this.name(instance.name());
            this.privacyLevel(instance.privacyLevel());
            this.scheduledStartTime(instance.scheduledStartTime());
            this.scheduledEndTime(instance.scheduledEndTime());
            this.description(instance.description());
            this.entityType(instance.entityType());
            this.image(instance.image());
            this.recurrenceRule(instance.recurrenceRule());
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public Builder channelId(Possible<Snowflake> value) {
            this.channelId_possible = value;
            return this;
        }

        public Builder channelId(Snowflake value) {
            this.channelId_possible = Possible.of((Object)value);
            return this;
        }

        public Builder entityMetadata(Possible<ScheduledEventEntityMetadataSpec> value) {
            this.entityMetadata_possible = value;
            return this;
        }

        public Builder entityMetadata(ScheduledEventEntityMetadataSpec value) {
            this.entityMetadata_possible = Possible.of((Object)value);
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder privacyLevel(ScheduledEvent.PrivacyLevel privacyLevel) {
            this.privacyLevel = Objects.requireNonNull(privacyLevel, "privacyLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder scheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = Objects.requireNonNull(scheduledStartTime, "scheduledStartTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder scheduledEndTime(Possible<Instant> value) {
            this.scheduledEndTime_possible = value;
            return this;
        }

        public Builder scheduledEndTime(Instant value) {
            this.scheduledEndTime_possible = Possible.of((Object)value);
            return this;
        }

        public Builder description(Possible<String> value) {
            this.description_possible = value;
            return this;
        }

        public Builder description(String value) {
            this.description_possible = Possible.of((Object)value);
            return this;
        }

        public final Builder entityType(ScheduledEvent.EntityType entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder image(Possible<Image> value) {
            this.image_possible = value;
            return this;
        }

        public Builder image(Image value) {
            this.image_possible = Possible.of((Object)value);
            return this;
        }

        public Builder recurrenceRule(Possible<RecurrenceRuleSpec> value) {
            this.recurrenceRule_possible = value;
            return this;
        }

        public Builder recurrenceRule(RecurrenceRuleSpec value) {
            this.recurrenceRule_possible = Possible.of((Object)value);
            return this;
        }

        public ScheduledEventCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ScheduledEventCreateSpec(this.reason, this.channelId_build(), this.entityMetadata_build(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime_build(), this.description_build(), this.entityType, this.image_build(), this.recurrenceRule_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("privacyLevel");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("scheduledStartTime");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("entityType");
            }
            return "Cannot build ScheduledEventCreateSpec, some of required attributes are not set " + attributes;
        }

        private Possible<Snowflake> channelId_build() {
            return this.channelId_possible;
        }

        private Possible<ScheduledEventEntityMetadataSpec> entityMetadata_build() {
            return this.entityMetadata_possible;
        }

        private Possible<Instant> scheduledEndTime_build() {
            return this.scheduledEndTime_possible;
        }

        private Possible<String> description_build() {
            return this.description_possible;
        }

        private Possible<Image> image_build() {
            return this.image_possible;
        }

        private Possible<RecurrenceRuleSpec> recurrenceRule_build() {
            return this.recurrenceRule_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ScheduledEventCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

