/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.RecurrenceRule;
import discord4j.core.spec.RecurrenceRuleNWeekdaySpec;
import discord4j.core.spec.RecurrenceRuleSpecGenerator;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class RecurrenceRuleSpec
implements RecurrenceRuleSpecGenerator {
    private final Instant start;
    @Nullable
    private final Instant end;
    private final RecurrenceRule.Frequency frequency;
    private final int interval;
    @Nullable
    private final List<DayOfWeek> byWeekday;
    @Nullable
    private final List<RecurrenceRuleNWeekdaySpec> byNWeekday;
    @Nullable
    private final List<Month> byMonth;
    @Nullable
    private final List<Integer> byMonthDay;
    @Nullable
    private final List<Integer> byYearDay;
    @Nullable
    private final Integer count;

    private RecurrenceRuleSpec(Instant start, RecurrenceRule.Frequency frequency, int interval) {
        this.start = Objects.requireNonNull(start, "start");
        this.frequency = Objects.requireNonNull(frequency, "frequency");
        this.interval = interval;
        this.end = null;
        this.byWeekday = null;
        this.byNWeekday = null;
        this.byMonth = null;
        this.byMonthDay = null;
        this.byYearDay = null;
        this.count = null;
    }

    private RecurrenceRuleSpec(Instant start, @Nullable Instant end, RecurrenceRule.Frequency frequency, int interval, @Nullable List<DayOfWeek> byWeekday, @Nullable List<RecurrenceRuleNWeekdaySpec> byNWeekday, @Nullable List<Month> byMonth, @Nullable List<Integer> byMonthDay, @Nullable List<Integer> byYearDay, @Nullable Integer count) {
        this.start = start;
        this.end = end;
        this.frequency = frequency;
        this.interval = interval;
        this.byWeekday = byWeekday;
        this.byNWeekday = byNWeekday;
        this.byMonth = byMonth;
        this.byMonthDay = byMonthDay;
        this.byYearDay = byYearDay;
        this.count = count;
    }

    @Override
    public Instant start() {
        return this.start;
    }

    @Override
    public Optional<Instant> end() {
        return Optional.ofNullable(this.end);
    }

    @Override
    public RecurrenceRule.Frequency frequency() {
        return this.frequency;
    }

    @Override
    public int interval() {
        return this.interval;
    }

    @Override
    public Optional<List<DayOfWeek>> byWeekday() {
        return Optional.ofNullable(this.byWeekday);
    }

    @Override
    public Optional<List<RecurrenceRuleNWeekdaySpec>> byNWeekday() {
        return Optional.ofNullable(this.byNWeekday);
    }

    @Override
    public Optional<List<Month>> byMonth() {
        return Optional.ofNullable(this.byMonth);
    }

    @Override
    public Optional<List<Integer>> byMonthDay() {
        return Optional.ofNullable(this.byMonthDay);
    }

    @Override
    public Optional<List<Integer>> byYearDay() {
        return Optional.ofNullable(this.byYearDay);
    }

    @Override
    public Optional<Integer> count() {
        return Optional.ofNullable(this.count);
    }

    public final RecurrenceRuleSpec withStart(Instant value) {
        if (this.start == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "start");
        return new RecurrenceRuleSpec(newValue, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withEnd(Instant value) {
        Instant newValue = Objects.requireNonNull(value, "end");
        if (this.end == newValue) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, newValue, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withEnd(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.end == value) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, value, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withFrequency(RecurrenceRule.Frequency value) {
        RecurrenceRule.Frequency newValue = Objects.requireNonNull(value, "frequency");
        if (this.frequency == newValue) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, newValue, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withInterval(int value) {
        if (this.interval == value) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, value, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withByWeekday(List<DayOfWeek> value) {
        List<DayOfWeek> newValue = Objects.requireNonNull(value, "byWeekday");
        if (this.byWeekday == newValue) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, newValue, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withByWeekday(Optional<? extends List<DayOfWeek>> optional) {
        List value = optional.orElse(null);
        if (this.byWeekday == value) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, value, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withByNWeekday(List<RecurrenceRuleNWeekdaySpec> value) {
        List<RecurrenceRuleNWeekdaySpec> newValue = Objects.requireNonNull(value, "byNWeekday");
        if (this.byNWeekday == newValue) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, this.byWeekday, newValue, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withByNWeekday(Optional<? extends List<RecurrenceRuleNWeekdaySpec>> optional) {
        List value = optional.orElse(null);
        if (this.byNWeekday == value) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, this.byWeekday, value, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withByMonth(List<Month> value) {
        List<Month> newValue = Objects.requireNonNull(value, "byMonth");
        if (this.byMonth == newValue) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, newValue, this.byMonthDay, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withByMonth(Optional<? extends List<Month>> optional) {
        List value = optional.orElse(null);
        if (this.byMonth == value) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, value, this.byMonthDay, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withByMonthDay(List<Integer> value) {
        List<Integer> newValue = Objects.requireNonNull(value, "byMonthDay");
        if (this.byMonthDay == newValue) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, newValue, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withByMonthDay(Optional<? extends List<Integer>> optional) {
        List value = optional.orElse(null);
        if (this.byMonthDay == value) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, value, this.byYearDay, this.count);
    }

    public final RecurrenceRuleSpec withByYearDay(List<Integer> value) {
        List<Integer> newValue = Objects.requireNonNull(value, "byYearDay");
        if (this.byYearDay == newValue) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, newValue, this.count);
    }

    public final RecurrenceRuleSpec withByYearDay(Optional<? extends List<Integer>> optional) {
        List value = optional.orElse(null);
        if (this.byYearDay == value) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, value, this.count);
    }

    public final RecurrenceRuleSpec withCount(int value) {
        Integer newValue = value;
        if (Objects.equals(this.count, newValue)) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, newValue);
    }

    public final RecurrenceRuleSpec withCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.count, value)) {
            return this;
        }
        return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RecurrenceRuleSpec && this.equalTo(0, (RecurrenceRuleSpec)another);
    }

    private boolean equalTo(int synthetic, RecurrenceRuleSpec another) {
        return this.start.equals(another.start) && Objects.equals(this.end, another.end) && this.frequency.equals((Object)another.frequency) && this.interval == another.interval && Objects.equals(this.byWeekday, another.byWeekday) && Objects.equals(this.byNWeekday, another.byNWeekday) && Objects.equals(this.byMonth, another.byMonth) && Objects.equals(this.byMonthDay, another.byMonthDay) && Objects.equals(this.byYearDay, another.byYearDay) && Objects.equals(this.count, another.count);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.start.hashCode();
        h += (h << 5) + Objects.hashCode(this.end);
        h += (h << 5) + this.frequency.hashCode();
        h += (h << 5) + this.interval;
        h += (h << 5) + Objects.hashCode(this.byWeekday);
        h += (h << 5) + Objects.hashCode(this.byNWeekday);
        h += (h << 5) + Objects.hashCode(this.byMonth);
        h += (h << 5) + Objects.hashCode(this.byMonthDay);
        h += (h << 5) + Objects.hashCode(this.byYearDay);
        h += (h << 5) + Objects.hashCode(this.count);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RecurrenceRuleSpec{");
        builder.append("start=").append(this.start);
        if (this.end != null) {
            builder.append(", ");
            builder.append("end=").append(this.end);
        }
        builder.append(", ");
        builder.append("frequency=").append((Object)this.frequency);
        builder.append(", ");
        builder.append("interval=").append(this.interval);
        if (this.byWeekday != null) {
            builder.append(", ");
            builder.append("byWeekday=").append(this.byWeekday);
        }
        if (this.byNWeekday != null) {
            builder.append(", ");
            builder.append("byNWeekday=").append(this.byNWeekday);
        }
        if (this.byMonth != null) {
            builder.append(", ");
            builder.append("byMonth=").append(this.byMonth);
        }
        if (this.byMonthDay != null) {
            builder.append(", ");
            builder.append("byMonthDay=").append(this.byMonthDay);
        }
        if (this.byYearDay != null) {
            builder.append(", ");
            builder.append("byYearDay=").append(this.byYearDay);
        }
        if (this.count != null) {
            builder.append(", ");
            builder.append("count=").append(this.count);
        }
        return builder.append("}").toString();
    }

    public static RecurrenceRuleSpec of(Instant start, RecurrenceRule.Frequency frequency, int interval) {
        return new RecurrenceRuleSpec(start, frequency, interval);
    }

    public static RecurrenceRuleSpec copyOf(RecurrenceRuleSpecGenerator instance) {
        if (instance instanceof RecurrenceRuleSpec) {
            return (RecurrenceRuleSpec)instance;
        }
        return RecurrenceRuleSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_START = 1L;
        private static final long INIT_BIT_FREQUENCY = 2L;
        private static final long INIT_BIT_INTERVAL = 4L;
        private long initBits = 7L;
        @Nullable
        private Instant start;
        @Nullable
        private Instant end;
        @Nullable
        private RecurrenceRule.Frequency frequency;
        private int interval;
        @Nullable
        private List<DayOfWeek> byWeekday;
        @Nullable
        private List<RecurrenceRuleNWeekdaySpec> byNWeekday;
        @Nullable
        private List<Month> byMonth;
        @Nullable
        private List<Integer> byMonthDay;
        @Nullable
        private List<Integer> byYearDay;
        @Nullable
        private Integer count;

        private Builder() {
        }

        public final Builder from(RecurrenceRuleSpecGenerator instance) {
            Optional<Integer> countOptional;
            Optional<List<Integer>> byYearDayOptional;
            Optional<List<Integer>> byMonthDayOptional;
            Optional<List<Month>> byMonthOptional;
            Optional<List<RecurrenceRuleNWeekdaySpec>> byNWeekdayOptional;
            Objects.requireNonNull(instance, "instance");
            this.start(instance.start());
            Optional<Instant> endOptional = instance.end();
            if (endOptional.isPresent()) {
                this.end(endOptional);
            }
            this.frequency(instance.frequency());
            this.interval(instance.interval());
            Optional<List<DayOfWeek>> byWeekdayOptional = instance.byWeekday();
            if (byWeekdayOptional.isPresent()) {
                this.byWeekday(byWeekdayOptional);
            }
            if ((byNWeekdayOptional = instance.byNWeekday()).isPresent()) {
                this.byNWeekday(byNWeekdayOptional);
            }
            if ((byMonthOptional = instance.byMonth()).isPresent()) {
                this.byMonth(byMonthOptional);
            }
            if ((byMonthDayOptional = instance.byMonthDay()).isPresent()) {
                this.byMonthDay(byMonthDayOptional);
            }
            if ((byYearDayOptional = instance.byYearDay()).isPresent()) {
                this.byYearDay(byYearDayOptional);
            }
            if ((countOptional = instance.count()).isPresent()) {
                this.count(countOptional);
            }
            return this;
        }

        public final Builder start(Instant start) {
            this.start = Objects.requireNonNull(start, "start");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder end(Instant end) {
            this.end = Objects.requireNonNull(end, "end");
            return this;
        }

        public final Builder end(Optional<? extends Instant> end) {
            this.end = end.orElse(null);
            return this;
        }

        public final Builder frequency(RecurrenceRule.Frequency frequency) {
            this.frequency = Objects.requireNonNull(frequency, "frequency");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder interval(int interval) {
            this.interval = interval;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder byWeekday(List<DayOfWeek> byWeekday) {
            this.byWeekday = Objects.requireNonNull(byWeekday, "byWeekday");
            return this;
        }

        public final Builder byWeekday(Optional<? extends List<DayOfWeek>> byWeekday) {
            this.byWeekday = byWeekday.orElse(null);
            return this;
        }

        public final Builder byNWeekday(List<RecurrenceRuleNWeekdaySpec> byNWeekday) {
            this.byNWeekday = Objects.requireNonNull(byNWeekday, "byNWeekday");
            return this;
        }

        public final Builder byNWeekday(Optional<? extends List<RecurrenceRuleNWeekdaySpec>> byNWeekday) {
            this.byNWeekday = byNWeekday.orElse(null);
            return this;
        }

        public final Builder byMonth(List<Month> byMonth) {
            this.byMonth = Objects.requireNonNull(byMonth, "byMonth");
            return this;
        }

        public final Builder byMonth(Optional<? extends List<Month>> byMonth) {
            this.byMonth = byMonth.orElse(null);
            return this;
        }

        public final Builder byMonthDay(List<Integer> byMonthDay) {
            this.byMonthDay = Objects.requireNonNull(byMonthDay, "byMonthDay");
            return this;
        }

        public final Builder byMonthDay(Optional<? extends List<Integer>> byMonthDay) {
            this.byMonthDay = byMonthDay.orElse(null);
            return this;
        }

        public final Builder byYearDay(List<Integer> byYearDay) {
            this.byYearDay = Objects.requireNonNull(byYearDay, "byYearDay");
            return this;
        }

        public final Builder byYearDay(Optional<? extends List<Integer>> byYearDay) {
            this.byYearDay = byYearDay.orElse(null);
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            return this;
        }

        public final Builder count(Optional<Integer> count) {
            this.count = count.orElse(null);
            return this;
        }

        public RecurrenceRuleSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RecurrenceRuleSpec(this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("start");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("frequency");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("interval");
            }
            return "Cannot build RecurrenceRuleSpec, some of required attributes are not set " + attributes;
        }
    }
}

