/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.ImmutableMessageCreateFields;
import discord4j.core.spec.InteractionReplyEditSpecGenerator;
import discord4j.core.spec.MessageCreateFields;
import discord4j.discordjson.json.PollCreateData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class InteractionReplyEditSpec
implements InteractionReplyEditSpecGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<TopLevelMessageComponent> components_value;
    private final boolean components_absent;
    private final PollCreateData poll_value;
    private final boolean poll_absent;
    private final List<Attachment> attachments_value;
    private final boolean attachments_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final InteractionReplyEditSpec INSTANCE = InteractionReplyEditSpec.validate(new InteractionReplyEditSpec());

    private InteractionReplyEditSpec() {
        Possible content$impl = Possible.absent();
        Possible embeds$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        Possible poll$impl = Possible.absent();
        Possible attachments$impl = Possible.absent();
        this.content_value = Possible.flatOpt((Possible)content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = Possible.flatOpt((Possible)embeds$impl).orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt((Possible)allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = Possible.flatOpt((Possible)components$impl).orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.attachments_value = Possible.flatOpt((Possible)attachments$impl).orElse(null);
        this.attachments_absent = attachments$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private InteractionReplyEditSpec(Builder builder) {
        Possible content$impl = builder.content_build();
        Possible embeds$impl = builder.embeds_build();
        Possible allowedMentions$impl = builder.allowedMentions_build();
        Possible components$impl = builder.components_build();
        Possible poll$impl = builder.poll_build();
        Possible attachments$impl = builder.attachments_build();
        if (builder.filesIsSet()) {
            this.initShim.files(InteractionReplyEditSpec.createUnmodifiableList(true, builder.files));
        }
        if (builder.fileSpoilersIsSet()) {
            this.initShim.fileSpoilers(InteractionReplyEditSpec.createUnmodifiableList(true, builder.fileSpoilers));
        }
        this.content_value = Possible.flatOpt((Possible)content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = Possible.flatOpt((Possible)embeds$impl).orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt((Possible)allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = Possible.flatOpt((Possible)components$impl).orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.attachments_value = Possible.flatOpt((Possible)attachments$impl).orElse(null);
        this.attachments_absent = attachments$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private InteractionReplyEditSpec(Possible<Optional<String>> content, Possible<Optional<List<EmbedCreateSpec>>> embeds, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, Possible<Optional<AllowedMentions>> allowedMentions, Possible<Optional<List<TopLevelMessageComponent>>> components, Possible<PollCreateData> poll, Possible<Optional<List<Attachment>>> attachments) {
        Possible<Optional<String>> content$impl = content;
        Possible<Optional<List<EmbedCreateSpec>>> embeds$impl = embeds;
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        Possible<Optional<AllowedMentions>> allowedMentions$impl = allowedMentions;
        Possible<Optional<List<TopLevelMessageComponent>>> components$impl = components;
        Possible<PollCreateData> poll$impl = poll;
        Possible<Optional<List<Attachment>>> attachments$impl = attachments;
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = Possible.flatOpt(components$impl).orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.attachments_value = Possible.flatOpt(attachments$impl).orElse(null);
        this.attachments_absent = attachments$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private List<MessageCreateFields.File> filesInitialize() {
        return InteractionReplyEditSpecGenerator.super.files();
    }

    private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
        return InteractionReplyEditSpecGenerator.super.fileSpoilers();
    }

    @Override
    public Possible<Optional<String>> content() {
        return this.content_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.content_value));
    }

    @Override
    public Possible<Optional<List<EmbedCreateSpec>>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.embeds_value));
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public Possible<Optional<AllowedMentions>> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.allowedMentions_value));
    }

    @Override
    public Possible<Optional<List<TopLevelMessageComponent>>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.components_value));
    }

    @Override
    public Possible<PollCreateData> poll() {
        return this.poll_absent ? Possible.absent() : Possible.of((Object)this.poll_value);
    }

    @Override
    public Possible<Optional<List<Attachment>>> attachments() {
        return this.attachments_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.attachments_value));
    }

    public InteractionReplyEditSpec withContent(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), this.attachments()));
    }

    @Deprecated
    public InteractionReplyEditSpec withContent(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec((Possible<Optional<String>>)newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), this.attachments()));
    }

    public InteractionReplyEditSpec withContentOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec((Possible<Optional<String>>)newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), this.attachments()));
    }

    public InteractionReplyEditSpec withEmbeds(Possible<Optional<List<EmbedCreateSpec>>> possible) {
        Possible<Optional<List<EmbedCreateSpec>>> newValue = Objects.requireNonNull(possible);
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), this.attachments()));
    }

    @Deprecated
    public InteractionReplyEditSpec withEmbeds(@Nullable Iterable<EmbedCreateSpec> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), (Possible<Optional<List<EmbedCreateSpec>>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), this.attachments()));
    }

    public InteractionReplyEditSpec withEmbedsOrNull(@Nullable Iterable<EmbedCreateSpec> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), (Possible<Optional<List<EmbedCreateSpec>>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), this.attachments()));
    }

    @SafeVarargs
    public final InteractionReplyEditSpec withEmbeds(EmbedCreateSpec ... elements) {
        Possible newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), (Possible<Optional<List<EmbedCreateSpec>>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), this.attachments()));
    }

    public final InteractionReplyEditSpec withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = InteractionReplyEditSpec.createUnmodifiableList(false, InteractionReplyEditSpec.createSafeList(Arrays.asList(elements), true, false));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), this.attachments()));
    }

    public final InteractionReplyEditSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = InteractionReplyEditSpec.createUnmodifiableList(false, InteractionReplyEditSpec.createSafeList(elements, true, false));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), this.attachments()));
    }

    public final InteractionReplyEditSpec withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = InteractionReplyEditSpec.createUnmodifiableList(false, InteractionReplyEditSpec.createSafeList(Arrays.asList(elements), true, false));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components(), this.poll(), this.attachments()));
    }

    public final InteractionReplyEditSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = InteractionReplyEditSpec.createUnmodifiableList(false, InteractionReplyEditSpec.createSafeList(elements, true, false));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components(), this.poll(), this.attachments()));
    }

    public InteractionReplyEditSpec withAllowedMentions(Possible<Optional<AllowedMentions>> value) {
        Possible<Optional<AllowedMentions>> newValue = Objects.requireNonNull(value);
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, newValue, this.components(), this.poll(), this.attachments()));
    }

    @Deprecated
    public InteractionReplyEditSpec withAllowedMentions(@Nullable AllowedMentions value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, (Possible<Optional<AllowedMentions>>)newValue, this.components(), this.poll(), this.attachments()));
    }

    public InteractionReplyEditSpec withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, (Possible<Optional<AllowedMentions>>)newValue, this.components(), this.poll(), this.attachments()));
    }

    public InteractionReplyEditSpec withComponents(Possible<Optional<List<TopLevelMessageComponent>>> possible) {
        Possible<Optional<List<TopLevelMessageComponent>>> newValue = Objects.requireNonNull(possible);
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.poll(), this.attachments()));
    }

    @Deprecated
    public InteractionReplyEditSpec withComponents(@Nullable Iterable<TopLevelMessageComponent> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<Optional<List<TopLevelMessageComponent>>>)newValue, this.poll(), this.attachments()));
    }

    public InteractionReplyEditSpec withComponentsOrNull(@Nullable Iterable<TopLevelMessageComponent> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<Optional<List<TopLevelMessageComponent>>>)newValue, this.poll(), this.attachments()));
    }

    @SafeVarargs
    public final InteractionReplyEditSpec withComponents(TopLevelMessageComponent ... elements) {
        Possible newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<Optional<List<TopLevelMessageComponent>>>)newValue, this.poll(), this.attachments()));
    }

    public InteractionReplyEditSpec withPoll(Possible<PollCreateData> value) {
        Possible<PollCreateData> newValue = Objects.requireNonNull(value);
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), newValue, this.attachments()));
    }

    public InteractionReplyEditSpec withPoll(PollCreateData value) {
        Possible newValue = Possible.of((Object)value);
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), (Possible<PollCreateData>)newValue, this.attachments()));
    }

    public InteractionReplyEditSpec withAttachments(Possible<Optional<List<Attachment>>> possible) {
        Possible<Optional<List<Attachment>>> newValue = Objects.requireNonNull(possible);
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), newValue));
    }

    @Deprecated
    public InteractionReplyEditSpec withAttachments(@Nullable Iterable<Attachment> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), (Possible<Optional<List<Attachment>>>)newValue));
    }

    public InteractionReplyEditSpec withAttachmentsOrNull(@Nullable Iterable<Attachment> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), (Possible<Optional<List<Attachment>>>)newValue));
    }

    @SafeVarargs
    public final InteractionReplyEditSpec withAttachments(Attachment ... elements) {
        Possible newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.poll(), (Possible<Optional<List<Attachment>>>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InteractionReplyEditSpec && this.equalTo(0, (InteractionReplyEditSpec)another);
    }

    private boolean equalTo(int synthetic, InteractionReplyEditSpec another) {
        return this.content().equals(another.content()) && Objects.equals(this.embeds_value, another.embeds_value) && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.components_value, another.components_value) && this.poll().equals(another.poll()) && Objects.equals(this.attachments_value, another.attachments_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + Objects.hashCode(this.embeds_value);
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + this.fileSpoilers.hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        h += (h << 5) + this.poll().hashCode();
        h += (h << 5) + Objects.hashCode(this.attachments_value);
        return h;
    }

    public String toString() {
        return "InteractionReplyEditSpec{content=" + this.content().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", allowedMentions=" + this.allowedMentions().toString() + ", components=" + Objects.toString(this.components_value) + ", poll=" + this.poll().toString() + ", attachments=" + Objects.toString(this.attachments_value) + "}";
    }

    public static InteractionReplyEditSpec create() {
        return INSTANCE;
    }

    private static InteractionReplyEditSpec validate(InteractionReplyEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static InteractionReplyEditSpec copyOf(InteractionReplyEditSpecGenerator instance) {
        if (instance instanceof InteractionReplyEditSpec) {
            return (InteractionReplyEditSpec)instance;
        }
        return InteractionReplyEditSpec.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<TopLevelMessageComponent> componentsOrElse(List<TopLevelMessageComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public boolean isPollPresent() {
        return !this.poll_absent;
    }

    public PollCreateData pollOrElse(PollCreateData defaultValue) {
        return !this.poll_absent ? this.poll_value : defaultValue;
    }

    public boolean isAttachmentsPresent() {
        return !this.attachments_absent;
    }

    public List<Attachment> attachmentsOrElse(List<Attachment> defaultValue) {
        return !this.attachments_absent ? this.attachments_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_FILES = 1L;
        private static final long OPT_BIT_FILE_SPOILERS = 2L;
        private long optBits;
        private Possible<Optional<String>> content_possible = Possible.absent();
        private List<EmbedCreateSpec> embeds_list = null;
        private boolean embeds_explicitNull;
        private Possible<Optional<AllowedMentions>> allowedMentions_possible = Possible.absent();
        private List<TopLevelMessageComponent> components_list = null;
        private boolean components_explicitNull;
        private Possible<PollCreateData> poll_possible = Possible.absent();
        private List<Attachment> attachments_list = null;
        private boolean attachments_explicitNull;
        private List<MessageCreateFields.File> files = new ArrayList<MessageCreateFields.File>();
        private List<MessageCreateFields.FileSpoiler> fileSpoilers = new ArrayList<MessageCreateFields.FileSpoiler>();

        private Builder() {
        }

        public final Builder from(InteractionReplyEditSpec instance) {
            return this.from((InteractionReplyEditSpecGenerator)instance);
        }

        final Builder from(InteractionReplyEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.embeds(instance.embeds());
            this.addAllFiles(instance.files());
            this.addAllFileSpoilers(instance.fileSpoilers());
            this.allowedMentions(instance.allowedMentions());
            this.components(instance.components());
            this.poll(instance.poll());
            this.attachments(instance.attachments());
            return this;
        }

        public Builder content(Possible<Optional<String>> value) {
            this.content_possible = value;
            return this;
        }

        @Deprecated
        public Builder content(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder contentOrNull(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder addEmbed(EmbedCreateSpec element) {
            this.embeds_getOrCreate().add(element);
            this.embeds_explicitNull = false;
            return this;
        }

        public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
            this.embeds_getOrCreate().addAll(elements);
            this.embeds_explicitNull = false;
            return this;
        }

        public Builder embeds(Possible<Optional<List<EmbedCreateSpec>>> elements) {
            this.embeds_list = null;
            this.embeds_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.embeds_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.embeds_explicitNull = true;
                }
            });
            return this;
        }

        public Builder embeds(List<EmbedCreateSpec> elements) {
            this.embeds_list = new ArrayList<EmbedCreateSpec>(elements);
            this.embeds_explicitNull = false;
            return this;
        }

        @Deprecated
        public Builder embeds(@Nullable Iterable<EmbedCreateSpec> elements) {
            if (elements == null) {
                this.embeds_list = null;
                this.embeds_explicitNull = true;
            } else {
                this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.embeds_explicitNull = false;
            }
            return this;
        }

        public Builder embedsOrNull(@Nullable Iterable<EmbedCreateSpec> elements) {
            if (elements == null) {
                this.embeds_list = null;
                this.embeds_explicitNull = true;
            } else {
                this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.embeds_explicitNull = false;
            }
            return this;
        }

        public final Builder addFile(MessageCreateFields.File element) {
            element = ImmutableMessageCreateFields.File.copyOf(element);
            this.files.add(Objects.requireNonNull(element, "files element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFile(String name, InputStream inputStream) {
            return this.addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
        }

        public final Builder addFiles(MessageCreateFields.File ... elements) {
            for (MessageCreateFields.File element : elements) {
                element = ImmutableMessageCreateFields.File.copyOf(element);
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
            for (MessageCreateFields.File file : elements) {
                ImmutableMessageCreateFields.File file2 = ImmutableMessageCreateFields.File.copyOf(file);
                this.files.add(Objects.requireNonNull(file2, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
            element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
            this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addFileSpoiler(String name, InputStream inputStream) {
            return this.addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
        }

        public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
            for (MessageCreateFields.FileSpoiler element : elements) {
                element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
                this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            this.fileSpoilers.clear();
            return this.addAllFileSpoilers(elements);
        }

        public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            for (MessageCreateFields.FileSpoiler fileSpoiler : elements) {
                ImmutableMessageCreateFields.FileSpoiler fileSpoiler2 = ImmutableMessageCreateFields.FileSpoiler.copyOf(fileSpoiler);
                this.fileSpoilers.add(Objects.requireNonNull(fileSpoiler2, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public Builder allowedMentions(Possible<Optional<AllowedMentions>> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        @Deprecated
        public Builder allowedMentions(@Nullable AllowedMentions value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder allowedMentionsOrNull(@Nullable AllowedMentions value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder addComponent(TopLevelMessageComponent element) {
            this.components_getOrCreate().add(element);
            this.components_explicitNull = false;
            return this;
        }

        public Builder addAllComponents(List<TopLevelMessageComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            this.components_explicitNull = false;
            return this;
        }

        public Builder components(Possible<Optional<List<TopLevelMessageComponent>>> elements) {
            this.components_list = null;
            this.components_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.components_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.components_explicitNull = true;
                }
            });
            return this;
        }

        public Builder components(List<TopLevelMessageComponent> elements) {
            this.components_list = new ArrayList<TopLevelMessageComponent>(elements);
            this.components_explicitNull = false;
            return this;
        }

        @Deprecated
        public Builder components(@Nullable Iterable<TopLevelMessageComponent> elements) {
            if (elements == null) {
                this.components_list = null;
                this.components_explicitNull = true;
            } else {
                this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.components_explicitNull = false;
            }
            return this;
        }

        public Builder componentsOrNull(@Nullable Iterable<TopLevelMessageComponent> elements) {
            if (elements == null) {
                this.components_list = null;
                this.components_explicitNull = true;
            } else {
                this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.components_explicitNull = false;
            }
            return this;
        }

        public Builder poll(Possible<PollCreateData> value) {
            this.poll_possible = value;
            return this;
        }

        public Builder poll(PollCreateData value) {
            this.poll_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addAttachment(Attachment element) {
            this.attachments_getOrCreate().add(element);
            this.attachments_explicitNull = false;
            return this;
        }

        public Builder addAllAttachments(List<Attachment> elements) {
            this.attachments_getOrCreate().addAll(elements);
            this.attachments_explicitNull = false;
            return this;
        }

        public Builder attachments(Possible<Optional<List<Attachment>>> elements) {
            this.attachments_list = null;
            this.attachments_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.attachments_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.attachments_explicitNull = true;
                }
            });
            return this;
        }

        public Builder attachments(List<Attachment> elements) {
            this.attachments_list = new ArrayList<Attachment>(elements);
            this.attachments_explicitNull = false;
            return this;
        }

        @Deprecated
        public Builder attachments(@Nullable Iterable<Attachment> elements) {
            if (elements == null) {
                this.attachments_list = null;
                this.attachments_explicitNull = true;
            } else {
                this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.attachments_explicitNull = false;
            }
            return this;
        }

        public Builder attachmentsOrNull(@Nullable Iterable<Attachment> elements) {
            if (elements == null) {
                this.attachments_list = null;
                this.attachments_explicitNull = true;
            } else {
                this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.attachments_explicitNull = false;
            }
            return this;
        }

        public InteractionReplyEditSpec build() {
            return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this));
        }

        private boolean filesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean fileSpoilersIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private Possible<Optional<String>> content_build() {
            return this.content_possible;
        }

        private Possible<Optional<List<EmbedCreateSpec>>> embeds_build() {
            return this.embeds_list == null && !this.embeds_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.embeds_list));
        }

        private List<EmbedCreateSpec> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedCreateSpec>();
            }
            return this.embeds_list;
        }

        private Possible<Optional<AllowedMentions>> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<Optional<List<TopLevelMessageComponent>>> components_build() {
            return this.components_list == null && !this.components_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.components_list));
        }

        private List<TopLevelMessageComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<TopLevelMessageComponent>();
            }
            return this.components_list;
        }

        private Possible<PollCreateData> poll_build() {
            return this.poll_possible;
        }

        private Possible<Optional<List<Attachment>>> attachments_build() {
            return this.attachments_list == null && !this.attachments_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.attachments_list));
        }

        private List<Attachment> attachments_getOrCreate() {
            if (this.attachments_list == null) {
                this.attachments_list = new ArrayList<Attachment>();
            }
            return this.attachments_list;
        }
    }

    private final class InitShim {
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;

        private InitShim() {
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = InteractionReplyEditSpec.createUnmodifiableList(false, InteractionReplyEditSpec.createSafeList(InteractionReplyEditSpec.this.filesInitialize(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = InteractionReplyEditSpec.createUnmodifiableList(false, InteractionReplyEditSpec.createSafeList(InteractionReplyEditSpec.this.fileSpoilersInitialize(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            return "Cannot build InteractionReplyEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

