/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.component.BaseMessageComponent;
import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.EmbedCreateSpecGenerator;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.ImmutableInteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.MultipartRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable(singleton=true)
interface InteractionApplicationCommandCallbackSpecGenerator
extends Spec<MultipartRequest<InteractionApplicationCommandCallbackData>> {
    public Possible<String> content();

    public Possible<Boolean> tts();

    public Possible<Boolean> ephemeral();

    public Possible<List<EmbedCreateSpec>> embeds();

    @Value.Default
    default public List<MessageCreateFields.File> files() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        return Collections.emptyList();
    }

    public Possible<AllowedMentions> allowedMentions();

    public Possible<List<TopLevelMessageComponent>> components();

    @Override
    default public MultipartRequest<InteractionApplicationCommandCallbackData> asRequest() {
        ArrayList<Message.Flag> flagsToApply = new ArrayList<Message.Flag>();
        if (this.ephemeral().toOptional().orElse(false).booleanValue()) {
            flagsToApply.add(Message.Flag.EPHEMERAL);
        }
        if (!this.components().isAbsent() && ((List)this.components().get()).stream().anyMatch(topLevelComponent -> topLevelComponent.getType().isRequiredFlag())) {
            flagsToApply.add(Message.Flag.IS_COMPONENTS_V2);
        }
        Possible pFlagsToApply = Possible.of(flagsToApply);
        ImmutableInteractionApplicationCommandCallbackData json = InteractionApplicationCommandCallbackData.builder().content(this.content()).tts(this.tts()).flags(InternalSpecUtils.mapPossible(pFlagsToApply, f -> f.stream().mapToInt(Message.Flag::getFlag).reduce(0, (left, right) -> left | right))).embeds(InternalSpecUtils.mapPossible(this.embeds(), embeds -> embeds.stream().map(EmbedCreateSpecGenerator::asRequest).collect(Collectors.toList()))).components(InternalSpecUtils.mapPossible(this.components(), components -> components.stream().map(BaseMessageComponent::getData).collect(Collectors.toList()))).allowedMentions(InternalSpecUtils.mapPossible(this.allowedMentions(), AllowedMentions::toData)).build();
        return MultipartRequest.ofRequestAndFiles((Object)json, Stream.concat(this.files().stream(), this.fileSpoilers().stream()).map(MessageCreateFields.File::asRequest).collect(Collectors.toList()));
    }
}

