/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.GuildStickerCreateSpecGenerator;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class GuildStickerCreateSpec
implements GuildStickerCreateSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String name;
    private final String description;
    private final String tags;
    private final String file;

    private GuildStickerCreateSpec(String name, String description, String tags, String file) {
        this.name = Objects.requireNonNull(name, "name");
        this.description = Objects.requireNonNull(description, "description");
        this.tags = Objects.requireNonNull(tags, "tags");
        this.file = Objects.requireNonNull(file, "file");
        this.reason = null;
    }

    private GuildStickerCreateSpec(@reactor.util.annotation.Nullable String reason, String name, String description, String tags, String file) {
        this.reason = reason;
        this.name = name;
        this.description = description;
        this.tags = tags;
        this.file = file;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String tags() {
        return this.tags;
    }

    @Override
    public String file() {
        return this.file;
    }

    public final GuildStickerCreateSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new GuildStickerCreateSpec(value, this.name, this.description, this.tags, this.file);
    }

    public final GuildStickerCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new GuildStickerCreateSpec(this.reason, newValue, this.description, this.tags, this.file);
    }

    public final GuildStickerCreateSpec withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new GuildStickerCreateSpec(this.reason, this.name, newValue, this.tags, this.file);
    }

    public final GuildStickerCreateSpec withTags(String value) {
        String newValue = Objects.requireNonNull(value, "tags");
        if (this.tags.equals(newValue)) {
            return this;
        }
        return new GuildStickerCreateSpec(this.reason, this.name, this.description, newValue, this.file);
    }

    public final GuildStickerCreateSpec withFile(String value) {
        String newValue = Objects.requireNonNull(value, "file");
        if (this.file.equals(newValue)) {
            return this;
        }
        return new GuildStickerCreateSpec(this.reason, this.name, this.description, this.tags, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildStickerCreateSpec && this.equalTo(0, (GuildStickerCreateSpec)another);
    }

    private boolean equalTo(int synthetic, GuildStickerCreateSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.description.equals(another.description) && this.tags.equals(another.tags) && this.file.equals(another.file);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.file.hashCode();
        return h;
    }

    public String toString() {
        return "GuildStickerCreateSpec{reason=" + this.reason + ", name=" + this.name + ", description=" + this.description + ", tags=" + this.tags + ", file=" + this.file + "}";
    }

    public static GuildStickerCreateSpec of(String name, String description, String tags, String file) {
        return new GuildStickerCreateSpec(name, description, tags, file);
    }

    static GuildStickerCreateSpec copyOf(GuildStickerCreateSpecGenerator instance) {
        if (instance instanceof GuildStickerCreateSpec) {
            return (GuildStickerCreateSpec)instance;
        }
        return GuildStickerCreateSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_TAGS = 4L;
        private static final long INIT_BIT_FILE = 8L;
        private long initBits = 15L;
        @Nullable
        private String reason;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String tags;
        @Nullable
        private String file;

        private Builder() {
        }

        public final Builder from(GuildStickerCreateSpec instance) {
            return this.from((GuildStickerCreateSpecGenerator)instance);
        }

        final Builder from(GuildStickerCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.description(instance.description());
            this.tags(instance.tags());
            this.file(instance.file());
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder tags(String tags) {
            this.tags = Objects.requireNonNull(tags, "tags");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder file(String file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public GuildStickerCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GuildStickerCreateSpec(this.reason, this.name, this.description, this.tags, this.file);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("tags");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("file");
            }
            return "Cannot build GuildStickerCreateSpec, some of required attributes are not set " + attributes;
        }
    }
}

