/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.GuildPruneMonoGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class GuildPruneMono
extends GuildPruneMonoGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final Integer days;
    @reactor.util.annotation.Nullable
    private final Set<Snowflake> roles;
    @reactor.util.annotation.Nullable
    private final Boolean computePruneCount;
    private final Guild guild;

    private GuildPruneMono(Integer days, Guild guild) {
        this.days = Objects.requireNonNull(days, "days");
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        this.roles = null;
        this.computePruneCount = null;
    }

    private GuildPruneMono(@reactor.util.annotation.Nullable String reason, Integer days, @reactor.util.annotation.Nullable Set<Snowflake> roles, @reactor.util.annotation.Nullable Boolean computePruneCount, Guild guild) {
        this.reason = reason;
        this.days = days;
        this.roles = roles;
        this.computePruneCount = computePruneCount;
        this.guild = guild;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Integer days() {
        return this.days;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Set<Snowflake> roles() {
        return this.roles;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Boolean computePruneCount() {
        return this.computePruneCount;
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final GuildPruneMono withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new GuildPruneMono(value, this.days, this.roles, this.computePruneCount, this.guild);
    }

    public final GuildPruneMono withDays(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "days");
        if (this.days.equals(newValue)) {
            return this;
        }
        return new GuildPruneMono(this.reason, newValue, this.roles, this.computePruneCount, this.guild);
    }

    public final GuildPruneMono withRoles(Snowflake ... elements) {
        if (elements == null) {
            return new GuildPruneMono(this.reason, this.days, null, this.computePruneCount, this.guild);
        }
        Set<Snowflake> newValue = Arrays.asList(elements) == null ? null : GuildPruneMono.createUnmodifiableSet(GuildPruneMono.createSafeList(Arrays.asList(elements), true, false));
        return new GuildPruneMono(this.reason, this.days, newValue, this.computePruneCount, this.guild);
    }

    public final GuildPruneMono withRoles(@reactor.util.annotation.Nullable Iterable<? extends Snowflake> elements) {
        if (this.roles == elements) {
            return this;
        }
        Set<Snowflake> newValue = elements == null ? null : GuildPruneMono.createUnmodifiableSet(GuildPruneMono.createSafeList(elements, true, false));
        return new GuildPruneMono(this.reason, this.days, newValue, this.computePruneCount, this.guild);
    }

    public final GuildPruneMono withComputePruneCount(@reactor.util.annotation.Nullable Boolean value) {
        if (Objects.equals(this.computePruneCount, value)) {
            return this;
        }
        return new GuildPruneMono(this.reason, this.days, this.roles, value, this.guild);
    }

    public final GuildPruneMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new GuildPruneMono(this.reason, this.days, this.roles, this.computePruneCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildPruneMono && this.equalTo(0, (GuildPruneMono)another);
    }

    private boolean equalTo(int synthetic, GuildPruneMono another) {
        return Objects.equals(this.reason, another.reason) && this.days.equals(another.days) && Objects.equals(this.roles, another.roles) && Objects.equals(this.computePruneCount, another.computePruneCount) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.days.hashCode();
        h += (h << 5) + Objects.hashCode(this.roles);
        h += (h << 5) + Objects.hashCode(this.computePruneCount);
        h += (h << 5) + this.guild.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "GuildPruneMono{reason=" + this.reason + ", days=" + this.days + ", roles=" + this.roles + ", computePruneCount=" + this.computePruneCount + ", guild=" + this.guild + "}";
    }

    public static GuildPruneMono of(Integer days, Guild guild) {
        return new GuildPruneMono(days, guild);
    }

    static GuildPruneMono copyOf(GuildPruneMonoGenerator instance) {
        if (instance instanceof GuildPruneMono) {
            return (GuildPruneMono)instance;
        }
        return GuildPruneMono.of(instance.days(), instance.guild()).withReason(instance.reason()).withRoles(instance.roles()).withComputePruneCount(instance.computePruneCount());
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }
}

