/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.GuildPruneCountMonoGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class GuildPruneCountMono
extends GuildPruneCountMonoGenerator {
    private final Integer days;
    @reactor.util.annotation.Nullable
    private final Set<Snowflake> roles;
    private final Guild guild;

    private GuildPruneCountMono(Integer days, Guild guild) {
        this.days = Objects.requireNonNull(days, "days");
        this.guild = Objects.requireNonNull(guild, "guild");
        this.roles = null;
    }

    private GuildPruneCountMono(Integer days, @reactor.util.annotation.Nullable Set<Snowflake> roles, Guild guild) {
        this.days = days;
        this.roles = roles;
        this.guild = guild;
    }

    @Override
    public Integer days() {
        return this.days;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Set<Snowflake> roles() {
        return this.roles;
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final GuildPruneCountMono withDays(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "days");
        if (this.days.equals(newValue)) {
            return this;
        }
        return new GuildPruneCountMono(newValue, this.roles, this.guild);
    }

    public final GuildPruneCountMono withRoles(Snowflake ... elements) {
        if (elements == null) {
            return new GuildPruneCountMono(this.days, null, this.guild);
        }
        Set<Snowflake> newValue = Arrays.asList(elements) == null ? null : GuildPruneCountMono.createUnmodifiableSet(GuildPruneCountMono.createSafeList(Arrays.asList(elements), true, false));
        return new GuildPruneCountMono(this.days, newValue, this.guild);
    }

    public final GuildPruneCountMono withRoles(@reactor.util.annotation.Nullable Iterable<? extends Snowflake> elements) {
        if (this.roles == elements) {
            return this;
        }
        Set<Snowflake> newValue = elements == null ? null : GuildPruneCountMono.createUnmodifiableSet(GuildPruneCountMono.createSafeList(elements, true, false));
        return new GuildPruneCountMono(this.days, newValue, this.guild);
    }

    public final GuildPruneCountMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new GuildPruneCountMono(this.days, this.roles, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildPruneCountMono && this.equalTo(0, (GuildPruneCountMono)another);
    }

    private boolean equalTo(int synthetic, GuildPruneCountMono another) {
        return this.days.equals(another.days) && Objects.equals(this.roles, another.roles) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.days.hashCode();
        h += (h << 5) + Objects.hashCode(this.roles);
        h += (h << 5) + this.guild.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "GuildPruneCountMono{days=" + this.days + ", roles=" + this.roles + ", guild=" + this.guild + "}";
    }

    public static GuildPruneCountMono of(Integer days, Guild guild) {
        return new GuildPruneCountMono(days, guild);
    }

    static GuildPruneCountMono copyOf(GuildPruneCountMonoGenerator instance) {
        if (instance instanceof GuildPruneCountMono) {
            return (GuildPruneCountMono)instance;
        }
        return GuildPruneCountMono.of(instance.days(), instance.guild()).withRoles(instance.roles());
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }
}

