/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.monetization.Entitlement;
import discord4j.core.spec.CreateTestEntitlementSpecGenerator;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class CreateTestEntitlementSpec
implements CreateTestEntitlementSpecGenerator {
    private final Snowflake skuId;
    private final Snowflake ownerId;
    private final Entitlement.OwnerType ownerType;

    private CreateTestEntitlementSpec(Snowflake skuId, Snowflake ownerId, Entitlement.OwnerType ownerType) {
        this.skuId = Objects.requireNonNull(skuId, "skuId");
        this.ownerId = Objects.requireNonNull(ownerId, "ownerId");
        this.ownerType = Objects.requireNonNull(ownerType, "ownerType");
    }

    private CreateTestEntitlementSpec(CreateTestEntitlementSpec original, Snowflake skuId, Snowflake ownerId, Entitlement.OwnerType ownerType) {
        this.skuId = skuId;
        this.ownerId = ownerId;
        this.ownerType = ownerType;
    }

    @Override
    public Snowflake skuId() {
        return this.skuId;
    }

    @Override
    public Snowflake ownerId() {
        return this.ownerId;
    }

    @Override
    public Entitlement.OwnerType ownerType() {
        return this.ownerType;
    }

    public final CreateTestEntitlementSpec withSkuId(Snowflake value) {
        if (this.skuId == value) {
            return this;
        }
        Snowflake newValue = Objects.requireNonNull(value, "skuId");
        return new CreateTestEntitlementSpec(this, newValue, this.ownerId, this.ownerType);
    }

    public final CreateTestEntitlementSpec withOwnerId(Snowflake value) {
        if (this.ownerId == value) {
            return this;
        }
        Snowflake newValue = Objects.requireNonNull(value, "ownerId");
        return new CreateTestEntitlementSpec(this, this.skuId, newValue, this.ownerType);
    }

    public final CreateTestEntitlementSpec withOwnerType(Entitlement.OwnerType value) {
        Entitlement.OwnerType newValue = Objects.requireNonNull(value, "ownerType");
        if (this.ownerType == newValue) {
            return this;
        }
        return new CreateTestEntitlementSpec(this, this.skuId, this.ownerId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateTestEntitlementSpec && this.equalTo(0, (CreateTestEntitlementSpec)another);
    }

    private boolean equalTo(int synthetic, CreateTestEntitlementSpec another) {
        return this.skuId.equals((Object)another.skuId) && this.ownerId.equals((Object)another.ownerId) && this.ownerType.equals((Object)another.ownerType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.skuId.hashCode();
        h += (h << 5) + this.ownerId.hashCode();
        h += (h << 5) + this.ownerType.hashCode();
        return h;
    }

    public String toString() {
        return "CreateTestEntitlementSpec{skuId=" + this.skuId + ", ownerId=" + this.ownerId + ", ownerType=" + (Object)((Object)this.ownerType) + "}";
    }

    public static CreateTestEntitlementSpec of(Snowflake skuId, Snowflake ownerId, Entitlement.OwnerType ownerType) {
        return new CreateTestEntitlementSpec(skuId, ownerId, ownerType);
    }

    public static CreateTestEntitlementSpec copyOf(CreateTestEntitlementSpecGenerator instance) {
        if (instance instanceof CreateTestEntitlementSpec) {
            return (CreateTestEntitlementSpec)instance;
        }
        return CreateTestEntitlementSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SKU_ID = 1L;
        private static final long INIT_BIT_OWNER_ID = 2L;
        private static final long INIT_BIT_OWNER_TYPE = 4L;
        private long initBits = 7L;
        @Nullable
        private Snowflake skuId;
        @Nullable
        private Snowflake ownerId;
        @Nullable
        private Entitlement.OwnerType ownerType;

        private Builder() {
        }

        public final Builder from(CreateTestEntitlementSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.skuId(instance.skuId());
            this.ownerId(instance.ownerId());
            this.ownerType(instance.ownerType());
            return this;
        }

        public final Builder skuId(Snowflake skuId) {
            this.skuId = Objects.requireNonNull(skuId, "skuId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ownerId(Snowflake ownerId) {
            this.ownerId = Objects.requireNonNull(ownerId, "ownerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder ownerType(Entitlement.OwnerType ownerType) {
            this.ownerType = Objects.requireNonNull(ownerType, "ownerType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public CreateTestEntitlementSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateTestEntitlementSpec(null, this.skuId, this.ownerId, this.ownerType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("skuId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ownerId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ownerType");
            }
            return "Cannot build CreateTestEntitlementSpec, some of required attributes are not set " + attributes;
        }
    }
}

