/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.onboarding;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.OnboardingPromptOptionData;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class OnboardingPromptOption
implements Entity {
    private final GatewayDiscordClient client;
    private final OnboardingPromptOptionData data;
    private final Snowflake id;
    private final List<Snowflake> addedChannelIds;
    private final List<Snowflake> roleIds;
    private final ReactionEmoji emoji;

    public OnboardingPromptOption(GatewayDiscordClient client, OnboardingPromptOptionData data) {
        this.client = client;
        this.data = data;
        this.id = Snowflake.of((Id)data.id());
        this.addedChannelIds = data.channelsIds().stream().map(Snowflake::of).collect(Collectors.toList());
        this.roleIds = data.rolesIds().stream().map(Snowflake::of).collect(Collectors.toList());
        this.emoji = data.emoji().toOptional().map(ReactionEmoji::of).orElse(null);
    }

    public OnboardingPromptOptionData getData() {
        return this.data;
    }

    public List<Snowflake> getAddedChannelIds() {
        return this.addedChannelIds;
    }

    public List<Snowflake> getRoleIds() {
        return this.roleIds;
    }

    public String getTitle() {
        return this.data.title();
    }

    public Optional<String> getDescription() {
        return this.data.description();
    }

    public Optional<ReactionEmoji> getEmoji() {
        return Optional.ofNullable(this.emoji);
    }

    @Override
    public Snowflake getId() {
        return this.id;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.client;
    }

    public String toString() {
        return "OnboardingPromptOption{id=" + this.id + ", addedChannelIds=" + this.addedChannelIds + ", roleIds=" + this.roleIds + ", emoji=" + this.emoji + '}';
    }
}

