/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.monetization;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.User;
import discord4j.core.object.monetization.SKU;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.SubscriptionData;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Subscription
implements Entity {
    private final GatewayDiscordClient gateway;
    private final SubscriptionData data;

    public Subscription(GatewayDiscordClient gateway, SubscriptionData data) {
        this.gateway = gateway;
        this.data = data;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public SubscriptionData getData() {
        return this.data;
    }

    public Status getStatus() {
        return Status.of(this.data.status());
    }

    public Optional<String> getCountry() {
        return this.data.country().toOptional();
    }

    public Instant getCurrentPeriodStart() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)this.data.currentPeriodStart(), Instant::from);
    }

    public Instant getCurrentPeriodEnd() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)this.data.currentPeriodEnd(), Instant::from);
    }

    public Optional<Instant> getCanceledAt() {
        return this.data.canceledAt().map(it -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)it, Instant::from));
    }

    public Snowflake getUserId() {
        return Snowflake.of((Id)this.data.userId());
    }

    public Mono<User> getUser() {
        return this.gateway.getUserById(this.getUserId());
    }

    public List<Snowflake> getSkusId() {
        return this.data.skuIds().stream().map(Snowflake::of).collect(Collectors.toList());
    }

    public Flux<SKU> getSkus() {
        List<Snowflake> skusId = this.getSkusId();
        return this.gateway.getSKUs().filter(sku -> skusId.contains(sku.getId()));
    }

    public List<Snowflake> getEntitlementIds() {
        return this.data.entitlementIds().stream().map(Snowflake::of).collect(Collectors.toList());
    }

    public List<Snowflake> getRenewalSkuIds() {
        return this.data.renewalSkuIds().map(ids -> ids.stream().map(Snowflake::of).collect(Collectors.toList())).orElse(new ArrayList());
    }

    public static enum Status {
        UNKNOWN(-1),
        ACTIVE(0),
        ENDING(1),
        INACTIVE(2);

        private final int value;

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Status of(int value) {
            switch (value) {
                case 0: {
                    return ACTIVE;
                }
                case 1: {
                    return ENDING;
                }
                case 2: {
                    return INACTIVE;
                }
            }
            return UNKNOWN;
        }
    }
}

