/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.monetization;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.core.object.monetization.SKU;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.EntitlementData;
import discord4j.discordjson.possible.Possible;
import java.time.Instant;
import java.util.Optional;
import reactor.core.publisher.Mono;

@Experimental
public class Entitlement
implements Entity {
    private final GatewayDiscordClient gateway;
    private final EntitlementData data;

    public Entitlement(GatewayDiscordClient gateway, EntitlementData data) {
        this.gateway = gateway;
        this.data = data;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public EntitlementData getData() {
        return this.data;
    }

    public Snowflake getSkuId() {
        return Snowflake.of((Id)this.data.skuId());
    }

    public Mono<SKU> getSku() {
        return this.gateway.getSKUs().filter(sku -> sku.getId().equals((Object)this.getSkuId())).next();
    }

    public Snowflake getApplicationId() {
        return Snowflake.of((Id)this.data.applicationId());
    }

    public Optional<Snowflake> getUserId() {
        return this.data.userId().toOptional().map(Snowflake::of);
    }

    public Mono<User> getUser() {
        return this.getUserId().map(this.gateway::getUserById).orElse(Mono.empty());
    }

    public Optional<Snowflake> getGuildId() {
        return this.data.guildId().toOptional().map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return this.getGuildId().map(this.gateway::getGuildById).orElse(Mono.empty());
    }

    public Optional<Snowflake> getOwnerId() {
        Optional<Snowflake> userId = this.getUserId();
        if (userId.isPresent()) {
            return userId;
        }
        return this.getGuildId();
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public boolean isDeleted() {
        return this.data.deleted();
    }

    public Optional<Instant> getStartsAt() {
        return this.data.startsAt().toOptional().map(Instant::parse);
    }

    public Optional<Instant> getEndsAt() {
        return Possible.flatOpt((Possible)this.data.endsAt()).map(Instant::parse);
    }

    public Optional<Snowflake> getSubscriptionId() {
        return this.data.subscriptionId().toOptional().map(Snowflake::of);
    }

    public Mono<Void> consume() {
        return this.gateway.getRestClient().getMonetizationService().consumeEntitlement(this.getApplicationId().asLong(), this.getId().asLong());
    }

    public boolean isConsumed() {
        return this.data.consumed().toOptional().orElse(false);
    }

    public static enum Type {
        UNKNOWN(-1),
        PURCHASE(1),
        PREMIUM_SUBSCRIPTION(2),
        DEVELOPER_GIFT(3),
        TEST_MODE_PURCHASE(4),
        FREE_PURCHASE(5),
        USER_GIFT(6),
        PREMIUM_PURCHASE(7),
        APPLICATION_SUBSCRIPTION(8);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return PURCHASE;
                }
                case 2: {
                    return PREMIUM_SUBSCRIPTION;
                }
                case 3: {
                    return DEVELOPER_GIFT;
                }
                case 4: {
                    return TEST_MODE_PURCHASE;
                }
                case 5: {
                    return FREE_PURCHASE;
                }
                case 6: {
                    return USER_GIFT;
                }
                case 7: {
                    return PREMIUM_PURCHASE;
                }
                case 8: {
                    return APPLICATION_SUBSCRIPTION;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum OwnerType {
        UNKNOWN(-1),
        GUILD(1),
        USER(2);

        private final int value;

        private OwnerType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static OwnerType of(int value) {
            switch (value) {
                case 1: {
                    return GUILD;
                }
                case 2: {
                    return USER;
                }
            }
            return UNKNOWN;
        }
    }
}

