/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.RecurrenceRule;
import discord4j.core.object.ScheduledEventEntityMetadata;
import discord4j.core.object.ScheduledEventUser;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.spec.ScheduledEventEditMono;
import discord4j.core.spec.ScheduledEventEditSpec;
import discord4j.core.util.ImageUtil;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.GuildScheduledEventData;
import discord4j.discordjson.json.GuildScheduledEventEntityMetadataData;
import discord4j.discordjson.json.GuildScheduledEventUserData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.time.Instant;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class ScheduledEvent
implements Entity {
    private static final String EVENT_COVER_IMAGE_PATH = "guild-events/%s/%s";
    private final GatewayDiscordClient gateway;
    private final GuildScheduledEventData data;

    public ScheduledEvent(GatewayDiscordClient gateway, GuildScheduledEventData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public GuildScheduledEventData getData() {
        return this.data;
    }

    public Snowflake getGuildId() {
        return Snowflake.of((Id)this.data.guildId());
    }

    public Optional<Snowflake> getCreatorId() {
        return Possible.flatOpt((Possible)this.data.creatorId()).map(Snowflake::of);
    }

    public Mono<Member> getCreator() {
        return Mono.justOrEmpty(this.getCreatorId()).flatMap(id -> this.gateway.getMemberById(this.getGuildId(), (Snowflake)id));
    }

    public Optional<Snowflake> getChannelId() {
        return this.data.channelId().map(Snowflake::of);
    }

    public Mono<GuildChannel> getChannel() {
        return Mono.justOrEmpty(this.getChannelId()).flatMap(this.gateway::getChannelById).ofType(GuildChannel.class);
    }

    public String getName() {
        return this.data.name();
    }

    public Optional<String> getDescription() {
        return Possible.flatOpt((Possible)this.data.description());
    }

    public Instant getStartTime() {
        return this.data.scheduledStartTime();
    }

    public Optional<Instant> getEndTime() {
        return this.data.scheduledEndTime();
    }

    public PrivacyLevel getPrivacyLevel() {
        return PrivacyLevel.of(this.data.privacyLevel());
    }

    public Status getStatus() {
        return Status.of(this.data.status());
    }

    public Optional<String> getImageUrl(Image.Format format) {
        return Possible.flatOpt((Possible)this.data.image()).map(hash -> ImageUtil.getUrl(String.format(EVENT_COVER_IMAGE_PATH, this.getId().asString(), hash), format));
    }

    public EntityType getEntityType() {
        return EntityType.of(this.data.entityType());
    }

    public Optional<Snowflake> getEntityId() {
        return this.getData().entityId().map(Snowflake::of);
    }

    public Optional<ScheduledEventEntityMetadata> getEntityMetadata() {
        return this.data.entityMetadata().map(data -> new ScheduledEventEntityMetadata(this.gateway, (GuildScheduledEventEntityMetadataData)data));
    }

    public Optional<String> getLocation() {
        return this.getEntityMetadata().flatMap(ScheduledEventEntityMetadata::getLocation);
    }

    public Optional<RecurrenceRule> getRecurrenceRule() {
        return this.data.recurrenceRule().map(RecurrenceRule::new);
    }

    public Optional<Integer> getSubscribedUserCount() {
        return this.data.userCount().toOptional();
    }

    public Flux<ScheduledEventUser> getSubscribedUsers(boolean withMemberData) {
        HashMap<String, Boolean> queryParams = new HashMap<String, Boolean>();
        queryParams.put("with_member", withMemberData);
        return this.gateway.getRestClient().getGuildService().getScheduledEventUsers(this.getGuildId().asLong(), this.getId().asLong(), queryParams).map(data -> new ScheduledEventUser(this.gateway, (GuildScheduledEventUserData)data, this.getGuildId()));
    }

    public Flux<ScheduledEventUser> getSubscribedUsersBefore(Snowflake userId, boolean withMemberData) {
        return this.gateway.getRestClient().getScheduledEventById(this.getGuildId(), this.getId()).getSubscribedUsersBefore(userId, Boolean.valueOf(withMemberData)).map(data -> new ScheduledEventUser(this.gateway, (GuildScheduledEventUserData)data, this.getGuildId()));
    }

    public Flux<ScheduledEventUser> getSubscribedUsersAfter(Snowflake userId, boolean withMemberData) {
        return this.gateway.getRestClient().getScheduledEventById(this.getGuildId(), this.getId()).getSubscribedUsersAfter(userId, Boolean.valueOf(withMemberData)).map(data -> new ScheduledEventUser(this.gateway, (GuildScheduledEventUserData)data, this.getGuildId()));
    }

    public ScheduledEventEditMono edit() {
        return ScheduledEventEditMono.of(this);
    }

    public Mono<ScheduledEvent> edit(ScheduledEventEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.gateway.getRestClient().getScheduledEventById(this.getGuildId(), this.getId()).edit(spec.asRequest(), spec.reason()).map(data -> new ScheduledEvent(this.gateway, (GuildScheduledEventData)data)));
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.gateway.getRestClient().getScheduledEventById(this.getGuildId(), this.getId()).delete(reason);
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public static enum Status {
        UNKNOWN(-1),
        SCHEDULED(1),
        ACTIVE(2),
        COMPLETED(3),
        CANCELED(4);

        private final int value;

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Status of(int value) {
            switch (value) {
                case 1: {
                    return SCHEDULED;
                }
                case 2: {
                    return ACTIVE;
                }
                case 3: {
                    return COMPLETED;
                }
                case 4: {
                    return CANCELED;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum EntityType {
        UNKNOWN(-1),
        STAGE_INSTANCE(1),
        VOICE(2),
        EXTERNAL(3);

        private final int value;

        private EntityType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static EntityType of(int value) {
            switch (value) {
                case 1: {
                    return STAGE_INSTANCE;
                }
                case 2: {
                    return VOICE;
                }
                case 3: {
                    return EXTERNAL;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum PrivacyLevel {
        UNKNOWN(-1),
        GUILD_ONLY(2);

        private final int value;

        private PrivacyLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PrivacyLevel of(int value) {
            switch (value) {
                case 2: {
                    return GUILD_ONLY;
                }
            }
            return UNKNOWN;
        }
    }
}

