/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Sticker;
import discord4j.core.util.ImageUtil;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.PartialStickerData;
import discord4j.rest.util.Image;
import java.util.Objects;

public class PartialSticker
implements Entity {
    private static final String STICKER_IMAGE_PATH = "stickers/%s";
    protected final GatewayDiscordClient gateway;
    private final PartialStickerData data;

    public PartialSticker(GatewayDiscordClient gateway, PartialStickerData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public String getName() {
        return this.data.name();
    }

    public Sticker.Format getFormatType() {
        return Sticker.Format.of(this.data.formatType());
    }

    public String getImageUrl() {
        String path = String.format(STICKER_IMAGE_PATH, this.getId().asString());
        return this.getFormatType().equals((Object)Sticker.Format.LOTTIE) ? ImageUtil.getUrl(path, Image.Format.LOTTIE) : ImageUtil.getUrl(path, Image.Format.PNG);
    }

    public PartialStickerData getStickerData() {
        return this.data;
    }
}

