/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.component;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.ActionComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.json.ImmutableComponentData;
import discord4j.discordjson.json.SelectDefaultValueData;
import discord4j.discordjson.json.SelectOptionData;
import discord4j.discordjson.possible.Possible;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import reactor.util.annotation.Nullable;

public class SelectMenu
extends ActionComponent {
    public static SelectMenu of(String customId, Option ... options) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU, customId, Arrays.asList(options), null, null);
    }

    public static SelectMenu of(String customId, List<Option> options) {
        Objects.requireNonNull(options);
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU, customId, options, null, null);
    }

    public static SelectMenu ofRole(String customId) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_ROLE, customId, null, null, null);
    }

    public static SelectMenu ofRole(String customId, List<DefaultValue> defaultValues) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_ROLE, customId, null, null, defaultValues);
    }

    public static SelectMenu ofUser(String customId) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_USER, customId, null, null, null);
    }

    public static SelectMenu ofUser(String customId, List<DefaultValue> defaultValues) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_USER, customId, null, null, defaultValues);
    }

    public static SelectMenu ofMentionable(String customId) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_MENTIONABLE, customId, null, null, null);
    }

    public static SelectMenu ofMentionable(String customId, List<DefaultValue> defaultValues) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_MENTIONABLE, customId, null, null, defaultValues);
    }

    public static SelectMenu ofChannel(String customId, Channel.Type ... channelTypes) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_CHANNEL, customId, null, Arrays.asList(channelTypes), null);
    }

    public static SelectMenu ofChannel(String customId, List<DefaultValue> defaultValues, Channel.Type ... channelTypes) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_CHANNEL, customId, null, Arrays.asList(channelTypes), defaultValues);
    }

    public static SelectMenu ofChannel(String customId, List<Channel.Type> channelTypes) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_CHANNEL, customId, null, channelTypes, null);
    }

    public static SelectMenu ofChannel(String customId, List<DefaultValue> defaultValues, List<Channel.Type> channelTypes) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_CHANNEL, customId, null, channelTypes, defaultValues);
    }

    private static SelectMenu of(MessageComponent.Type type, String customId, @Nullable List<Option> options, @Nullable List<Channel.Type> channelTypes, @Nullable List<DefaultValue> defaultValues) {
        ImmutableComponentData.Builder builder = ComponentData.builder().type(type.getValue()).customId(customId);
        if (options != null) {
            builder.options(options.stream().map(opt -> ((Option)opt).data).collect(Collectors.toList()));
        }
        if (channelTypes != null) {
            builder.channelTypes(channelTypes.stream().map(Channel.Type::getValue).collect(Collectors.toList()));
        }
        if (defaultValues != null) {
            builder.defaultValues(defaultValues.stream().map(DefaultValue::getData).collect(Collectors.toList()));
        }
        return new SelectMenu((ComponentData)builder.build());
    }

    public static SelectMenu of(int id, String customId, Option ... options) {
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU, customId, Arrays.asList(options), null, null);
    }

    public static SelectMenu of(int id, String customId, List<Option> options) {
        Objects.requireNonNull(options);
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU, customId, options, null, null);
    }

    public static SelectMenu ofRole(int id, String customId) {
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU_ROLE, customId, null, null, null);
    }

    public static SelectMenu ofRole(int id, String customId, List<DefaultValue> defaultValues) {
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU_ROLE, customId, null, null, defaultValues);
    }

    public static SelectMenu ofUser(int id, String customId) {
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU_USER, customId, null, null, null);
    }

    public static SelectMenu ofUser(int id, String customId, List<DefaultValue> defaultValues) {
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU_USER, customId, null, null, defaultValues);
    }

    public static SelectMenu ofMentionable(int id, String customId) {
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU_MENTIONABLE, customId, null, null, null);
    }

    public static SelectMenu ofMentionable(int id, String customId, List<DefaultValue> defaultValues) {
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU_MENTIONABLE, customId, null, null, defaultValues);
    }

    public static SelectMenu ofChannel(int id, String customId, Channel.Type ... channelTypes) {
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU_CHANNEL, customId, null, Arrays.asList(channelTypes), null);
    }

    public static SelectMenu ofChannel(int id, String customId, List<DefaultValue> defaultValues, Channel.Type ... channelTypes) {
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU_CHANNEL, customId, null, Arrays.asList(channelTypes), defaultValues);
    }

    public static SelectMenu ofChannel(int id, String customId, List<Channel.Type> channelTypes) {
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU_CHANNEL, customId, null, channelTypes, null);
    }

    public static SelectMenu ofChannel(int id, String customId, List<DefaultValue> defaultValues, List<Channel.Type> channelTypes) {
        return SelectMenu.of(id, MessageComponent.Type.SELECT_MENU_CHANNEL, customId, null, channelTypes, defaultValues);
    }

    private static SelectMenu of(int id, MessageComponent.Type type, String customId, @Nullable List<Option> options, @Nullable List<Channel.Type> channelTypes, @Nullable List<DefaultValue> defaultValues) {
        ImmutableComponentData.Builder builder = ComponentData.builder().id(Integer.valueOf(id)).type(type.getValue()).customId(customId);
        if (options != null) {
            builder.options(options.stream().map(opt -> ((Option)opt).data).collect(Collectors.toList()));
        }
        if (channelTypes != null) {
            builder.channelTypes(channelTypes.stream().map(Channel.Type::getValue).collect(Collectors.toList()));
        }
        if (defaultValues != null) {
            builder.defaultValues(defaultValues.stream().map(DefaultValue::getData).collect(Collectors.toList()));
        }
        return new SelectMenu((ComponentData)builder.build());
    }

    protected SelectMenu(Integer id, MessageComponent.Type type, String customId, @Nullable List<Option> options, @Nullable List<Channel.Type> channelTypes, @Nullable List<DefaultValue> defaultValues) {
        this((ComponentData)MessageComponent.getBuilder(type).id(Possible.ofNullable((Object)id)).customId(customId).options(Possible.ofNullable(options).map(opts -> opts.stream().map(opt -> ((Option)opt).data).collect(Collectors.toList()))).channelTypes(Possible.ofNullable(channelTypes).map(cts -> cts.stream().map(Channel.Type::getValue).collect(Collectors.toList()))).defaultValues(Possible.ofNullable(defaultValues).map(dvs -> dvs.stream().map(DefaultValue::getData).collect(Collectors.toList()))).build());
    }

    SelectMenu(ComponentData data) {
        super(data);
    }

    public Optional<List<String>> getValues() {
        return this.getData().values().toOptional();
    }

    public Set<Channel.Type> getAllowedChannelTypes() {
        return this.getData().channelTypes().toOptional().orElse(Collections.emptyList()).stream().map(Channel.Type::of).collect(Collectors.toCollection(() -> EnumSet.noneOf(Channel.Type.class)));
    }

    public Optional<String> getPlaceholder() {
        return this.getData().placeholder().toOptional();
    }

    public int getMinValues() {
        return this.getData().minValues().toOptional().orElse(1);
    }

    public int getMaxValues() {
        return this.getData().maxValues().toOptional().orElse(1);
    }

    public List<Option> getOptions() {
        return this.getData().options().toOptional().orElse(Collections.emptyList()).stream().map(Option::new).collect(Collectors.toList());
    }

    public List<DefaultValue> getDefaultValues() {
        return this.getData().defaultValues().toOptional().orElse(Collections.emptyList()).stream().map(DefaultValue::new).collect(Collectors.toList());
    }

    public boolean isDisabled() {
        return this.getData().disabled().toOptional().orElse(false);
    }

    public SelectMenu disabled() {
        return this.disabled(true);
    }

    public SelectMenu disabled(boolean value) {
        return new SelectMenu((ComponentData)ComponentData.builder().from(this.getData()).disabled(Boolean.valueOf(value)).build());
    }

    public SelectMenu withPlaceholder(String placeholder) {
        return new SelectMenu((ComponentData)ComponentData.builder().from(this.getData()).placeholder(placeholder).build());
    }

    public SelectMenu withMinValues(int minValues) {
        return new SelectMenu((ComponentData)ComponentData.builder().from(this.getData()).minValues(Integer.valueOf(minValues)).build());
    }

    public SelectMenu withMaxValues(int maxValues) {
        return new SelectMenu((ComponentData)ComponentData.builder().from(this.getData()).maxValues(Integer.valueOf(maxValues)).build());
    }

    public SelectMenu withAllowedChannelTypes(Iterable<Channel.Type> types) {
        if (this.getType() != MessageComponent.Type.SELECT_MENU_CHANNEL) {
            throw new IllegalArgumentException("Select menu with type " + (Object)((Object)this.getType()) + " can't have channel types restriction");
        }
        return new SelectMenu((ComponentData)ComponentData.builder().from(this.getData()).channelTypes(StreamSupport.stream(types.spliterator(), false).map(Channel.Type::getValue).collect(Collectors.toList())).build());
    }

    public SelectMenu withAllowedChannelTypes(Channel.Type ... types) {
        if (this.getType() != MessageComponent.Type.SELECT_MENU_CHANNEL) {
            throw new IllegalArgumentException("Select menu with type " + (Object)((Object)this.getType()) + " can't have channel types restriction");
        }
        return new SelectMenu((ComponentData)ComponentData.builder().from(this.getData()).channelTypes(Arrays.stream(types).map(Channel.Type::getValue).collect(Collectors.toList())).build());
    }

    public SelectMenu withDefaultValues(Iterable<DefaultValue> values) {
        if (this.getType() != MessageComponent.Type.SELECT_MENU_USER && this.getType() != MessageComponent.Type.SELECT_MENU_ROLE && this.getType() != MessageComponent.Type.SELECT_MENU_MENTIONABLE) {
            throw new IllegalArgumentException("Select menu with type " + (Object)((Object)this.getType()) + " can't have default values");
        }
        List defaultValues = StreamSupport.stream(values.spliterator(), false).map(DefaultValue::getData).collect(Collectors.toList());
        if (defaultValues.size() > this.getMaxValues()) {
            throw new IllegalArgumentException("Default values count (" + defaultValues.size() + ") can't be greater than max values count (" + this.getMaxValues() + ")!");
        }
        if (defaultValues.size() < this.getMinValues()) {
            throw new IllegalArgumentException("Default values count (" + defaultValues.size() + ") can't be less than min values count (" + this.getMinValues() + ")!");
        }
        for (SelectDefaultValueData defaultValue : defaultValues) {
            if (this.getType() == MessageComponent.Type.SELECT_MENU_USER && !defaultValue.type().equals(DefaultValue.Type.USER.value)) {
                throw new IllegalArgumentException("Default value type must be USER for user select menu");
            }
            if (this.getType() == MessageComponent.Type.SELECT_MENU_ROLE && !defaultValue.type().equals(DefaultValue.Type.ROLE.value)) {
                throw new IllegalArgumentException("Default value type must be ROLE for role select menu");
            }
            if (this.getType() == MessageComponent.Type.SELECT_MENU_MENTIONABLE && !defaultValue.type().equals(DefaultValue.Type.USER.value) && !defaultValue.type().equals(DefaultValue.Type.ROLE.value)) {
                throw new IllegalArgumentException("Default value type must be USER or ROLE for mentionable select menu");
            }
            if (this.getType() != MessageComponent.Type.SELECT_MENU_CHANNEL || defaultValue.type().equals(DefaultValue.Type.CHANNEL.value)) continue;
            throw new IllegalArgumentException("Default value type must be CHANNEL for channel select menu");
        }
        return new SelectMenu((ComponentData)ComponentData.builder().from(this.getData()).defaultValues(defaultValues).build());
    }

    public static class DefaultValue {
        private final SelectDefaultValueData data;

        public static DefaultValue of(Snowflake snowflake, Type type) {
            return new DefaultValue((SelectDefaultValueData)SelectDefaultValueData.builder().id(snowflake.asString()).type(type.getValue()).build());
        }

        DefaultValue(SelectDefaultValueData data) {
            this.data = data;
        }

        public Snowflake getId() {
            return Snowflake.of((Id)this.data.id());
        }

        public Type getType() {
            return Type.of(this.data.type());
        }

        public SelectDefaultValueData getData() {
            return this.data;
        }

        public static enum Type {
            UNKNOWN(""),
            USER("user"),
            ROLE("role"),
            CHANNEL("channel");

            private final String value;

            public static Type of(String value) {
                for (Type type : Type.values()) {
                    if (!type.getValue().equals(value)) continue;
                    return type;
                }
                return UNKNOWN;
            }

            private Type(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }
        }
    }

    public static class Option {
        private final SelectOptionData data;

        public static Option of(String label, String value) {
            return Option.of(label, value, false);
        }

        public static Option ofDefault(String label, String value) {
            return Option.of(label, value, true);
        }

        private static Option of(String label, String value, boolean isDefault) {
            return new Option((SelectOptionData)SelectOptionData.builder().label(label).value(value).isDefault(Boolean.valueOf(isDefault)).build());
        }

        Option(SelectOptionData data) {
            this.data = data;
        }

        public String getLabel() {
            return this.data.label();
        }

        public String getValue() {
            return this.data.value();
        }

        public Optional<String> getDescription() {
            return this.data.description().toOptional();
        }

        public Optional<ReactionEmoji> getEmoji() {
            return this.data.emoji().toOptional().map(ReactionEmoji::of);
        }

        public boolean isDefault() {
            return this.data.isDefault().toOptional().orElse(false);
        }

        public Option withDescription(String description) {
            return new Option((SelectOptionData)SelectOptionData.builder().from(this.data).description(description).build());
        }

        public Option withEmoji(ReactionEmoji emoji) {
            return new Option((SelectOptionData)SelectOptionData.builder().from(this.data).emoji(emoji.asEmojiData()).build());
        }

        public Option withDefault(boolean isDefault) {
            return new Option((SelectOptionData)SelectOptionData.builder().from(this.data).isDefault(Boolean.valueOf(isDefault)).build());
        }
    }
}

