/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.discordjson.json.ResolvedChannelData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.PermissionSet;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Mono;

@Experimental
public class ResolvedChannel
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final ResolvedChannelData data;

    public ResolvedChannel(GatewayDiscordClient gateway, ResolvedChannelData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public ResolvedChannelData getData() {
        return this.data;
    }

    public Snowflake getId() {
        return Snowflake.of((String)this.data.id());
    }

    public Optional<String> getName() {
        return this.data.name().toOptional().flatMap(opt -> opt);
    }

    public Channel.Type getType() {
        return Channel.Type.of(this.data.type());
    }

    public Optional<PermissionSet> getEffectivePermissions() {
        return Possible.flatOpt((Possible)this.data.permissions()).map(PermissionSet::of);
    }

    public Mono<Channel> asFullChannel() {
        return this.gateway.getChannelById(this.getId());
    }

    public Mono<Channel> asFullChannel(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById(this.getId());
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public String toString() {
        return "ResolvedChannel{data=" + this.data + '}';
    }
}

