/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.command.ApplicationCommandOption;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.discordjson.json.ApplicationCommandInteractionResolvedData;
import discord4j.discordjson.json.AttachmentData;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Experimental
public class ApplicationCommandInteractionOptionValue
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    @Nullable
    private final Long guildId;
    private final int type;
    private final String value;
    @Nullable
    private final ApplicationCommandInteractionResolvedData resolved;

    public ApplicationCommandInteractionOptionValue(GatewayDiscordClient gateway, @Nullable Long guildId, int type, String value, @Nullable ApplicationCommandInteractionResolvedData resolved) {
        this.gateway = gateway;
        this.guildId = guildId;
        this.value = value;
        this.type = type;
        this.resolved = resolved;
    }

    public String getRaw() {
        return this.value;
    }

    public String asString() {
        return (String)this.getValueAs("string", Function.identity(), ApplicationCommandOption.Type.STRING);
    }

    public boolean asBoolean() {
        return this.getValueAs("boolean", Boolean::parseBoolean, ApplicationCommandOption.Type.BOOLEAN);
    }

    public long asLong() {
        return this.getValueAs("long", Long::parseLong, ApplicationCommandOption.Type.INTEGER);
    }

    public double asDouble() {
        return this.getValueAs("double", Double::parseDouble, ApplicationCommandOption.Type.NUMBER);
    }

    public Snowflake asSnowflake() {
        return this.getValueAs("snowflake", Snowflake::of, ApplicationCommandOption.Type.USER, ApplicationCommandOption.Type.ROLE, ApplicationCommandOption.Type.CHANNEL, ApplicationCommandOption.Type.MENTIONABLE);
    }

    public Mono<User> asUser() {
        return this.getValueAs("user", value -> this.getClient().getUserById(Snowflake.of((String)value)), ApplicationCommandOption.Type.USER);
    }

    public Mono<Role> asRole() {
        return this.getValueAs("role", value -> this.getClient().getRoleById(Snowflake.of((long)Objects.requireNonNull(this.guildId)), Snowflake.of((String)value)), ApplicationCommandOption.Type.ROLE);
    }

    public Mono<Channel> asChannel() {
        return this.getValueAs("channel", value -> this.getClient().getChannelById(Snowflake.of((String)value)), ApplicationCommandOption.Type.CHANNEL);
    }

    public Attachment asAttachment() {
        return this.getValueAs("attachment", value -> new Attachment(this.getClient(), (AttachmentData)((Map)Objects.requireNonNull(this.resolved).attachments().get()).get(value)), ApplicationCommandOption.Type.ATTACHMENT);
    }

    private <T> T getValueAs(String parsedTypeName, Function<String, T> parser, ApplicationCommandOption.Type ... allowedTypes) {
        if (!Arrays.asList(allowedTypes).contains((Object)ApplicationCommandOption.Type.of(this.type))) {
            throw new IllegalArgumentException("Option value cannot be converted as " + parsedTypeName);
        }
        return parser.apply(this.value);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }
}

