/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.audit;

import com.fasterxml.jackson.databind.JsonNode;
import discord4j.common.util.Snowflake;
import discord4j.core.object.ExtendedPermissionOverwrite;
import discord4j.core.object.audit.AuditLogChangeParser;
import discord4j.core.object.audit.AuditLogEntry;
import discord4j.core.object.audit.AuditLogRole;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Sticker;
import discord4j.core.object.entity.channel.Channel;
import discord4j.rest.util.Color;
import discord4j.rest.util.PermissionSet;
import java.time.Instant;
import java.util.Set;
import java.util.function.BiFunction;

public final class ChangeKey<T> {
    public static final ChangeKey<String> NAME = ChangeKey.changeKey("name", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<String> DESCRIPTION = ChangeKey.changeKey("description", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<String> ICON = ChangeKey.changeKey("icon_hash", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<String> SPLASH = ChangeKey.changeKey("splash_hash", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<String> DISCOVERY_SPLASH = ChangeKey.changeKey("discovery_splash_hash", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<String> BANNER = ChangeKey.changeKey("banner_hash", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<Snowflake> OWNER = ChangeKey.changeKey("owner_id", AuditLogChangeParser.SNOWFLAKE_PARSER);
    public static final ChangeKey<String> REGION = ChangeKey.changeKey("region", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<String> PREFERRED_LOCALE = ChangeKey.changeKey("preferred_locale", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<Snowflake> AFK_CHANNEL = ChangeKey.changeKey("afk_channel_id", AuditLogChangeParser.SNOWFLAKE_PARSER);
    public static final ChangeKey<Integer> AFK_TIMEOUT = ChangeKey.changeKey("afk_timeout", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<Snowflake> RULES_CHANNEL = ChangeKey.changeKey("rules_channel_id", AuditLogChangeParser.SNOWFLAKE_PARSER);
    public static final ChangeKey<Snowflake> PUBLIC_UPDATES_CHANNEL = ChangeKey.changeKey("public_updates_channel_id", AuditLogChangeParser.SNOWFLAKE_PARSER);
    public static final ChangeKey<Guild.MfaLevel> MFA_LEVEL = ChangeKey.changeKey("mfa_level", AuditLogChangeParser.INTEGER_PARSER.andThen(Guild.MfaLevel::of));
    public static final ChangeKey<Guild.VerificationLevel> VERIFICATION_LEVEL = ChangeKey.changeKey("verification_level", AuditLogChangeParser.INTEGER_PARSER.andThen(Guild.VerificationLevel::of));
    public static final ChangeKey<Guild.ContentFilterLevel> CONTENT_FILTER_LEVEL = ChangeKey.changeKey("explicit_content_filter", AuditLogChangeParser.INTEGER_PARSER.andThen(Guild.ContentFilterLevel::of));
    public static final ChangeKey<Guild.NotificationLevel> NOTIFICATION_LEVEL = ChangeKey.changeKey("default_message_notifications", AuditLogChangeParser.INTEGER_PARSER.andThen(Guild.NotificationLevel::of));
    public static final ChangeKey<String> VANITY_URL = ChangeKey.changeKey("vanity_url_code", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<Set<AuditLogRole>> ROLES_ADD = ChangeKey.changeKey("$add", AuditLogChangeParser.AUDIT_LOG_ROLES_PARSER);
    public static final ChangeKey<Set<AuditLogRole>> ROLES_REMOVE = ChangeKey.changeKey("$remove", AuditLogChangeParser.AUDIT_LOG_ROLES_PARSER);
    public static final ChangeKey<Integer> PRUNE_DAYS = ChangeKey.changeKey("prune_delete_days", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<Boolean> WIDGET_ENABLED = ChangeKey.changeKey("widget_enabled", AuditLogChangeParser.BOOLEAN_PARSER);
    public static final ChangeKey<Snowflake> WIDGET_CHANNEL = ChangeKey.changeKey("widget_channel_id", AuditLogChangeParser.SNOWFLAKE_PARSER);
    public static final ChangeKey<Snowflake> SYSTEM_CHANNEL = ChangeKey.changeKey("system_channel_id", AuditLogChangeParser.SNOWFLAKE_PARSER);
    public static final ChangeKey<Integer> POSITION = ChangeKey.changeKey("position", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<String> TOPIC = ChangeKey.changeKey("topic", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<Integer> BITRATE = ChangeKey.changeKey("bitrate", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<Set<ExtendedPermissionOverwrite>> OVERWRITES = ChangeKey.changeKey("permission_overwrites", AuditLogChangeParser.OVERWRITES_PARSER);
    public static final ChangeKey<Boolean> NSFW = ChangeKey.changeKey("nsfw", AuditLogChangeParser.BOOLEAN_PARSER);
    public static final ChangeKey<Snowflake> APPLICATION_ID = ChangeKey.changeKey("application_id", AuditLogChangeParser.SNOWFLAKE_PARSER);
    public static final ChangeKey<Integer> RATE_LIMIT_PER_USER = ChangeKey.changeKey("rate_limit_per_user", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<PermissionSet> PERMISSIONS = ChangeKey.changeKey("permissions", AuditLogChangeParser.PERMISSION_SET_PARSER);
    public static final ChangeKey<Color> COLOR = ChangeKey.changeKey("color", AuditLogChangeParser.INTEGER_PARSER.andThen(Color::of));
    public static final ChangeKey<Boolean> HOIST = ChangeKey.changeKey("hoist", AuditLogChangeParser.BOOLEAN_PARSER);
    public static final ChangeKey<Boolean> MENTIONABLE = ChangeKey.changeKey("mentionable", AuditLogChangeParser.BOOLEAN_PARSER);
    public static final ChangeKey<PermissionSet> ALLOW = ChangeKey.changeKey("allow", AuditLogChangeParser.PERMISSION_SET_PARSER);
    public static final ChangeKey<PermissionSet> DENY = ChangeKey.changeKey("deny", AuditLogChangeParser.PERMISSION_SET_PARSER);
    public static final ChangeKey<String> INVITE_CODE = ChangeKey.changeKey("code", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<Snowflake> INVITE_CHANNEL_ID = ChangeKey.changeKey("channel_id", AuditLogChangeParser.SNOWFLAKE_PARSER);
    public static final ChangeKey<Snowflake> INVITER_ID = ChangeKey.changeKey("inviter_id", AuditLogChangeParser.SNOWFLAKE_PARSER);
    public static final ChangeKey<Integer> INVITE_MAX_USES = ChangeKey.changeKey("max_uses", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<Integer> INVITE_USES = ChangeKey.changeKey("uses", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<Integer> INVITE_MAX_AGE = ChangeKey.changeKey("max_age", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<Boolean> INVITE_TEMPORARY = ChangeKey.changeKey("temporary", AuditLogChangeParser.BOOLEAN_PARSER);
    public static final ChangeKey<Boolean> USER_DEAFENED = ChangeKey.changeKey("deaf", AuditLogChangeParser.BOOLEAN_PARSER);
    public static final ChangeKey<Boolean> USER_MUTED = ChangeKey.changeKey("mute", AuditLogChangeParser.BOOLEAN_PARSER);
    public static final ChangeKey<String> USER_NICK = ChangeKey.changeKey("nick", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<String> USER_AVATAR = ChangeKey.changeKey("avatar_hash", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<Snowflake> ID = ChangeKey.changeKey("id", AuditLogChangeParser.SNOWFLAKE_PARSER);
    public static final ChangeKey<Channel.Type> CHANNEL_TYPE = ChangeKey.changeKey("type", AuditLogChangeParser.INTEGER_PARSER.andThen(Channel.Type::of));
    public static final ChangeKey<Boolean> ENABLE_EMOTICONS = ChangeKey.changeKey("enable_emoticons", AuditLogChangeParser.BOOLEAN_PARSER);
    public static final ChangeKey<Integer> EXPIRE_BEHAVIOR = ChangeKey.changeKey("expire_behavior", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<Integer> EXPIRE_GRACE_PERIOD = ChangeKey.changeKey("expire_grace_period", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<Integer> USER_LIMIT = ChangeKey.changeKey("user_limit", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<Instant> COMMUNICATION_DISABLED_UNTIL = ChangeKey.changeKey("communication_disabled_until", AuditLogChangeParser.INSTANT_PARSER);
    public static final ChangeKey<String> ROLE_ICON = ChangeKey.changeKey("unicode_emoji", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<String> STICKER_TAGS = ChangeKey.changeKey("tags", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<Sticker.Format> STICKER_FORMAT_TYPE = ChangeKey.changeKey("format_type", AuditLogChangeParser.INTEGER_PARSER.andThen(Sticker.Format::of));
    public static final ChangeKey<Snowflake> STICKER_GUILD_ID = ChangeKey.changeKey("guild_id", AuditLogChangeParser.SNOWFLAKE_PARSER);
    public static final ChangeKey<Boolean> STICKER_AVAILABLE = ChangeKey.changeKey("available", AuditLogChangeParser.BOOLEAN_PARSER);
    public static final ChangeKey<Boolean> THREAD_ARCHIVED = ChangeKey.changeKey("archived", AuditLogChangeParser.BOOLEAN_PARSER);
    public static final ChangeKey<Integer> THREAD_AUTO_ARCHIVE_DURATION = ChangeKey.changeKey("auto_archive_duration", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<Boolean> THREAD_LOCKED = ChangeKey.changeKey("locked", AuditLogChangeParser.BOOLEAN_PARSER);
    public static final ChangeKey<Integer> ENTITY_TYPE = ChangeKey.changeKey("entity_type", AuditLogChangeParser.INTEGER_PARSER);
    public static final ChangeKey<String> LOCATION = ChangeKey.changeKey("location", AuditLogChangeParser.STRING_PARSER);
    public static final ChangeKey<Integer> STATUS = ChangeKey.changeKey("status", AuditLogChangeParser.INTEGER_PARSER);
    private final String name;
    private final BiFunction<AuditLogEntry, JsonNode, T> parser;

    private static <T> ChangeKey<T> changeKey(String name, BiFunction<AuditLogEntry, JsonNode, T> parser) {
        return new ChangeKey<T>(name, parser);
    }

    private ChangeKey(String name, BiFunction<AuditLogEntry, JsonNode, T> parser) {
        this.name = name;
        this.parser = parser;
    }

    public T parseValue(AuditLogEntry entry, JsonNode value) {
        return this.parser.apply(entry, value);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ChangeKey{name='" + this.name + '\'' + '}';
    }
}

