/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.guild;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.guild.GuildEvent;
import discord4j.core.object.entity.AvatarDecoration;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Role;
import discord4j.core.util.ImageUtil;
import discord4j.gateway.ShardInfo;
import discord4j.rest.util.Image;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class MemberUpdateEvent
extends GuildEvent {
    private static final String AVATAR_IMAGE_PATH = "guilds/%s/users/%s/avatars/%s";
    private static final String BANNER_IMAGE_PATH = "banners/%s/%s";
    private final long guildId;
    private final long memberId;
    @Nullable
    private final Member old;
    private final Set<Long> currentRoleIds;
    @Nullable
    private final String currentNickname;
    @Nullable
    private final String currentAvatar;
    @Nullable
    private final String currentBanner;
    @Nullable
    private final String currentJoinedAt;
    @Nullable
    private final String currentPremiumSince;
    @Nullable
    private final Boolean currentPending;
    @Nullable
    private final String communicationDisabledUntil;
    @Nullable
    private final AvatarDecoration avatarDecoration;

    public MemberUpdateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long guildId, long memberId, @Nullable Member old, Set<Long> currentRoleIds, @Nullable String currentNickname, @Nullable String currentAvatar, @Nullable String currentBanner, @Nullable String currentJoinedAt, @Nullable String currentPremiumSince, @Nullable Boolean currentPending, @Nullable String communicationDisabledUntil, @Nullable AvatarDecoration avatarDecoration) {
        super(gateway, shardInfo);
        this.guildId = guildId;
        this.memberId = memberId;
        this.old = old;
        this.currentRoleIds = currentRoleIds;
        this.currentNickname = currentNickname;
        this.currentAvatar = currentAvatar;
        this.currentBanner = currentBanner;
        this.currentJoinedAt = currentJoinedAt;
        this.currentPremiumSince = currentPremiumSince;
        this.currentPending = currentPending;
        this.communicationDisabledUntil = communicationDisabledUntil;
        this.avatarDecoration = avatarDecoration;
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public Snowflake getMemberId() {
        return Snowflake.of((long)this.memberId);
    }

    public Mono<Member> getMember() {
        return this.getClient().getMemberById(this.getGuildId(), this.getMemberId());
    }

    public Optional<Member> getOld() {
        return Optional.ofNullable(this.old);
    }

    public Set<Snowflake> getCurrentRoleIds() {
        return this.currentRoleIds.stream().map(Snowflake::of).collect(Collectors.toSet());
    }

    public Flux<Role> getCurrentRoles() {
        return this.getClient().getGuildRoles(this.getGuildId()).filter(role -> this.currentRoleIds.contains(role.getId().asLong()));
    }

    public Optional<String> getCurrentNickname() {
        return Optional.ofNullable(this.currentNickname);
    }

    public Optional<String> getCurrentGuildAvatarUrl(Image.Format format) {
        return Optional.ofNullable(this.currentAvatar).map(avatar -> ImageUtil.getUrl(String.format(AVATAR_IMAGE_PATH, this.guildId, Snowflake.asString((long)this.memberId), avatar), format));
    }

    public Mono<Image> getCurrentGuildAvatar(Image.Format format) {
        return Mono.justOrEmpty(this.getCurrentGuildAvatarUrl(format)).flatMap(Image::ofUrl);
    }

    public Optional<String> getCurrentGuildBannerUrl(Image.Format format) {
        return Optional.ofNullable(this.currentBanner).map(avatar -> ImageUtil.getUrl(String.format(BANNER_IMAGE_PATH, this.guildId, Snowflake.asString((long)this.memberId), avatar), format));
    }

    public Mono<Image> getCurrentGuildBanner(Image.Format format) {
        return Mono.justOrEmpty(this.getCurrentGuildBannerUrl(format)).flatMap(Image::ofUrl);
    }

    public Optional<Instant> getJoinTime() {
        return Optional.ofNullable(this.currentJoinedAt).map(it -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)it, Instant::from));
    }

    public Optional<Instant> getCurrentPremiumSince() {
        return Optional.ofNullable(this.currentPremiumSince).map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public boolean isCurrentPending() {
        return Optional.ofNullable(this.currentPending).orElse(false);
    }

    public Optional<Instant> getCommunicationDisabledUntil() {
        return Optional.ofNullable(this.communicationDisabledUntil).map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public Optional<AvatarDecoration> getAvatarDecoration() {
        return Optional.ofNullable(this.avatarDecoration);
    }

    public String toString() {
        return "MemberUpdateEvent{guildId=" + this.guildId + ", memberId=" + this.memberId + ", old=" + this.old + ", currentRoleIds=" + this.currentRoleIds + ", currentNickname='" + this.currentNickname + '\'' + ", currentAvatar='" + this.currentAvatar + '\'' + ", currentJoinedAt='" + this.currentJoinedAt + '\'' + ", currentPremiumSince='" + this.currentPremiumSince + '\'' + ", currentPending=" + this.currentPending + ", communicationDisabledUntil='" + this.communicationDisabledUntil + '\'' + ", avatarDecoration='" + this.avatarDecoration + '\'' + '}';
    }
}

