/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.automod;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.automod.AutoModRule;
import discord4j.core.object.automod.AutoModRuleAction;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.gateway.AutoModActionExecution;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import reactor.core.publisher.Mono;

public class AutoModActionExecutedEvent
extends Event {
    private final AutoModActionExecution data;
    private final AutoModRuleAction autoModRuleAction;

    public AutoModActionExecutedEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, AutoModActionExecution autoModActionExecution) {
        super(gateway, shardInfo);
        this.data = autoModActionExecution;
        this.autoModRuleAction = new AutoModRuleAction(gateway, autoModActionExecution.action());
    }

    public AutoModActionExecution getData() {
        return this.data;
    }

    public Snowflake getGuildId() {
        return Snowflake.of((Id)this.data.guildId());
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public AutoModRuleAction getAction() {
        return this.autoModRuleAction;
    }

    public Snowflake getAutoModRuleId() {
        return Snowflake.of((Id)this.data.ruleId());
    }

    public Mono<AutoModRule> getAutoModRule() {
        return this.getGuild().flatMap(guild -> guild.getAutoModRule(this.getAutoModRuleId()));
    }

    public AutoModRule.TriggerType getTriggerType() {
        return AutoModRule.TriggerType.of(this.data.ruleTriggerType());
    }

    public Snowflake getUserId() {
        return Snowflake.of((Id)this.data.userId());
    }

    public Mono<User> getUser() {
        return this.getClient().getUserById(this.getUserId());
    }

    public Mono<Member> getMember() {
        return this.getClient().getMemberById(this.getGuildId(), this.getUserId());
    }

    public Optional<Snowflake> getChannelId() {
        return this.data.channelId().toOptional().map(Snowflake::of);
    }

    public Mono<MessageChannel> getChannel() {
        return Mono.justOrEmpty(this.getChannelId()).flatMap(this.getClient()::getChannelById).cast(MessageChannel.class);
    }

    public Optional<Snowflake> getMessageId() {
        return this.data.messageId().toOptional().map(Snowflake::of);
    }

    public Mono<Message> getMessage() {
        if (!this.getChannelId().isPresent() || !this.getMessageId().isPresent()) {
            return Mono.empty();
        }
        return this.getClient().getMessageById(this.getChannelId().get(), this.getMessageId().get());
    }

    public Optional<Snowflake> getSystemMessageId() {
        return this.data.alertSystemMessageId().toOptional().map(Snowflake::of);
    }

    public String getContent() {
        return this.data.content();
    }

    public Optional<String> getMatchedKeyword() {
        return this.data.matchedKeyword();
    }

    public Optional<String> getMatchedContent() {
        return this.data.matchedContent();
    }
}

