/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.dispatch;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.dispatch.DispatchContext;
import discord4j.core.event.domain.command.ApplicationCommandCreateEvent;
import discord4j.core.event.domain.command.ApplicationCommandDeleteEvent;
import discord4j.core.event.domain.command.ApplicationCommandPermissionUpdateEvent;
import discord4j.core.event.domain.command.ApplicationCommandUpdateEvent;
import discord4j.core.object.command.ApplicationCommand;
import discord4j.core.object.command.ApplicationCommandGuildPermissions;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ApplicationCommandData;
import discord4j.discordjson.json.GuildApplicationCommandPermissionsData;
import discord4j.discordjson.json.gateway.ApplicationCommandCreate;
import discord4j.discordjson.json.gateway.ApplicationCommandDelete;
import discord4j.discordjson.json.gateway.ApplicationCommandPermissionUpdate;
import discord4j.discordjson.json.gateway.ApplicationCommandUpdate;
import discord4j.gateway.ShardInfo;
import reactor.core.publisher.Mono;

class ApplicationCommandDispatchHandlers {
    ApplicationCommandDispatchHandlers() {
    }

    static Mono<ApplicationCommandCreateEvent> applicationCommandCreate(DispatchContext<ApplicationCommandCreate, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        ShardInfo shardInfo = context.getShardInfo();
        Long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        ApplicationCommandData command = context.getDispatch().command();
        return Mono.just((Object)new ApplicationCommandCreateEvent(gateway, shardInfo, new ApplicationCommand(gateway, command), guildId));
    }

    static Mono<ApplicationCommandUpdateEvent> applicationCommandUpdate(DispatchContext<ApplicationCommandUpdate, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        ShardInfo shardInfo = context.getShardInfo();
        Long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        ApplicationCommandData command = context.getDispatch().command();
        return Mono.just((Object)new ApplicationCommandUpdateEvent(gateway, shardInfo, new ApplicationCommand(gateway, command), guildId));
    }

    static Mono<ApplicationCommandDeleteEvent> applicationCommandDelete(DispatchContext<ApplicationCommandDelete, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        ShardInfo shardInfo = context.getShardInfo();
        Long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        ApplicationCommandData command = context.getDispatch().command();
        return Mono.just((Object)new ApplicationCommandDeleteEvent(gateway, shardInfo, new ApplicationCommand(gateway, command), guildId));
    }

    static Mono<ApplicationCommandPermissionUpdateEvent> applicationCommandPermissionUpdate(DispatchContext<ApplicationCommandPermissionUpdate, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        ShardInfo shardInfo = context.getShardInfo();
        GuildApplicationCommandPermissionsData data = context.getDispatch().data();
        return Mono.just((Object)new ApplicationCommandPermissionUpdateEvent(gateway, shardInfo, new ApplicationCommandGuildPermissions(gateway, data)));
    }
}

