/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice;

import discord4j.voice.AudioProvider;
import discord4j.voice.PacketTransformer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import reactor.core.Disposable;
import reactor.core.scheduler.Scheduler;

public class LocalVoiceSendTask
implements Disposable {
    private final Consumer<Boolean> speakingSender;
    private final Consumer<ByteBuf> voiceSender;
    private final AudioProvider provider;
    private final PacketTransformer transformer;
    private final Disposable task;
    private final AtomicBoolean speaking = new AtomicBoolean();
    private final AtomicBoolean sentSilence = new AtomicBoolean();
    private final byte[] silence = new byte[]{-8, -1, -2};

    public LocalVoiceSendTask(Scheduler scheduler, Consumer<Boolean> speakingSender, Consumer<ByteBuf> voiceSender, AudioProvider provider, PacketTransformer transformer) {
        this.speakingSender = speakingSender;
        this.voiceSender = voiceSender;
        this.provider = provider;
        this.transformer = transformer;
        this.task = scheduler.schedulePeriodically(this::run, 0L, 20L, TimeUnit.MILLISECONDS);
    }

    public void dispose() {
        if (this.speaking.compareAndSet(true, false)) {
            this.changeSpeaking(false);
        }
        this.task.dispose();
    }

    public boolean isDisposed() {
        return this.task.isDisposed();
    }

    private void run() {
        if (this.provider.provide()) {
            if (this.speaking.compareAndSet(false, true)) {
                this.changeSpeaking(true);
            }
            byte[] b = new byte[this.provider.getBuffer().limit()];
            this.provider.getBuffer().get(b);
            this.provider.getBuffer().clear();
            ByteBuf packet = Unpooled.wrappedBuffer((byte[])this.transformer.nextSend(b));
            this.voiceSender.accept(packet);
        } else if (this.speaking.compareAndSet(true, false)) {
            this.changeSpeaking(false);
        } else if (this.sentSilence.compareAndSet(false, true)) {
            this.voiceSender.accept(Unpooled.wrappedBuffer((byte[])this.transformer.nextSend(this.silence)));
        }
    }

    private void changeSpeaking(boolean speaking) {
        this.speakingSender.accept(speaking);
    }
}

