/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.jdk;

import discord4j.store.api.Store;
import discord4j.store.api.util.WithinRangePredicate;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class JdkStore<K extends Comparable<K>, V>
implements Store<K, V> {
    private final Map<K, V> map;

    public JdkStore(Map<K, V> map) {
        this.map = map;
    }

    public JdkStore(boolean persist) {
        this.map = persist ? new ConcurrentHashMap() : Collections.synchronizedMap(new WeakHashMap());
    }

    public Mono<Void> save(K key, V value) {
        return Mono.fromRunnable(() -> this.map.put((Comparable)key, value));
    }

    public Mono<Void> save(Publisher<Tuple2<K, V>> entryStream) {
        return Flux.from(entryStream).doOnNext(t -> this.map.put((Comparable)t.getT1(), t.getT2())).then();
    }

    public Mono<V> find(K id) {
        return Mono.defer(() -> {
            if (this.map.containsKey(id)) {
                return Mono.just(this.map.get(id));
            }
            return Mono.empty();
        });
    }

    public Flux<V> findInRange(K start, K end) {
        return this.keys().filter((Predicate)new WithinRangePredicate(start, end)).map(this.map::get);
    }

    public Mono<Long> count() {
        return Mono.fromSupplier(() -> this.map.size());
    }

    public Mono<Void> delete(K id) {
        return Mono.just(id).doOnNext(this.map::remove).then();
    }

    public Mono<Void> delete(Publisher<K> ids) {
        return Flux.from(ids).doOnNext(this.map::remove).then();
    }

    public Mono<Void> deleteInRange(K start, K end) {
        return this.keys().filter((Predicate)new WithinRangePredicate(start, end)).doOnNext(this.map::remove).then();
    }

    public Mono<Void> deleteAll() {
        return Mono.fromRunnable(this.map::clear);
    }

    public Flux<K> keys() {
        return Flux.defer(() -> Flux.fromIterable(this.map.keySet()));
    }

    public Flux<V> values() {
        return Flux.defer(() -> Flux.fromIterable(this.map.values()));
    }

    public Flux<Tuple2<K, V>> entries() {
        return Flux.defer(() -> Flux.fromIterable(this.map.entrySet())).map(e -> Tuples.of((Object)((Comparable)e.getKey()), e.getValue()));
    }

    public Mono<Void> invalidate() {
        return Mono.fromRunnable(this.map::clear);
    }

    protected Map<K, V> getMap() {
        return this.map;
    }

    public String toString() {
        return "JdkStore@" + Integer.toHexString(this.hashCode()) + "{map=" + this.map.getClass().getCanonicalName() + '}';
    }
}

