/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.gateway.Identify;
import discord4j.discordjson.json.gateway.IdentifyProperties;
import discord4j.discordjson.json.gateway.StatusUpdate;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableIdentify
implements Identify {
    private final String token;
    private final IdentifyProperties properties;
    private final Boolean compress_value;
    private final boolean compress_absent;
    private final int largeThreshold;
    private final int[] shard_value;
    private final boolean shard_absent;
    private final StatusUpdate presence_value;
    private final boolean presence_absent;
    private final Long intents_value;
    private final boolean intents_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableIdentify(String token, IdentifyProperties properties, Possible<Boolean> compress, int largeThreshold, Possible<int[]> shard, Possible<StatusUpdate> presence, Possible<Long> intents) {
        this.token = Objects.requireNonNull(token, "token");
        this.properties = Objects.requireNonNull(properties, "properties");
        Possible<Boolean> compress$impl = compress;
        this.largeThreshold = largeThreshold;
        Possible<int[]> shard$impl = shard;
        Possible<StatusUpdate> presence$impl = presence;
        Possible<Long> intents$impl = intents;
        this.compress_value = compress$impl.toOptional().orElse(null);
        this.compress_absent = compress$impl.isAbsent();
        this.shard_value = shard$impl.toOptional().orElse(null);
        this.shard_absent = shard$impl.isAbsent();
        this.presence_value = presence$impl.toOptional().orElse(null);
        this.presence_absent = presence$impl.isAbsent();
        this.intents_value = intents$impl.toOptional().orElse(null);
        this.intents_absent = intents$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableIdentify(ImmutableIdentify original, String token, IdentifyProperties properties, Possible<Boolean> compress, int largeThreshold, Possible<int[]> shard, Possible<StatusUpdate> presence, Possible<Long> intents) {
        this.token = token;
        this.properties = properties;
        Possible<Boolean> compress$impl = compress;
        this.largeThreshold = largeThreshold;
        Possible<int[]> shard$impl = shard;
        Possible<StatusUpdate> presence$impl = presence;
        Possible<Long> intents$impl = intents;
        this.compress_value = compress$impl.toOptional().orElse(null);
        this.compress_absent = compress$impl.isAbsent();
        this.shard_value = shard$impl.toOptional().orElse(null);
        this.shard_absent = shard$impl.isAbsent();
        this.presence_value = presence$impl.toOptional().orElse(null);
        this.presence_absent = presence$impl.isAbsent();
        this.intents_value = intents$impl.toOptional().orElse(null);
        this.intents_absent = intents$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="token")
    public String token() {
        return this.token;
    }

    @Override
    @JsonProperty(value="properties")
    public IdentifyProperties properties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="compress")
    public Possible<Boolean> compress() {
        return this.compress_absent ? Possible.absent() : Possible.of((Object)this.compress_value);
    }

    @Override
    @JsonProperty(value="large_threshold")
    public int largeThreshold() {
        return this.largeThreshold;
    }

    @Override
    @JsonProperty(value="shard")
    public Possible<int[]> shard() {
        return this.shard_absent ? Possible.absent() : Possible.of((Object)this.shard_value);
    }

    @Override
    @JsonProperty(value="presence")
    public Possible<StatusUpdate> presence() {
        return this.presence_absent ? Possible.absent() : Possible.of((Object)this.presence_value);
    }

    @Override
    @JsonProperty(value="intents")
    public Possible<Long> intents() {
        return this.intents_absent ? Possible.absent() : Possible.of((Object)this.intents_value);
    }

    public final ImmutableIdentify withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new ImmutableIdentify(this, newValue, this.properties, this.compress(), this.largeThreshold, this.shard(), this.presence(), this.intents());
    }

    public final ImmutableIdentify withProperties(IdentifyProperties value) {
        if (this.properties == value) {
            return this;
        }
        IdentifyProperties newValue = Objects.requireNonNull(value, "properties");
        return new ImmutableIdentify(this, this.token, newValue, this.compress(), this.largeThreshold, this.shard(), this.presence(), this.intents());
    }

    public ImmutableIdentify withCompress(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableIdentify(this, this.token, this.properties, newValue, this.largeThreshold, this.shard(), this.presence(), this.intents());
    }

    public ImmutableIdentify withCompress(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableIdentify(this, this.token, this.properties, (Possible<Boolean>)newValue, this.largeThreshold, this.shard(), this.presence(), this.intents());
    }

    public final ImmutableIdentify withLargeThreshold(int value) {
        if (this.largeThreshold == value) {
            return this;
        }
        return new ImmutableIdentify(this, this.token, this.properties, this.compress(), value, this.shard(), this.presence(), this.intents());
    }

    public ImmutableIdentify withShard(Possible<int[]> value) {
        Possible<int[]> newValue = Objects.requireNonNull(value);
        return new ImmutableIdentify(this, this.token, this.properties, this.compress(), this.largeThreshold, newValue, this.presence(), this.intents());
    }

    public ImmutableIdentify withShard(int[] value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableIdentify(this, this.token, this.properties, this.compress(), this.largeThreshold, (Possible<int[]>)newValue, this.presence(), this.intents());
    }

    public ImmutableIdentify withPresence(Possible<StatusUpdate> value) {
        Possible<StatusUpdate> newValue = Objects.requireNonNull(value);
        return new ImmutableIdentify(this, this.token, this.properties, this.compress(), this.largeThreshold, this.shard(), newValue, this.intents());
    }

    public ImmutableIdentify withPresence(StatusUpdate value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableIdentify(this, this.token, this.properties, this.compress(), this.largeThreshold, this.shard(), (Possible<StatusUpdate>)newValue, this.intents());
    }

    public ImmutableIdentify withIntents(Possible<Long> value) {
        Possible<Long> newValue = Objects.requireNonNull(value);
        return new ImmutableIdentify(this, this.token, this.properties, this.compress(), this.largeThreshold, this.shard(), this.presence(), newValue);
    }

    public ImmutableIdentify withIntents(Long value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableIdentify(this, this.token, this.properties, this.compress(), this.largeThreshold, this.shard(), this.presence(), (Possible<Long>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIdentify && this.equalTo(0, (ImmutableIdentify)another);
    }

    private boolean equalTo(int synthetic, ImmutableIdentify another) {
        return this.token.equals(another.token) && this.properties.equals(another.properties) && this.compress().equals(another.compress()) && this.largeThreshold == another.largeThreshold && this.shard().equals(another.shard()) && this.presence().equals(another.presence()) && this.intents().equals(another.intents());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.compress().hashCode();
        h += (h << 5) + this.largeThreshold;
        h += (h << 5) + this.shard().hashCode();
        h += (h << 5) + this.presence().hashCode();
        h += (h << 5) + this.intents().hashCode();
        return h;
    }

    public String toString() {
        return "Identify{token=" + this.token + ", properties=" + this.properties + ", compress=" + this.compress().toString() + ", largeThreshold=" + this.largeThreshold + ", shard=" + this.shard().toString() + ", presence=" + this.presence().toString() + ", intents=" + this.intents().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIdentify fromJson(Json json) {
        Builder builder = ImmutableIdentify.builder();
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.properties != null) {
            builder.properties(json.properties);
        }
        if (json.compress != null) {
            builder.compress(json.compress);
        }
        if (json.largeThresholdIsSet) {
            builder.largeThreshold(json.largeThreshold);
        }
        if (json.shard != null) {
            builder.shard(json.shard);
        }
        if (json.presence != null) {
            builder.presence(json.presence);
        }
        if (json.intents != null) {
            builder.intents(json.intents);
        }
        return builder.build();
    }

    public static ImmutableIdentify of(String token, IdentifyProperties properties, Possible<Boolean> compress, int largeThreshold, Possible<int[]> shard, Possible<StatusUpdate> presence, Possible<Long> intents) {
        return new ImmutableIdentify(token, properties, compress, largeThreshold, shard, presence, intents);
    }

    public static ImmutableIdentify copyOf(Identify instance) {
        if (instance instanceof ImmutableIdentify) {
            return (ImmutableIdentify)instance;
        }
        return ImmutableIdentify.builder().from(instance).build();
    }

    public boolean isCompressPresent() {
        return !this.compress_absent;
    }

    public Boolean compressOrElse(Boolean defaultValue) {
        return !this.compress_absent ? this.compress_value : defaultValue;
    }

    public boolean isShardPresent() {
        return !this.shard_absent;
    }

    public int[] shardOrElse(int[] defaultValue) {
        return !this.shard_absent ? this.shard_value : defaultValue;
    }

    public boolean isPresencePresent() {
        return !this.presence_absent;
    }

    public StatusUpdate presenceOrElse(StatusUpdate defaultValue) {
        return !this.presence_absent ? this.presence_value : defaultValue;
    }

    public boolean isIntentsPresent() {
        return !this.intents_absent;
    }

    public Long intentsOrElse(Long defaultValue) {
        return !this.intents_absent ? this.intents_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_PROPERTIES = 2L;
        private static final long INIT_BIT_LARGE_THRESHOLD = 4L;
        private long initBits = 7L;
        private Possible<Boolean> compress_possible = Possible.absent();
        private Possible<int[]> shard_possible = Possible.absent();
        private Possible<StatusUpdate> presence_possible = Possible.absent();
        private Possible<Long> intents_possible = Possible.absent();
        @Nullable
        private String token;
        @Nullable
        private IdentifyProperties properties;
        private int largeThreshold;

        private Builder() {
        }

        public final Builder from(Identify instance) {
            Objects.requireNonNull(instance, "instance");
            this.token(instance.token());
            this.properties(instance.properties());
            this.compress(instance.compress());
            this.largeThreshold(instance.largeThreshold());
            this.shard(instance.shard());
            this.presence(instance.presence());
            this.intents(instance.intents());
            return this;
        }

        @JsonProperty(value="token")
        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="properties")
        public final Builder properties(IdentifyProperties properties) {
            this.properties = Objects.requireNonNull(properties, "properties");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="compress")
        public Builder compress(Possible<Boolean> value) {
            this.compress_possible = value;
            return this;
        }

        public Builder compress(Boolean value) {
            this.compress_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="large_threshold")
        public final Builder largeThreshold(int largeThreshold) {
            this.largeThreshold = largeThreshold;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="shard")
        public Builder shard(Possible<int[]> value) {
            this.shard_possible = value;
            return this;
        }

        public Builder shard(int[] value) {
            this.shard_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="presence")
        public Builder presence(Possible<StatusUpdate> value) {
            this.presence_possible = value;
            return this;
        }

        public Builder presence(StatusUpdate value) {
            this.presence_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="intents")
        public Builder intents(Possible<Long> value) {
            this.intents_possible = value;
            return this;
        }

        public Builder intents(Long value) {
            this.intents_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableIdentify build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIdentify(null, this.token, this.properties, this.compress_build(), this.largeThreshold, this.shard_build(), this.presence_build(), this.intents_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("properties");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("largeThreshold");
            }
            return "Cannot build Identify, some of required attributes are not set " + attributes;
        }

        private Possible<Boolean> compress_build() {
            return this.compress_possible;
        }

        private Possible<int[]> shard_build() {
            return this.shard_possible;
        }

        private Possible<StatusUpdate> presence_build() {
            return this.presence_possible;
        }

        private Possible<Long> intents_build() {
            return this.intents_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Identify {
        @Nullable
        String token;
        @Nullable
        IdentifyProperties properties;
        Possible<Boolean> compress = Possible.absent();
        int largeThreshold;
        boolean largeThresholdIsSet;
        Possible<int[]> shard = Possible.absent();
        Possible<StatusUpdate> presence = Possible.absent();
        Possible<Long> intents = Possible.absent();

        Json() {
        }

        @JsonProperty(value="token")
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty(value="properties")
        public void setProperties(IdentifyProperties properties) {
            this.properties = properties;
        }

        @JsonProperty(value="compress")
        public void setCompress(Possible<Boolean> compress) {
            this.compress = compress;
        }

        @JsonProperty(value="large_threshold")
        public void setLargeThreshold(int largeThreshold) {
            this.largeThreshold = largeThreshold;
            this.largeThresholdIsSet = true;
        }

        @JsonProperty(value="shard")
        public void setShard(Possible<int[]> shard) {
            this.shard = shard;
        }

        @JsonProperty(value="presence")
        public void setPresence(Possible<StatusUpdate> presence) {
            this.presence = presence;
        }

        @JsonProperty(value="intents")
        public void setIntents(Possible<Long> intents) {
            this.intents = intents;
        }

        @Override
        public String token() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IdentifyProperties properties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> compress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int largeThreshold() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<int[]> shard() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<StatusUpdate> presence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Long> intents() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build Identify, attribute initializers form cycle " + attributes;
        }
    }
}

