/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AvatarDecorationData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.gateway.GuildMemberUpdate;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableGuildMemberUpdate
implements GuildMemberUpdate {
    private final long guildId_value;
    private final List<String> roles;
    private final UserData user;
    private final String nick_value;
    private final boolean nick_absent;
    @Nullable
    private final String avatar;
    @Nullable
    private final String banner;
    @Nullable
    private final String joinedAt;
    private final String premiumSince_value;
    private final boolean premiumSince_absent;
    private final Boolean pending_value;
    private final boolean pending_absent;
    private final String communicationDisabledUntil_value;
    private final boolean communicationDisabledUntil_absent;
    private final AvatarDecorationData avatarDecoration_value;
    private final boolean avatarDecoration_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGuildMemberUpdate(Id guildId, Iterable<String> roles, UserData user, Possible<Optional<String>> nick, Optional<String> avatar, Optional<String> banner, Optional<String> joinedAt, Possible<Optional<String>> premiumSince, Possible<Boolean> pending, Possible<Optional<String>> communicationDisabledUntil, Possible<Optional<AvatarDecorationData>> avatarDecoration) {
        Id guildId$impl = guildId;
        this.roles = ImmutableGuildMemberUpdate.createUnmodifiableList(false, ImmutableGuildMemberUpdate.createSafeList(roles, true, false));
        this.user = Objects.requireNonNull(user, "user");
        Possible<Optional<String>> nick$impl = nick;
        this.avatar = avatar.orElse(null);
        this.banner = banner.orElse(null);
        this.joinedAt = joinedAt.orElse(null);
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        Possible<Boolean> pending$impl = pending;
        Possible<Optional<String>> communicationDisabledUntil$impl = communicationDisabledUntil;
        Possible<Optional<AvatarDecorationData>> avatarDecoration$impl = avatarDecoration;
        this.guildId_value = guildId$impl.asLong();
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.pending_value = pending$impl.toOptional().orElse(null);
        this.pending_absent = pending$impl.isAbsent();
        this.communicationDisabledUntil_value = Possible.flatOpt(communicationDisabledUntil$impl).orElse(null);
        this.communicationDisabledUntil_absent = communicationDisabledUntil$impl.isAbsent();
        this.avatarDecoration_value = Possible.flatOpt(avatarDecoration$impl).orElse(null);
        this.avatarDecoration_absent = avatarDecoration$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableGuildMemberUpdate(ImmutableGuildMemberUpdate original, Id guildId, List<String> roles, UserData user, Possible<Optional<String>> nick, @Nullable String avatar, @Nullable String banner, @Nullable String joinedAt, Possible<Optional<String>> premiumSince, Possible<Boolean> pending, Possible<Optional<String>> communicationDisabledUntil, Possible<Optional<AvatarDecorationData>> avatarDecoration) {
        Id guildId$impl = guildId;
        this.roles = roles;
        this.user = user;
        Possible<Optional<String>> nick$impl = nick;
        this.avatar = avatar;
        this.banner = banner;
        this.joinedAt = joinedAt;
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        Possible<Boolean> pending$impl = pending;
        Possible<Optional<String>> communicationDisabledUntil$impl = communicationDisabledUntil;
        Possible<Optional<AvatarDecorationData>> avatarDecoration$impl = avatarDecoration;
        this.guildId_value = guildId$impl.asLong();
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.pending_value = pending$impl.toOptional().orElse(null);
        this.pending_absent = pending$impl.isAbsent();
        this.communicationDisabledUntil_value = Possible.flatOpt(communicationDisabledUntil$impl).orElse(null);
        this.communicationDisabledUntil_absent = communicationDisabledUntil$impl.isAbsent();
        this.avatarDecoration_value = Possible.flatOpt(avatarDecoration$impl).orElse(null);
        this.avatarDecoration_absent = avatarDecoration$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="roles")
    public List<String> roles() {
        return this.roles;
    }

    @Override
    @JsonProperty(value="user")
    public UserData user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="nick")
    public Possible<Optional<String>> nick() {
        return this.nick_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.nick_value));
    }

    @Override
    @JsonProperty(value="avatar")
    public Optional<String> avatar() {
        return Optional.ofNullable(this.avatar);
    }

    @Override
    @JsonProperty(value="banner")
    public Optional<String> banner() {
        return Optional.ofNullable(this.banner);
    }

    @Override
    @JsonProperty(value="joined_at")
    public Optional<String> joinedAt() {
        return Optional.ofNullable(this.joinedAt);
    }

    @Override
    @JsonProperty(value="premium_since")
    public Possible<Optional<String>> premiumSince() {
        return this.premiumSince_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.premiumSince_value));
    }

    @Override
    @JsonProperty(value="pending")
    public Possible<Boolean> pending() {
        return this.pending_absent ? Possible.absent() : Possible.of((Object)this.pending_value);
    }

    @Override
    @JsonProperty(value="communication_disabled_until")
    public Possible<Optional<String>> communicationDisabledUntil() {
        return this.communicationDisabledUntil_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.communicationDisabledUntil_value));
    }

    @Override
    @JsonProperty(value="avatar_decoration_data")
    public Possible<Optional<AvatarDecorationData>> avatarDecoration() {
        return this.avatarDecoration_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.avatarDecoration_value));
    }

    public ImmutableGuildMemberUpdate withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableGuildMemberUpdate(this, newValue, this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public ImmutableGuildMemberUpdate withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableGuildMemberUpdate(this, newValue, this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public final ImmutableGuildMemberUpdate withRoles(String ... elements) {
        List<String> newValue = ImmutableGuildMemberUpdate.createUnmodifiableList(false, ImmutableGuildMemberUpdate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGuildMemberUpdate(this, this.guildId(), newValue, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public final ImmutableGuildMemberUpdate withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        List<String> newValue = ImmutableGuildMemberUpdate.createUnmodifiableList(false, ImmutableGuildMemberUpdate.createSafeList(elements, true, false));
        return new ImmutableGuildMemberUpdate(this, this.guildId(), newValue, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public final ImmutableGuildMemberUpdate withUser(UserData value) {
        if (this.user == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, newValue, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public ImmutableGuildMemberUpdate withNick(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, newValue, this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    @Deprecated
    public ImmutableGuildMemberUpdate withNick(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, (Possible<Optional<String>>)newValue, this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public ImmutableGuildMemberUpdate withNickOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, (Possible<Optional<String>>)newValue, this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public final ImmutableGuildMemberUpdate withAvatar(String value) {
        String newValue = Objects.requireNonNull(value, "avatar");
        if (Objects.equals(this.avatar, newValue)) {
            return this;
        }
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), newValue, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public final ImmutableGuildMemberUpdate withAvatar(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.avatar, value)) {
            return this;
        }
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), value, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public final ImmutableGuildMemberUpdate withBanner(String value) {
        String newValue = Objects.requireNonNull(value, "banner");
        if (Objects.equals(this.banner, newValue)) {
            return this;
        }
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, newValue, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public final ImmutableGuildMemberUpdate withBanner(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.banner, value)) {
            return this;
        }
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, value, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public final ImmutableGuildMemberUpdate withJoinedAt(String value) {
        String newValue = Objects.requireNonNull(value, "joinedAt");
        if (Objects.equals(this.joinedAt, newValue)) {
            return this;
        }
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, newValue, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public final ImmutableGuildMemberUpdate withJoinedAt(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.joinedAt, value)) {
            return this;
        }
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, value, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public ImmutableGuildMemberUpdate withPremiumSince(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, newValue, this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    @Deprecated
    public ImmutableGuildMemberUpdate withPremiumSince(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, (Possible<Optional<String>>)newValue, this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public ImmutableGuildMemberUpdate withPremiumSinceOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, (Possible<Optional<String>>)newValue, this.pending(), this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public ImmutableGuildMemberUpdate withPending(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), newValue, this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public ImmutableGuildMemberUpdate withPending(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), (Possible<Boolean>)newValue, this.communicationDisabledUntil(), this.avatarDecoration());
    }

    public ImmutableGuildMemberUpdate withCommunicationDisabledUntil(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), newValue, this.avatarDecoration());
    }

    @Deprecated
    public ImmutableGuildMemberUpdate withCommunicationDisabledUntil(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), (Possible<Optional<String>>)newValue, this.avatarDecoration());
    }

    public ImmutableGuildMemberUpdate withCommunicationDisabledUntilOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), (Possible<Optional<String>>)newValue, this.avatarDecoration());
    }

    public ImmutableGuildMemberUpdate withAvatarDecoration(Possible<Optional<AvatarDecorationData>> value) {
        Possible<Optional<AvatarDecorationData>> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), newValue);
    }

    @Deprecated
    public ImmutableGuildMemberUpdate withAvatarDecoration(@Nullable AvatarDecorationData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), (Possible<Optional<AvatarDecorationData>>)newValue);
    }

    public ImmutableGuildMemberUpdate withAvatarDecorationOrNull(@Nullable AvatarDecorationData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildMemberUpdate(this, this.guildId(), this.roles, this.user, this.nick(), this.avatar, this.banner, this.joinedAt, this.premiumSince(), this.pending(), this.communicationDisabledUntil(), (Possible<Optional<AvatarDecorationData>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildMemberUpdate && this.equalTo(0, (ImmutableGuildMemberUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildMemberUpdate another) {
        return Objects.equals(this.guildId_value, another.guildId_value) && this.roles.equals(another.roles) && this.user.equals(another.user) && this.nick().equals(another.nick()) && Objects.equals(this.avatar, another.avatar) && Objects.equals(this.banner, another.banner) && Objects.equals(this.joinedAt, another.joinedAt) && this.premiumSince().equals(another.premiumSince()) && this.pending().equals(another.pending()) && this.communicationDisabledUntil().equals(another.communicationDisabledUntil()) && this.avatarDecoration().equals(another.avatarDecoration());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.nick().hashCode();
        h += (h << 5) + Objects.hashCode(this.avatar);
        h += (h << 5) + Objects.hashCode(this.banner);
        h += (h << 5) + Objects.hashCode(this.joinedAt);
        h += (h << 5) + this.premiumSince().hashCode();
        h += (h << 5) + this.pending().hashCode();
        h += (h << 5) + this.communicationDisabledUntil().hashCode();
        h += (h << 5) + this.avatarDecoration().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GuildMemberUpdate{");
        builder.append("guildId=").append(Objects.toString(this.guildId_value));
        builder.append(", ");
        builder.append("roles=").append(this.roles);
        builder.append(", ");
        builder.append("user=").append(this.user);
        builder.append(", ");
        builder.append("nick=").append(this.nick().toString());
        if (this.avatar != null) {
            builder.append(", ");
            builder.append("avatar=").append(this.avatar);
        }
        if (this.banner != null) {
            builder.append(", ");
            builder.append("banner=").append(this.banner);
        }
        if (this.joinedAt != null) {
            builder.append(", ");
            builder.append("joinedAt=").append(this.joinedAt);
        }
        builder.append(", ");
        builder.append("premiumSince=").append(this.premiumSince().toString());
        builder.append(", ");
        builder.append("pending=").append(this.pending().toString());
        builder.append(", ");
        builder.append("communicationDisabledUntil=").append(this.communicationDisabledUntil().toString());
        builder.append(", ");
        builder.append("avatarDecoration=").append(this.avatarDecoration().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildMemberUpdate fromJson(Json json) {
        Builder builder = ImmutableGuildMemberUpdate.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.roles != null) {
            builder.addAllRoles(json.roles);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.nick != null) {
            builder.nick(json.nick);
        }
        if (json.avatar != null) {
            builder.avatar(json.avatar);
        }
        if (json.banner != null) {
            builder.banner(json.banner);
        }
        if (json.joinedAt != null) {
            builder.joinedAt(json.joinedAt);
        }
        if (json.premiumSince != null) {
            builder.premiumSince(json.premiumSince);
        }
        if (json.pending != null) {
            builder.pending(json.pending);
        }
        if (json.communicationDisabledUntil != null) {
            builder.communicationDisabledUntil(json.communicationDisabledUntil);
        }
        if (json.avatarDecoration != null) {
            builder.avatarDecoration(json.avatarDecoration);
        }
        return builder.build();
    }

    public static ImmutableGuildMemberUpdate of(Id guildId, List<String> roles, UserData user, Possible<Optional<String>> nick, Optional<String> avatar, Optional<String> banner, Optional<String> joinedAt, Possible<Optional<String>> premiumSince, Possible<Boolean> pending, Possible<Optional<String>> communicationDisabledUntil, Possible<Optional<AvatarDecorationData>> avatarDecoration) {
        return ImmutableGuildMemberUpdate.of(guildId, roles, user, nick, avatar, banner, joinedAt, premiumSince, pending, communicationDisabledUntil, avatarDecoration);
    }

    public static ImmutableGuildMemberUpdate of(Id guildId, Iterable<String> roles, UserData user, Possible<Optional<String>> nick, Optional<String> avatar, Optional<String> banner, Optional<String> joinedAt, Possible<Optional<String>> premiumSince, Possible<Boolean> pending, Possible<Optional<String>> communicationDisabledUntil, Possible<Optional<AvatarDecorationData>> avatarDecoration) {
        return new ImmutableGuildMemberUpdate(guildId, roles, user, nick, avatar, banner, joinedAt, premiumSince, pending, communicationDisabledUntil, avatarDecoration);
    }

    public static ImmutableGuildMemberUpdate copyOf(GuildMemberUpdate instance) {
        if (instance instanceof ImmutableGuildMemberUpdate) {
            return (ImmutableGuildMemberUpdate)instance;
        }
        return ImmutableGuildMemberUpdate.builder().from(instance).build();
    }

    public boolean isNickPresent() {
        return !this.nick_absent;
    }

    public String nickOrElse(String defaultValue) {
        return !this.nick_absent ? this.nick_value : defaultValue;
    }

    public boolean isPremiumSincePresent() {
        return !this.premiumSince_absent;
    }

    public String premiumSinceOrElse(String defaultValue) {
        return !this.premiumSince_absent ? this.premiumSince_value : defaultValue;
    }

    public boolean isPendingPresent() {
        return !this.pending_absent;
    }

    public Boolean pendingOrElse(Boolean defaultValue) {
        return !this.pending_absent ? this.pending_value : defaultValue;
    }

    public boolean isCommunicationDisabledUntilPresent() {
        return !this.communicationDisabledUntil_absent;
    }

    public String communicationDisabledUntilOrElse(String defaultValue) {
        return !this.communicationDisabledUntil_absent ? this.communicationDisabledUntil_value : defaultValue;
    }

    public boolean isAvatarDecorationPresent() {
        return !this.avatarDecoration_absent;
    }

    public AvatarDecorationData avatarDecorationOrElse(AvatarDecorationData defaultValue) {
        return !this.avatarDecoration_absent ? this.avatarDecoration_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private long initBits = 1L;
        private Id guildId_id = null;
        private Possible<Optional<String>> nick_possible = Possible.absent();
        private Possible<Optional<String>> premiumSince_possible = Possible.absent();
        private Possible<Boolean> pending_possible = Possible.absent();
        private Possible<Optional<String>> communicationDisabledUntil_possible = Possible.absent();
        private Possible<Optional<AvatarDecorationData>> avatarDecoration_possible = Possible.absent();
        private List<String> roles = new ArrayList<String>();
        @Nullable
        private UserData user;
        @Nullable
        private String avatar;
        @Nullable
        private String banner;
        @Nullable
        private String joinedAt;

        private Builder() {
        }

        public final Builder from(GuildMemberUpdate instance) {
            Optional<String> joinedAtOptional;
            Optional<String> bannerOptional;
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.addAllRoles(instance.roles());
            this.user(instance.user());
            this.nick(instance.nick());
            Optional<String> avatarOptional = instance.avatar();
            if (avatarOptional.isPresent()) {
                this.avatar(avatarOptional);
            }
            if ((bannerOptional = instance.banner()).isPresent()) {
                this.banner(bannerOptional);
            }
            if ((joinedAtOptional = instance.joinedAt()).isPresent()) {
                this.joinedAt(joinedAtOptional);
            }
            this.premiumSince(instance.premiumSince());
            this.pending(instance.pending());
            this.communicationDisabledUntil(instance.communicationDisabledUntil());
            this.avatarDecoration(instance.avatarDecoration());
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        public final Builder addRole(String element) {
            this.roles.add(Objects.requireNonNull(element, "roles element"));
            return this;
        }

        public final Builder addRoles(String ... elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        @JsonProperty(value="roles")
        public final Builder roles(Iterable<String> elements) {
            this.roles.clear();
            return this.addAllRoles(elements);
        }

        public final Builder addAllRoles(Iterable<String> elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(UserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="nick")
        public Builder nick(Possible<Optional<String>> value) {
            this.nick_possible = value;
            return this;
        }

        @Deprecated
        public Builder nick(@Nullable String value) {
            this.nick_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder nickOrNull(@Nullable String value) {
            this.nick_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public final Builder avatar(String avatar) {
            this.avatar = Objects.requireNonNull(avatar, "avatar");
            return this;
        }

        @JsonProperty(value="avatar")
        public final Builder avatar(Optional<String> avatar) {
            this.avatar = avatar.orElse(null);
            return this;
        }

        public final Builder banner(String banner) {
            this.banner = Objects.requireNonNull(banner, "banner");
            return this;
        }

        @JsonProperty(value="banner")
        public final Builder banner(Optional<String> banner) {
            this.banner = banner.orElse(null);
            return this;
        }

        public final Builder joinedAt(String joinedAt) {
            this.joinedAt = Objects.requireNonNull(joinedAt, "joinedAt");
            return this;
        }

        @JsonProperty(value="joined_at")
        public final Builder joinedAt(Optional<String> joinedAt) {
            this.joinedAt = joinedAt.orElse(null);
            return this;
        }

        @JsonProperty(value="premium_since")
        public Builder premiumSince(Possible<Optional<String>> value) {
            this.premiumSince_possible = value;
            return this;
        }

        @Deprecated
        public Builder premiumSince(@Nullable String value) {
            this.premiumSince_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder premiumSinceOrNull(@Nullable String value) {
            this.premiumSince_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="pending")
        public Builder pending(Possible<Boolean> value) {
            this.pending_possible = value;
            return this;
        }

        public Builder pending(Boolean value) {
            this.pending_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="communication_disabled_until")
        public Builder communicationDisabledUntil(Possible<Optional<String>> value) {
            this.communicationDisabledUntil_possible = value;
            return this;
        }

        @Deprecated
        public Builder communicationDisabledUntil(@Nullable String value) {
            this.communicationDisabledUntil_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder communicationDisabledUntilOrNull(@Nullable String value) {
            this.communicationDisabledUntil_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="avatar_decoration_data")
        public Builder avatarDecoration(Possible<Optional<AvatarDecorationData>> value) {
            this.avatarDecoration_possible = value;
            return this;
        }

        @Deprecated
        public Builder avatarDecoration(@Nullable AvatarDecorationData value) {
            this.avatarDecoration_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder avatarDecorationOrNull(@Nullable AvatarDecorationData value) {
            this.avatarDecoration_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutableGuildMemberUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildMemberUpdate(null, this.guildId_build(), ImmutableGuildMemberUpdate.createUnmodifiableList(true, this.roles), this.user, this.nick_build(), this.avatar, this.banner, this.joinedAt, this.premiumSince_build(), this.pending_build(), this.communicationDisabledUntil_build(), this.avatarDecoration_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            return "Cannot build GuildMemberUpdate, some of required attributes are not set " + attributes;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }

        private Possible<Optional<String>> nick_build() {
            return this.nick_possible;
        }

        private Possible<Optional<String>> premiumSince_build() {
            return this.premiumSince_possible;
        }

        private Possible<Boolean> pending_build() {
            return this.pending_possible;
        }

        private Possible<Optional<String>> communicationDisabledUntil_build() {
            return this.communicationDisabledUntil_possible;
        }

        private Possible<Optional<AvatarDecorationData>> avatarDecoration_build() {
            return this.avatarDecoration_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GuildMemberUpdate {
        @Nullable
        Id guildId;
        @Nullable
        List<String> roles = Collections.emptyList();
        @Nullable
        UserData user;
        Possible<Optional<String>> nick = Possible.absent();
        @Nullable
        Optional<String> avatar = Optional.empty();
        @Nullable
        Optional<String> banner = Optional.empty();
        @Nullable
        Optional<String> joinedAt = Optional.empty();
        Possible<Optional<String>> premiumSince = Possible.absent();
        Possible<Boolean> pending = Possible.absent();
        Possible<Optional<String>> communicationDisabledUntil = Possible.absent();
        Possible<Optional<AvatarDecorationData>> avatarDecoration = Possible.absent();

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="user")
        public void setUser(UserData user) {
            this.user = user;
        }

        @JsonProperty(value="nick")
        public void setNick(Possible<Optional<String>> nick) {
            this.nick = nick;
        }

        @JsonProperty(value="avatar")
        public void setAvatar(Optional<String> avatar) {
            this.avatar = avatar;
        }

        @JsonProperty(value="banner")
        public void setBanner(Optional<String> banner) {
            this.banner = banner;
        }

        @JsonProperty(value="joined_at")
        public void setJoinedAt(Optional<String> joinedAt) {
            this.joinedAt = joinedAt;
        }

        @JsonProperty(value="premium_since")
        public void setPremiumSince(Possible<Optional<String>> premiumSince) {
            this.premiumSince = premiumSince;
        }

        @JsonProperty(value="pending")
        public void setPending(Possible<Boolean> pending) {
            this.pending = pending;
        }

        @JsonProperty(value="communication_disabled_until")
        public void setCommunicationDisabledUntil(Possible<Optional<String>> communicationDisabledUntil) {
            this.communicationDisabledUntil = communicationDisabledUntil;
        }

        @JsonProperty(value="avatar_decoration_data")
        public void setAvatarDecoration(Possible<Optional<AvatarDecorationData>> avatarDecoration) {
            this.avatarDecoration = avatarDecoration;
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserData user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> nick() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> avatar() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> banner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> joinedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> premiumSince() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> pending() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> communicationDisabledUntil() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<AvatarDecorationData>> avatarDecoration() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildMemberUpdate, attribute initializers form cycle " + attributes;
        }
    }
}

