/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.gateway.GuildBanAdd;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableGuildBanAdd
implements GuildBanAdd {
    private final long guildId_value;
    private final UserData user;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGuildBanAdd(Id guildId, UserData user) {
        Id guildId$impl = guildId;
        this.user = Objects.requireNonNull(user, "user");
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    private ImmutableGuildBanAdd(ImmutableGuildBanAdd original, Id guildId, UserData user) {
        Id guildId$impl = guildId;
        this.user = user;
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="user")
    public UserData user() {
        return this.user;
    }

    public ImmutableGuildBanAdd withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableGuildBanAdd(this, newValue, this.user);
    }

    public ImmutableGuildBanAdd withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableGuildBanAdd(this, newValue, this.user);
    }

    public final ImmutableGuildBanAdd withUser(UserData value) {
        if (this.user == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutableGuildBanAdd(this, this.guildId(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildBanAdd && this.equalTo(0, (ImmutableGuildBanAdd)another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildBanAdd another) {
        return Objects.equals(this.guildId_value, another.guildId_value) && this.user.equals(another.user);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + this.user.hashCode();
        return h;
    }

    public String toString() {
        return "GuildBanAdd{guildId=" + Objects.toString(this.guildId_value) + ", user=" + this.user + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildBanAdd fromJson(Json json) {
        Builder builder = ImmutableGuildBanAdd.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        return builder.build();
    }

    public static ImmutableGuildBanAdd of(Id guildId, UserData user) {
        return new ImmutableGuildBanAdd(guildId, user);
    }

    public static ImmutableGuildBanAdd copyOf(GuildBanAdd instance) {
        if (instance instanceof ImmutableGuildBanAdd) {
            return (ImmutableGuildBanAdd)instance;
        }
        return ImmutableGuildBanAdd.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private long initBits = 1L;
        private Id guildId_id = null;
        @Nullable
        private UserData user;

        private Builder() {
        }

        public final Builder from(GuildBanAdd instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.user(instance.user());
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(UserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGuildBanAdd build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildBanAdd(null, this.guildId_build(), this.user);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            return "Cannot build GuildBanAdd, some of required attributes are not set " + attributes;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GuildBanAdd {
        @Nullable
        Id guildId;
        @Nullable
        UserData user;

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="user")
        public void setUser(UserData user) {
            this.user = user;
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserData user() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildBanAdd, attribute initializers form cycle " + attributes;
        }
    }
}

