/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.AttachmentData;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.PollCreateData;
import discord4j.discordjson.json.WebhookMessageEditRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableWebhookMessageEditRequest
implements WebhookMessageEditRequest {
    private final String content_value;
    private final boolean content_absent;
    private final List<EmbedData> embeds_value;
    private final boolean embeds_absent;
    private final AllowedMentionsData allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<AttachmentData> attachments_value;
    private final boolean attachments_absent;
    private final List<ComponentData> components_value;
    private final boolean components_absent;
    private final PollCreateData poll_value;
    private final boolean poll_absent;
    private final Integer flags_value;
    private final boolean flags_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableWebhookMessageEditRequest(Possible<Optional<String>> content, Possible<Optional<List<EmbedData>>> embeds, Possible<Optional<AllowedMentionsData>> allowedMentions, Possible<Optional<List<AttachmentData>>> attachments, Possible<List<ComponentData>> components, Possible<PollCreateData> poll, Possible<Optional<Integer>> flags) {
        Possible<Optional<String>> content$impl = content;
        Possible<Optional<List<EmbedData>>> embeds$impl = embeds;
        Possible<Optional<AllowedMentionsData>> allowedMentions$impl = allowedMentions;
        Possible<Optional<List<AttachmentData>>> attachments$impl = attachments;
        Possible<List<ComponentData>> components$impl = components;
        Possible<PollCreateData> poll$impl = poll;
        Possible<Optional<Integer>> flags$impl = flags;
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.attachments_value = Possible.flatOpt(attachments$impl).orElse(null);
        this.attachments_absent = attachments$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.flags_value = Possible.flatOpt(flags$impl).orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableWebhookMessageEditRequest(ImmutableWebhookMessageEditRequest original, Possible<Optional<String>> content, Possible<Optional<List<EmbedData>>> embeds, Possible<Optional<AllowedMentionsData>> allowedMentions, Possible<Optional<List<AttachmentData>>> attachments, Possible<List<ComponentData>> components, Possible<PollCreateData> poll, Possible<Optional<Integer>> flags) {
        Possible<Optional<String>> content$impl = content;
        Possible<Optional<List<EmbedData>>> embeds$impl = embeds;
        Possible<Optional<AllowedMentionsData>> allowedMentions$impl = allowedMentions;
        Possible<Optional<List<AttachmentData>>> attachments$impl = attachments;
        Possible<List<ComponentData>> components$impl = components;
        Possible<PollCreateData> poll$impl = poll;
        Possible<Optional<Integer>> flags$impl = flags;
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.attachments_value = Possible.flatOpt(attachments$impl).orElse(null);
        this.attachments_absent = attachments$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.flags_value = Possible.flatOpt(flags$impl).orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="content")
    public Possible<Optional<String>> content() {
        return this.content_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.content_value));
    }

    @Override
    @JsonProperty(value="embeds")
    public Possible<Optional<List<EmbedData>>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.embeds_value));
    }

    @Override
    @JsonProperty(value="allowed_mentions")
    public Possible<Optional<AllowedMentionsData>> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.allowedMentions_value));
    }

    @Override
    @JsonProperty(value="attachments")
    public Possible<Optional<List<AttachmentData>>> attachments() {
        return this.attachments_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.attachments_value));
    }

    @Override
    @JsonProperty(value="components")
    public Possible<List<ComponentData>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    @Override
    @JsonProperty(value="poll")
    public Possible<PollCreateData> poll() {
        return this.poll_absent ? Possible.absent() : Possible.of((Object)this.poll_value);
    }

    @Override
    @JsonProperty(value="flags")
    public Possible<Optional<Integer>> flags() {
        return this.flags_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.flags_value));
    }

    public ImmutableWebhookMessageEditRequest withContent(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookMessageEditRequest(this, newValue, this.embeds(), this.allowedMentions(), this.attachments(), this.components(), this.poll(), this.flags());
    }

    @Deprecated
    public ImmutableWebhookMessageEditRequest withContent(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookMessageEditRequest(this, (Possible<Optional<String>>)newValue, this.embeds(), this.allowedMentions(), this.attachments(), this.components(), this.poll(), this.flags());
    }

    public ImmutableWebhookMessageEditRequest withContentOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookMessageEditRequest(this, (Possible<Optional<String>>)newValue, this.embeds(), this.allowedMentions(), this.attachments(), this.components(), this.poll(), this.flags());
    }

    public ImmutableWebhookMessageEditRequest withEmbeds(Possible<Optional<List<EmbedData>>> possible) {
        Possible<Optional<List<EmbedData>>> newValue = Objects.requireNonNull(possible);
        return new ImmutableWebhookMessageEditRequest(this, this.content(), newValue, this.allowedMentions(), this.attachments(), this.components(), this.poll(), this.flags());
    }

    @Deprecated
    public ImmutableWebhookMessageEditRequest withEmbeds(@Nullable Iterable<EmbedData> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), (Possible<Optional<List<EmbedData>>>)newValue, this.allowedMentions(), this.attachments(), this.components(), this.poll(), this.flags());
    }

    public ImmutableWebhookMessageEditRequest withEmbedsOrNull(@Nullable Iterable<EmbedData> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), (Possible<Optional<List<EmbedData>>>)newValue, this.allowedMentions(), this.attachments(), this.components(), this.poll(), this.flags());
    }

    @SafeVarargs
    public final ImmutableWebhookMessageEditRequest withEmbeds(EmbedData ... elements) {
        Possible newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), (Possible<Optional<List<EmbedData>>>)newValue, this.allowedMentions(), this.attachments(), this.components(), this.poll(), this.flags());
    }

    public ImmutableWebhookMessageEditRequest withAllowedMentions(Possible<Optional<AllowedMentionsData>> value) {
        Possible<Optional<AllowedMentionsData>> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), newValue, this.attachments(), this.components(), this.poll(), this.flags());
    }

    @Deprecated
    public ImmutableWebhookMessageEditRequest withAllowedMentions(@Nullable AllowedMentionsData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), (Possible<Optional<AllowedMentionsData>>)newValue, this.attachments(), this.components(), this.poll(), this.flags());
    }

    public ImmutableWebhookMessageEditRequest withAllowedMentionsOrNull(@Nullable AllowedMentionsData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), (Possible<Optional<AllowedMentionsData>>)newValue, this.attachments(), this.components(), this.poll(), this.flags());
    }

    public ImmutableWebhookMessageEditRequest withAttachments(Possible<Optional<List<AttachmentData>>> possible) {
        Possible<Optional<List<AttachmentData>>> newValue = Objects.requireNonNull(possible);
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), newValue, this.components(), this.poll(), this.flags());
    }

    @Deprecated
    public ImmutableWebhookMessageEditRequest withAttachments(@Nullable Iterable<AttachmentData> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), (Possible<Optional<List<AttachmentData>>>)newValue, this.components(), this.poll(), this.flags());
    }

    public ImmutableWebhookMessageEditRequest withAttachmentsOrNull(@Nullable Iterable<AttachmentData> elements) {
        Possible newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), (Possible<Optional<List<AttachmentData>>>)newValue, this.components(), this.poll(), this.flags());
    }

    @SafeVarargs
    public final ImmutableWebhookMessageEditRequest withAttachments(AttachmentData ... elements) {
        Possible newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), (Possible<Optional<List<AttachmentData>>>)newValue, this.components(), this.poll(), this.flags());
    }

    public ImmutableWebhookMessageEditRequest withComponents(Possible<List<ComponentData>> possible) {
        Possible<List<ComponentData>> newValue = Objects.requireNonNull(possible);
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), this.attachments(), newValue, this.poll(), this.flags());
    }

    public ImmutableWebhookMessageEditRequest withComponents(Iterable<ComponentData> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), this.attachments(), (Possible<List<ComponentData>>)newValue, this.poll(), this.flags());
    }

    @SafeVarargs
    public final ImmutableWebhookMessageEditRequest withComponents(ComponentData ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), this.attachments(), (Possible<List<ComponentData>>)newValue, this.poll(), this.flags());
    }

    public ImmutableWebhookMessageEditRequest withPoll(Possible<PollCreateData> value) {
        Possible<PollCreateData> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), this.attachments(), this.components(), newValue, this.flags());
    }

    public ImmutableWebhookMessageEditRequest withPoll(PollCreateData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), this.attachments(), this.components(), (Possible<PollCreateData>)newValue, this.flags());
    }

    public ImmutableWebhookMessageEditRequest withFlags(Possible<Optional<Integer>> value) {
        Possible<Optional<Integer>> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), this.attachments(), this.components(), this.poll(), newValue);
    }

    @Deprecated
    public ImmutableWebhookMessageEditRequest withFlags(@Nullable Integer value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), this.attachments(), this.components(), this.poll(), (Possible<Optional<Integer>>)newValue);
    }

    public ImmutableWebhookMessageEditRequest withFlagsOrNull(@Nullable Integer value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), this.attachments(), this.components(), this.poll(), (Possible<Optional<Integer>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookMessageEditRequest && this.equalTo(0, (ImmutableWebhookMessageEditRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebhookMessageEditRequest another) {
        return this.content().equals(another.content()) && Objects.equals(this.embeds_value, another.embeds_value) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.attachments_value, another.attachments_value) && Objects.equals(this.components_value, another.components_value) && this.poll().equals(another.poll()) && this.flags().equals(another.flags());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + Objects.hashCode(this.embeds_value);
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + Objects.hashCode(this.attachments_value);
        h += (h << 5) + Objects.hashCode(this.components_value);
        h += (h << 5) + this.poll().hashCode();
        h += (h << 5) + this.flags().hashCode();
        return h;
    }

    public String toString() {
        return "WebhookMessageEditRequest{content=" + this.content().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", allowedMentions=" + this.allowedMentions().toString() + ", attachments=" + Objects.toString(this.attachments_value) + ", components=" + Objects.toString(this.components_value) + ", poll=" + this.poll().toString() + ", flags=" + this.flags().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWebhookMessageEditRequest fromJson(Json json) {
        Builder builder = ImmutableWebhookMessageEditRequest.builder();
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.embeds != null) {
            builder.embeds(json.embeds);
        }
        if (json.allowedMentions != null) {
            builder.allowedMentions(json.allowedMentions);
        }
        if (json.attachments != null) {
            builder.attachments(json.attachments);
        }
        if (json.components != null) {
            builder.components(json.components);
        }
        if (json.poll != null) {
            builder.poll(json.poll);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        return builder.build();
    }

    public static ImmutableWebhookMessageEditRequest of(Possible<Optional<String>> content, Possible<Optional<List<EmbedData>>> embeds, Possible<Optional<AllowedMentionsData>> allowedMentions, Possible<Optional<List<AttachmentData>>> attachments, Possible<List<ComponentData>> components, Possible<PollCreateData> poll, Possible<Optional<Integer>> flags) {
        return new ImmutableWebhookMessageEditRequest(content, embeds, allowedMentions, attachments, components, poll, flags);
    }

    public static ImmutableWebhookMessageEditRequest copyOf(WebhookMessageEditRequest instance) {
        if (instance instanceof ImmutableWebhookMessageEditRequest) {
            return (ImmutableWebhookMessageEditRequest)instance;
        }
        return ImmutableWebhookMessageEditRequest.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedData> embedsOrElse(List<EmbedData> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentionsData allowedMentionsOrElse(AllowedMentionsData defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isAttachmentsPresent() {
        return !this.attachments_absent;
    }

    public List<AttachmentData> attachmentsOrElse(List<AttachmentData> defaultValue) {
        return !this.attachments_absent ? this.attachments_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<ComponentData> componentsOrElse(List<ComponentData> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public boolean isPollPresent() {
        return !this.poll_absent;
    }

    public PollCreateData pollOrElse(PollCreateData defaultValue) {
        return !this.poll_absent ? this.poll_value : defaultValue;
    }

    public boolean isFlagsPresent() {
        return !this.flags_absent;
    }

    public Integer flagsOrElse(Integer defaultValue) {
        return !this.flags_absent ? this.flags_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<Optional<String>> content_possible = Possible.absent();
        private List<EmbedData> embeds_list = null;
        private boolean embeds_explicitNull;
        private Possible<Optional<AllowedMentionsData>> allowedMentions_possible = Possible.absent();
        private List<AttachmentData> attachments_list = null;
        private boolean attachments_explicitNull;
        private List<ComponentData> components_list = null;
        private Possible<PollCreateData> poll_possible = Possible.absent();
        private Possible<Optional<Integer>> flags_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(WebhookMessageEditRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.embeds(instance.embeds());
            this.allowedMentions(instance.allowedMentions());
            this.attachments(instance.attachments());
            this.components(instance.components());
            this.poll(instance.poll());
            this.flags(instance.flags());
            return this;
        }

        @JsonProperty(value="content")
        public Builder content(Possible<Optional<String>> value) {
            this.content_possible = value;
            return this;
        }

        @Deprecated
        public Builder content(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder contentOrNull(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder addEmbed(EmbedData element) {
            this.embeds_getOrCreate().add(element);
            this.embeds_explicitNull = false;
            return this;
        }

        public Builder addAllEmbeds(List<EmbedData> elements) {
            this.embeds_getOrCreate().addAll(elements);
            this.embeds_explicitNull = false;
            return this;
        }

        @JsonProperty(value="embeds")
        public Builder embeds(Possible<Optional<List<EmbedData>>> elements) {
            this.embeds_list = null;
            this.embeds_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.embeds_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.embeds_explicitNull = true;
                }
            });
            return this;
        }

        public Builder embeds(List<EmbedData> elements) {
            this.embeds_list = new ArrayList<EmbedData>(elements);
            this.embeds_explicitNull = false;
            return this;
        }

        @Deprecated
        public Builder embeds(@Nullable Iterable<EmbedData> elements) {
            if (elements == null) {
                this.embeds_list = null;
                this.embeds_explicitNull = true;
            } else {
                this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.embeds_explicitNull = false;
            }
            return this;
        }

        public Builder embedsOrNull(@Nullable Iterable<EmbedData> elements) {
            if (elements == null) {
                this.embeds_list = null;
                this.embeds_explicitNull = true;
            } else {
                this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.embeds_explicitNull = false;
            }
            return this;
        }

        @JsonProperty(value="allowed_mentions")
        public Builder allowedMentions(Possible<Optional<AllowedMentionsData>> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        @Deprecated
        public Builder allowedMentions(@Nullable AllowedMentionsData value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder allowedMentionsOrNull(@Nullable AllowedMentionsData value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder addAttachment(AttachmentData element) {
            this.attachments_getOrCreate().add(element);
            this.attachments_explicitNull = false;
            return this;
        }

        public Builder addAllAttachments(List<AttachmentData> elements) {
            this.attachments_getOrCreate().addAll(elements);
            this.attachments_explicitNull = false;
            return this;
        }

        @JsonProperty(value="attachments")
        public Builder attachments(Possible<Optional<List<AttachmentData>>> elements) {
            this.attachments_list = null;
            this.attachments_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.attachments_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.attachments_explicitNull = true;
                }
            });
            return this;
        }

        public Builder attachments(List<AttachmentData> elements) {
            this.attachments_list = new ArrayList<AttachmentData>(elements);
            this.attachments_explicitNull = false;
            return this;
        }

        @Deprecated
        public Builder attachments(@Nullable Iterable<AttachmentData> elements) {
            if (elements == null) {
                this.attachments_list = null;
                this.attachments_explicitNull = true;
            } else {
                this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.attachments_explicitNull = false;
            }
            return this;
        }

        public Builder attachmentsOrNull(@Nullable Iterable<AttachmentData> elements) {
            if (elements == null) {
                this.attachments_list = null;
                this.attachments_explicitNull = true;
            } else {
                this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.attachments_explicitNull = false;
            }
            return this;
        }

        public Builder addComponent(ComponentData element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        public Builder addAllComponents(List<ComponentData> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="components")
        public Builder components(Possible<List<ComponentData>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<ComponentData>)e));
            return this;
        }

        public Builder components(List<ComponentData> elements) {
            this.components_list = new ArrayList<ComponentData>(elements);
            return this;
        }

        public Builder components(Iterable<ComponentData> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="poll")
        public Builder poll(Possible<PollCreateData> value) {
            this.poll_possible = value;
            return this;
        }

        public Builder poll(PollCreateData value) {
            this.poll_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="flags")
        public Builder flags(Possible<Optional<Integer>> value) {
            this.flags_possible = value;
            return this;
        }

        @Deprecated
        public Builder flags(@Nullable Integer value) {
            this.flags_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder flagsOrNull(@Nullable Integer value) {
            this.flags_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutableWebhookMessageEditRequest build() {
            return new ImmutableWebhookMessageEditRequest(null, this.content_build(), this.embeds_build(), this.allowedMentions_build(), this.attachments_build(), this.components_build(), this.poll_build(), this.flags_build());
        }

        private Possible<Optional<String>> content_build() {
            return this.content_possible;
        }

        private Possible<Optional<List<EmbedData>>> embeds_build() {
            return this.embeds_list == null && !this.embeds_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.embeds_list));
        }

        private List<EmbedData> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedData>();
            }
            return this.embeds_list;
        }

        private Possible<Optional<AllowedMentionsData>> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<Optional<List<AttachmentData>>> attachments_build() {
            return this.attachments_list == null && !this.attachments_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.attachments_list));
        }

        private List<AttachmentData> attachments_getOrCreate() {
            if (this.attachments_list == null) {
                this.attachments_list = new ArrayList<AttachmentData>();
            }
            return this.attachments_list;
        }

        private Possible<List<ComponentData>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<ComponentData> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<ComponentData>();
            }
            return this.components_list;
        }

        private Possible<PollCreateData> poll_build() {
            return this.poll_possible;
        }

        private Possible<Optional<Integer>> flags_build() {
            return this.flags_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements WebhookMessageEditRequest {
        Possible<Optional<String>> content = Possible.absent();
        Possible<Optional<List<EmbedData>>> embeds = Possible.absent();
        Possible<Optional<AllowedMentionsData>> allowedMentions = Possible.absent();
        Possible<Optional<List<AttachmentData>>> attachments = Possible.absent();
        Possible<List<ComponentData>> components = Possible.absent();
        Possible<PollCreateData> poll = Possible.absent();
        Possible<Optional<Integer>> flags = Possible.absent();

        Json() {
        }

        @JsonProperty(value="content")
        public void setContent(Possible<Optional<String>> content) {
            this.content = content;
        }

        @JsonProperty(value="embeds")
        public void setEmbeds(Possible<Optional<List<EmbedData>>> embeds) {
            this.embeds = embeds;
        }

        @JsonProperty(value="allowed_mentions")
        public void setAllowedMentions(Possible<Optional<AllowedMentionsData>> allowedMentions) {
            this.allowedMentions = allowedMentions;
        }

        @JsonProperty(value="attachments")
        public void setAttachments(Possible<Optional<List<AttachmentData>>> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty(value="components")
        public void setComponents(Possible<List<ComponentData>> components) {
            this.components = components;
        }

        @JsonProperty(value="poll")
        public void setPoll(Possible<PollCreateData> poll) {
            this.poll = poll;
        }

        @JsonProperty(value="flags")
        public void setFlags(Possible<Optional<Integer>> flags) {
            this.flags = flags;
        }

        @Override
        public Possible<Optional<String>> content() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<List<EmbedData>>> embeds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<AllowedMentionsData>> allowedMentions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<List<AttachmentData>>> attachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<ComponentData>> components() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<PollCreateData> poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<Integer>> flags() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build WebhookMessageEditRequest, attribute initializers form cycle " + attributes;
        }
    }
}

