/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import discord4j.discordjson.json.TokenRevokeRequest;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableTokenRevokeRequest
extends TokenRevokeRequest {
    private final long clientId;
    private final String clientSecret;
    private final String token;

    private ImmutableTokenRevokeRequest(long clientId, String clientSecret, String token) {
        this.clientId = clientId;
        this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
        this.token = Objects.requireNonNull(token, "token");
    }

    private ImmutableTokenRevokeRequest(ImmutableTokenRevokeRequest original, long clientId, String clientSecret, String token) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.token = token;
    }

    @Override
    public long clientId() {
        return this.clientId;
    }

    @Override
    public String clientSecret() {
        return this.clientSecret;
    }

    @Override
    public String token() {
        return this.token;
    }

    public final ImmutableTokenRevokeRequest withClientId(long value) {
        if (this.clientId == value) {
            return this;
        }
        return new ImmutableTokenRevokeRequest(this, value, this.clientSecret, this.token);
    }

    public final ImmutableTokenRevokeRequest withClientSecret(String value) {
        String newValue = Objects.requireNonNull(value, "clientSecret");
        if (this.clientSecret.equals(newValue)) {
            return this;
        }
        return new ImmutableTokenRevokeRequest(this, this.clientId, newValue, this.token);
    }

    public final ImmutableTokenRevokeRequest withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new ImmutableTokenRevokeRequest(this, this.clientId, this.clientSecret, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokenRevokeRequest && this.equalTo(0, (ImmutableTokenRevokeRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableTokenRevokeRequest another) {
        return this.clientId == another.clientId && this.clientSecret.equals(another.clientSecret) && this.token.equals(another.token);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.clientId);
        h += (h << 5) + this.clientSecret.hashCode();
        h += (h << 5) + this.token.hashCode();
        return h;
    }

    public static ImmutableTokenRevokeRequest of(long clientId, String clientSecret, String token) {
        return new ImmutableTokenRevokeRequest(clientId, clientSecret, token);
    }

    public static ImmutableTokenRevokeRequest copyOf(TokenRevokeRequest instance) {
        if (instance instanceof ImmutableTokenRevokeRequest) {
            return (ImmutableTokenRevokeRequest)instance;
        }
        return ImmutableTokenRevokeRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_CLIENT_SECRET = 2L;
        private static final long INIT_BIT_TOKEN = 4L;
        private long initBits = 7L;
        private long clientId;
        @Nullable
        private String clientSecret;
        @Nullable
        private String token;

        private Builder() {
        }

        public final Builder from(TokenRevokeRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.clientId());
            this.clientSecret(instance.clientSecret());
            this.token(instance.token());
            return this;
        }

        public final Builder clientId(long clientId) {
            this.clientId = clientId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTokenRevokeRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTokenRevokeRequest(null, this.clientId, this.clientSecret, this.token);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("clientSecret");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("token");
            }
            return "Cannot build TokenRevokeRequest, some of required attributes are not set " + attributes;
        }
    }
}

