/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.SoundboardSoundCreateRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableSoundboardSoundCreateRequest
implements SoundboardSoundCreateRequest {
    private final String name;
    private final String sound;
    private final Double volume_value;
    private final boolean volume_absent;
    private final long emojiId_value;
    private final boolean emojiId_absent;
    private final boolean emojiId_isNull;
    private final String emojiName_value;
    private final boolean emojiName_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSoundboardSoundCreateRequest(String name, String sound, Possible<Optional<Double>> volume, Possible<Optional<Id>> emojiId, Possible<Optional<String>> emojiName) {
        this.name = Objects.requireNonNull(name, "name");
        this.sound = Objects.requireNonNull(sound, "sound");
        Possible<Optional<Double>> volume$impl = volume;
        Possible<Optional<Id>> emojiId$impl = emojiId;
        Possible<Optional<String>> emojiName$impl = emojiName;
        this.volume_value = Possible.flatOpt(volume$impl).orElse(null);
        this.volume_absent = volume$impl.isAbsent();
        this.emojiId_value = Possible.flatOpt(emojiId$impl).map(Id::asLong).orElse(0L);
        this.emojiId_absent = emojiId$impl.isAbsent();
        this.emojiId_isNull = !emojiId$impl.isAbsent() && !((Optional)emojiId$impl.get()).isPresent();
        this.emojiName_value = Possible.flatOpt(emojiName$impl).orElse(null);
        this.emojiName_absent = emojiName$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableSoundboardSoundCreateRequest(ImmutableSoundboardSoundCreateRequest original, String name, String sound, Possible<Optional<Double>> volume, Possible<Optional<Id>> emojiId, Possible<Optional<String>> emojiName) {
        this.name = name;
        this.sound = sound;
        Possible<Optional<Double>> volume$impl = volume;
        Possible<Optional<Id>> emojiId$impl = emojiId;
        Possible<Optional<String>> emojiName$impl = emojiName;
        this.volume_value = Possible.flatOpt(volume$impl).orElse(null);
        this.volume_absent = volume$impl.isAbsent();
        this.emojiId_value = Possible.flatOpt(emojiId$impl).map(Id::asLong).orElse(0L);
        this.emojiId_absent = emojiId$impl.isAbsent();
        this.emojiId_isNull = !emojiId$impl.isAbsent() && !((Optional)emojiId$impl.get()).isPresent();
        this.emojiName_value = Possible.flatOpt(emojiName$impl).orElse(null);
        this.emojiName_absent = emojiName$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="sound")
    public String sound() {
        return this.sound;
    }

    @Override
    @JsonProperty(value="volume")
    public Possible<Optional<Double>> volume() {
        return this.volume_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.volume_value));
    }

    @Override
    @JsonProperty(value="emoji_id")
    public Possible<Optional<Id>> emojiId() {
        if (this.emojiId_absent) {
            return Possible.absent();
        }
        if (this.emojiId_isNull) {
            return Possible.of(Optional.empty());
        }
        return Possible.of(Optional.of(Id.of((long)this.emojiId_value)));
    }

    @Override
    @JsonProperty(value="emoji_name")
    public Possible<Optional<String>> emojiName() {
        return this.emojiName_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.emojiName_value));
    }

    public final ImmutableSoundboardSoundCreateRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableSoundboardSoundCreateRequest(this, newValue, this.sound, this.volume(), this.emojiId(), this.emojiName());
    }

    public final ImmutableSoundboardSoundCreateRequest withSound(String value) {
        String newValue = Objects.requireNonNull(value, "sound");
        if (this.sound.equals(newValue)) {
            return this;
        }
        return new ImmutableSoundboardSoundCreateRequest(this, this.name, newValue, this.volume(), this.emojiId(), this.emojiName());
    }

    public ImmutableSoundboardSoundCreateRequest withVolume(Possible<Optional<Double>> value) {
        Possible<Optional<Double>> newValue = Objects.requireNonNull(value);
        return new ImmutableSoundboardSoundCreateRequest(this, this.name, this.sound, newValue, this.emojiId(), this.emojiName());
    }

    @Deprecated
    public ImmutableSoundboardSoundCreateRequest withVolume(@Nullable Double value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableSoundboardSoundCreateRequest(this, this.name, this.sound, (Possible<Optional<Double>>)newValue, this.emojiId(), this.emojiName());
    }

    public ImmutableSoundboardSoundCreateRequest withVolumeOrNull(@Nullable Double value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableSoundboardSoundCreateRequest(this, this.name, this.sound, (Possible<Optional<Double>>)newValue, this.emojiId(), this.emojiName());
    }

    public ImmutableSoundboardSoundCreateRequest withEmojiId(Possible<Optional<Id>> value) {
        Possible<Optional<Id>> newValue = Objects.requireNonNull(value);
        return new ImmutableSoundboardSoundCreateRequest(this, this.name, this.sound, this.volume(), newValue, this.emojiName());
    }

    @Deprecated
    public ImmutableSoundboardSoundCreateRequest withEmojiId(@Nullable Long value) {
        Possible newValue = value == null ? Possible.of(Optional.empty()) : Possible.of(Optional.of(Id.of((long)value)));
        return new ImmutableSoundboardSoundCreateRequest(this, this.name, this.sound, this.volume(), (Possible<Optional<Id>>)newValue, this.emojiName());
    }

    public ImmutableSoundboardSoundCreateRequest withEmojiIdOrNull(@Nullable Long value) {
        Possible newValue = value == null ? Possible.of(Optional.empty()) : Possible.of(Optional.of(Id.of((long)value)));
        return new ImmutableSoundboardSoundCreateRequest(this, this.name, this.sound, this.volume(), (Possible<Optional<Id>>)newValue, this.emojiName());
    }

    public ImmutableSoundboardSoundCreateRequest withEmojiName(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableSoundboardSoundCreateRequest(this, this.name, this.sound, this.volume(), this.emojiId(), newValue);
    }

    @Deprecated
    public ImmutableSoundboardSoundCreateRequest withEmojiName(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableSoundboardSoundCreateRequest(this, this.name, this.sound, this.volume(), this.emojiId(), (Possible<Optional<String>>)newValue);
    }

    public ImmutableSoundboardSoundCreateRequest withEmojiNameOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableSoundboardSoundCreateRequest(this, this.name, this.sound, this.volume(), this.emojiId(), (Possible<Optional<String>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSoundboardSoundCreateRequest && this.equalTo(0, (ImmutableSoundboardSoundCreateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableSoundboardSoundCreateRequest another) {
        return this.name.equals(another.name) && this.sound.equals(another.sound) && this.volume().equals(another.volume()) && this.emojiId().equals(another.emojiId()) && this.emojiName().equals(another.emojiName());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.sound.hashCode();
        h += (h << 5) + this.volume().hashCode();
        h += (h << 5) + this.emojiId().hashCode();
        h += (h << 5) + this.emojiName().hashCode();
        return h;
    }

    public String toString() {
        return "SoundboardSoundCreateRequest{name=" + this.name + ", sound=" + this.sound + ", volume=" + this.volume().toString() + ", emojiId=" + this.emojiId().toString() + ", emojiName=" + this.emojiName().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSoundboardSoundCreateRequest fromJson(Json json) {
        Builder builder = ImmutableSoundboardSoundCreateRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.sound != null) {
            builder.sound(json.sound);
        }
        if (json.volume != null) {
            builder.volume(json.volume);
        }
        if (json.emojiId != null) {
            builder.emojiId(json.emojiId);
        }
        if (json.emojiName != null) {
            builder.emojiName(json.emojiName);
        }
        return builder.build();
    }

    public static ImmutableSoundboardSoundCreateRequest of(String name, String sound, Possible<Optional<Double>> volume, Possible<Optional<Id>> emojiId, Possible<Optional<String>> emojiName) {
        return new ImmutableSoundboardSoundCreateRequest(name, sound, volume, emojiId, emojiName);
    }

    public static ImmutableSoundboardSoundCreateRequest copyOf(SoundboardSoundCreateRequest instance) {
        if (instance instanceof ImmutableSoundboardSoundCreateRequest) {
            return (ImmutableSoundboardSoundCreateRequest)instance;
        }
        return ImmutableSoundboardSoundCreateRequest.builder().from(instance).build();
    }

    public boolean isVolumePresent() {
        return !this.volume_absent;
    }

    public Double volumeOrElse(Double defaultValue) {
        return !this.volume_absent ? this.volume_value : defaultValue;
    }

    public boolean isEmojiIdPresent() {
        return !this.emojiId_absent;
    }

    public long emojiIdOrElse(long defaultValue) {
        return !this.emojiId_absent ? this.emojiId_value : defaultValue;
    }

    public boolean isEmojiNamePresent() {
        return !this.emojiName_absent;
    }

    public String emojiNameOrElse(String defaultValue) {
        return !this.emojiName_absent ? this.emojiName_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SOUND = 2L;
        private long initBits = 3L;
        private Possible<Optional<Double>> volume_possible = Possible.absent();
        private Possible<Optional<Id>> emojiId_possible = Possible.absent();
        private Possible<Optional<String>> emojiName_possible = Possible.absent();
        @Nullable
        private String name;
        @Nullable
        private String sound;

        private Builder() {
        }

        public final Builder from(SoundboardSoundCreateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.sound(instance.sound());
            this.volume(instance.volume());
            this.emojiId(instance.emojiId());
            this.emojiName(instance.emojiName());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="sound")
        public final Builder sound(String sound) {
            this.sound = Objects.requireNonNull(sound, "sound");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="volume")
        public Builder volume(Possible<Optional<Double>> value) {
            this.volume_possible = value;
            return this;
        }

        @Deprecated
        public Builder volume(@Nullable Double value) {
            this.volume_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder volumeOrNull(@Nullable Double value) {
            this.volume_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder emojiId(String value) {
            this.emojiId_possible = Possible.of(Optional.of(Id.of((String)value)));
            return this;
        }

        public Builder emojiId(long value) {
            this.emojiId_possible = Possible.of(Optional.of(Id.of((long)value)));
            return this;
        }

        public Builder emojiId(Id value) {
            this.emojiId_possible = Possible.of(Optional.of(value));
            return this;
        }

        @JsonProperty(value="emoji_id")
        public Builder emojiId(Possible<Optional<Id>> value) {
            this.emojiId_possible = value;
            return this;
        }

        @JsonProperty(value="emoji_name")
        public Builder emojiName(Possible<Optional<String>> value) {
            this.emojiName_possible = value;
            return this;
        }

        @Deprecated
        public Builder emojiName(@Nullable String value) {
            this.emojiName_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder emojiNameOrNull(@Nullable String value) {
            this.emojiName_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutableSoundboardSoundCreateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSoundboardSoundCreateRequest(null, this.name, this.sound, this.volume_build(), this.emojiId_build(), this.emojiName_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sound");
            }
            return "Cannot build SoundboardSoundCreateRequest, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<Double>> volume_build() {
            return this.volume_possible;
        }

        private Possible<Optional<Id>> emojiId_build() {
            return this.emojiId_possible;
        }

        private Possible<Optional<String>> emojiName_build() {
            return this.emojiName_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SoundboardSoundCreateRequest {
        @Nullable
        String name;
        @Nullable
        String sound;
        Possible<Optional<Double>> volume = Possible.absent();
        Possible<Optional<Id>> emojiId = Possible.absent();
        Possible<Optional<String>> emojiName = Possible.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="sound")
        public void setSound(String sound) {
            this.sound = sound;
        }

        @JsonProperty(value="volume")
        public void setVolume(Possible<Optional<Double>> volume) {
            this.volume = volume;
        }

        @JsonProperty(value="emoji_id")
        public void setEmojiId(Possible<Optional<Id>> emojiId) {
            this.emojiId = emojiId;
        }

        @JsonProperty(value="emoji_name")
        public void setEmojiName(Possible<Optional<String>> emojiName) {
            this.emojiName = emojiName;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sound() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<Double>> volume() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<Id>> emojiId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> emojiName() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SoundboardSoundCreateRequest, attribute initializers form cycle " + attributes;
        }
    }
}

