/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.SendSoundboardSoundRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableSendSoundboardSoundRequest
implements SendSoundboardSoundRequest {
    private final long soundId_value;
    private final long sourceGuildId_value;
    private final boolean sourceGuildId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSendSoundboardSoundRequest(Id soundId, Possible<Id> sourceGuildId) {
        Id soundId$impl = soundId;
        Possible<Id> sourceGuildId$impl = sourceGuildId;
        this.soundId_value = soundId$impl.asLong();
        this.sourceGuildId_value = sourceGuildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.sourceGuildId_absent = sourceGuildId$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableSendSoundboardSoundRequest(ImmutableSendSoundboardSoundRequest original, Id soundId, Possible<Id> sourceGuildId) {
        Id soundId$impl = soundId;
        Possible<Id> sourceGuildId$impl = sourceGuildId;
        this.soundId_value = soundId$impl.asLong();
        this.sourceGuildId_value = sourceGuildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.sourceGuildId_absent = sourceGuildId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="sound_id")
    public Id soundId() {
        return Id.of((long)this.soundId_value);
    }

    @Override
    @JsonProperty(value="source_guild_id")
    public Possible<Id> sourceGuildId() {
        return this.sourceGuildId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.sourceGuildId_value));
    }

    public ImmutableSendSoundboardSoundRequest withSoundId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableSendSoundboardSoundRequest(this, newValue, this.sourceGuildId());
    }

    public ImmutableSendSoundboardSoundRequest withSoundId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableSendSoundboardSoundRequest(this, newValue, this.sourceGuildId());
    }

    public ImmutableSendSoundboardSoundRequest withSourceGuildId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableSendSoundboardSoundRequest(this, this.soundId(), newValue);
    }

    public ImmutableSendSoundboardSoundRequest withSourceGuildId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableSendSoundboardSoundRequest(this, this.soundId(), (Possible<Id>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendSoundboardSoundRequest && this.equalTo(0, (ImmutableSendSoundboardSoundRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendSoundboardSoundRequest another) {
        return Objects.equals(this.soundId_value, another.soundId_value) && this.sourceGuildId().equals(another.sourceGuildId());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.soundId_value);
        h += (h << 5) + this.sourceGuildId().hashCode();
        return h;
    }

    public String toString() {
        return "SendSoundboardSoundRequest{soundId=" + Objects.toString(this.soundId_value) + ", sourceGuildId=" + this.sourceGuildId().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSendSoundboardSoundRequest fromJson(Json json) {
        Builder builder = ImmutableSendSoundboardSoundRequest.builder();
        if (json.soundId != null) {
            builder.soundId(json.soundId);
        }
        if (json.sourceGuildId != null) {
            builder.sourceGuildId(json.sourceGuildId);
        }
        return builder.build();
    }

    public static ImmutableSendSoundboardSoundRequest of(Id soundId, Possible<Id> sourceGuildId) {
        return new ImmutableSendSoundboardSoundRequest(soundId, sourceGuildId);
    }

    public static ImmutableSendSoundboardSoundRequest copyOf(SendSoundboardSoundRequest instance) {
        if (instance instanceof ImmutableSendSoundboardSoundRequest) {
            return (ImmutableSendSoundboardSoundRequest)instance;
        }
        return ImmutableSendSoundboardSoundRequest.builder().from(instance).build();
    }

    public boolean isSourceGuildIdPresent() {
        return !this.sourceGuildId_absent;
    }

    public long sourceGuildIdOrElse(long defaultValue) {
        return !this.sourceGuildId_absent ? this.sourceGuildId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Id soundId_id = null;
        private Possible<Id> sourceGuildId_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(SendSoundboardSoundRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.soundId(instance.soundId());
            this.sourceGuildId(instance.sourceGuildId());
            return this;
        }

        public Builder soundId(String value) {
            this.soundId_id = Id.of((String)value);
            return this;
        }

        public Builder soundId(long value) {
            this.soundId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="sound_id")
        public Builder soundId(Id value) {
            this.soundId_id = value;
            return this;
        }

        public Builder sourceGuildId(String value) {
            this.sourceGuildId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder sourceGuildId(long value) {
            this.sourceGuildId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder sourceGuildId(Id value) {
            this.sourceGuildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="source_guild_id")
        public Builder sourceGuildId(Possible<Id> value) {
            this.sourceGuildId_possible = value;
            return this;
        }

        public ImmutableSendSoundboardSoundRequest build() {
            return new ImmutableSendSoundboardSoundRequest(null, this.soundId_build(), this.sourceGuildId_build());
        }

        private Id soundId_build() {
            return this.soundId_id;
        }

        private Possible<Id> sourceGuildId_build() {
            return this.sourceGuildId_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SendSoundboardSoundRequest {
        @Nullable
        Id soundId;
        Possible<Id> sourceGuildId = Possible.absent();

        Json() {
        }

        @JsonProperty(value="sound_id")
        public void setSoundId(Id soundId) {
            this.soundId = soundId;
        }

        @JsonProperty(value="source_guild_id")
        public void setSourceGuildId(Possible<Id> sourceGuildId) {
            this.sourceGuildId = sourceGuildId;
        }

        @Override
        public Id soundId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> sourceGuildId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SendSoundboardSoundRequest, attribute initializers form cycle " + attributes;
        }
    }
}

