/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.SelectDefaultValueData;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableSelectDefaultValueData
implements SelectDefaultValueData {
    private final long id_value;
    private final String type;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSelectDefaultValueData(Id id, String type) {
        Id id$impl = id;
        this.type = Objects.requireNonNull(type, "type");
        this.id_value = id$impl.asLong();
        this.initShim = null;
    }

    private ImmutableSelectDefaultValueData(ImmutableSelectDefaultValueData original, Id id, String type) {
        Id id$impl = id;
        this.type = type;
        this.id_value = id$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    public ImmutableSelectDefaultValueData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableSelectDefaultValueData(this, newValue, this.type);
    }

    public ImmutableSelectDefaultValueData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableSelectDefaultValueData(this, newValue, this.type);
    }

    public final ImmutableSelectDefaultValueData withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableSelectDefaultValueData(this, this.id(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSelectDefaultValueData && this.equalTo(0, (ImmutableSelectDefaultValueData)another);
    }

    private boolean equalTo(int synthetic, ImmutableSelectDefaultValueData another) {
        return Objects.equals(this.id_value, another.id_value) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "SelectDefaultValueData{id=" + Objects.toString(this.id_value) + ", type=" + this.type + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSelectDefaultValueData fromJson(Json json) {
        Builder builder = ImmutableSelectDefaultValueData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableSelectDefaultValueData of(Id id, String type) {
        return new ImmutableSelectDefaultValueData(id, type);
    }

    public static ImmutableSelectDefaultValueData copyOf(SelectDefaultValueData instance) {
        if (instance instanceof ImmutableSelectDefaultValueData) {
            return (ImmutableSelectDefaultValueData)instance;
        }
        return ImmutableSelectDefaultValueData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        private Id id_id = null;
        @Nullable
        private String type;

        private Builder() {
        }

        public final Builder from(SelectDefaultValueData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.type(instance.type());
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSelectDefaultValueData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSelectDefaultValueData(null, this.id_build(), this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build SelectDefaultValueData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SelectDefaultValueData {
        @Nullable
        Id id;
        @Nullable
        String type;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SelectDefaultValueData, attribute initializers form cycle " + attributes;
        }
    }
}

