/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.PollAnswerObject;
import discord4j.discordjson.json.PollData;
import discord4j.discordjson.json.PollMediaObject;
import discord4j.discordjson.json.PollResultObject;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutablePollData
implements PollData {
    private final PollMediaObject question;
    private final List<PollAnswerObject> answers;
    @Nullable
    private final String expiry;
    private final boolean allowMultiselect;
    private final int layoutType;
    private final PollResultObject results_value;
    private final boolean results_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePollData(PollMediaObject question, Iterable<? extends PollAnswerObject> answers, Optional<String> expiry, boolean allowMultiselect, int layoutType, Possible<PollResultObject> results) {
        this.question = Objects.requireNonNull(question, "question");
        this.answers = ImmutablePollData.createUnmodifiableList(false, ImmutablePollData.createSafeList(answers, true, false));
        this.expiry = expiry.orElse(null);
        this.allowMultiselect = allowMultiselect;
        this.layoutType = layoutType;
        Possible<PollResultObject> results$impl = results;
        this.results_value = results$impl.toOptional().orElse(null);
        this.results_absent = results$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutablePollData(ImmutablePollData original, PollMediaObject question, List<PollAnswerObject> answers, @Nullable String expiry, boolean allowMultiselect, int layoutType, Possible<PollResultObject> results) {
        this.question = question;
        this.answers = answers;
        this.expiry = expiry;
        this.allowMultiselect = allowMultiselect;
        this.layoutType = layoutType;
        Possible<PollResultObject> results$impl = results;
        this.results_value = results$impl.toOptional().orElse(null);
        this.results_absent = results$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="question")
    public PollMediaObject question() {
        return this.question;
    }

    @Override
    @JsonProperty(value="answers")
    public List<PollAnswerObject> answers() {
        return this.answers;
    }

    @Override
    @JsonProperty(value="expiry")
    public Optional<String> expiry() {
        return Optional.ofNullable(this.expiry);
    }

    @Override
    @JsonProperty(value="allow_multiselect")
    public boolean allowMultiselect() {
        return this.allowMultiselect;
    }

    @Override
    @JsonProperty(value="layout_type")
    public int layoutType() {
        return this.layoutType;
    }

    @Override
    @JsonProperty(value="results")
    public Possible<PollResultObject> results() {
        return this.results_absent ? Possible.absent() : Possible.of((Object)this.results_value);
    }

    public final ImmutablePollData withQuestion(PollMediaObject value) {
        if (this.question == value) {
            return this;
        }
        PollMediaObject newValue = Objects.requireNonNull(value, "question");
        return new ImmutablePollData(this, newValue, this.answers, this.expiry, this.allowMultiselect, this.layoutType, this.results());
    }

    public final ImmutablePollData withAnswers(PollAnswerObject ... elements) {
        List<PollAnswerObject> newValue = ImmutablePollData.createUnmodifiableList(false, ImmutablePollData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePollData(this, this.question, newValue, this.expiry, this.allowMultiselect, this.layoutType, this.results());
    }

    public final ImmutablePollData withAnswers(Iterable<? extends PollAnswerObject> elements) {
        if (this.answers == elements) {
            return this;
        }
        List<PollAnswerObject> newValue = ImmutablePollData.createUnmodifiableList(false, ImmutablePollData.createSafeList(elements, true, false));
        return new ImmutablePollData(this, this.question, newValue, this.expiry, this.allowMultiselect, this.layoutType, this.results());
    }

    public final ImmutablePollData withExpiry(String value) {
        String newValue = Objects.requireNonNull(value, "expiry");
        if (Objects.equals(this.expiry, newValue)) {
            return this;
        }
        return new ImmutablePollData(this, this.question, this.answers, newValue, this.allowMultiselect, this.layoutType, this.results());
    }

    public final ImmutablePollData withExpiry(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.expiry, value)) {
            return this;
        }
        return new ImmutablePollData(this, this.question, this.answers, value, this.allowMultiselect, this.layoutType, this.results());
    }

    public final ImmutablePollData withAllowMultiselect(boolean value) {
        if (this.allowMultiselect == value) {
            return this;
        }
        return new ImmutablePollData(this, this.question, this.answers, this.expiry, value, this.layoutType, this.results());
    }

    public final ImmutablePollData withLayoutType(int value) {
        if (this.layoutType == value) {
            return this;
        }
        return new ImmutablePollData(this, this.question, this.answers, this.expiry, this.allowMultiselect, value, this.results());
    }

    public ImmutablePollData withResults(Possible<PollResultObject> value) {
        Possible<PollResultObject> newValue = Objects.requireNonNull(value);
        return new ImmutablePollData(this, this.question, this.answers, this.expiry, this.allowMultiselect, this.layoutType, newValue);
    }

    public ImmutablePollData withResults(PollResultObject value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutablePollData(this, this.question, this.answers, this.expiry, this.allowMultiselect, this.layoutType, (Possible<PollResultObject>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePollData && this.equalTo(0, (ImmutablePollData)another);
    }

    private boolean equalTo(int synthetic, ImmutablePollData another) {
        return this.question.equals(another.question) && this.answers.equals(another.answers) && Objects.equals(this.expiry, another.expiry) && this.allowMultiselect == another.allowMultiselect && this.layoutType == another.layoutType && this.results().equals(another.results());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.question.hashCode();
        h += (h << 5) + this.answers.hashCode();
        h += (h << 5) + Objects.hashCode(this.expiry);
        h += (h << 5) + Boolean.hashCode(this.allowMultiselect);
        h += (h << 5) + this.layoutType;
        h += (h << 5) + this.results().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PollData{");
        builder.append("question=").append(this.question);
        builder.append(", ");
        builder.append("answers=").append(this.answers);
        if (this.expiry != null) {
            builder.append(", ");
            builder.append("expiry=").append(this.expiry);
        }
        builder.append(", ");
        builder.append("allowMultiselect=").append(this.allowMultiselect);
        builder.append(", ");
        builder.append("layoutType=").append(this.layoutType);
        builder.append(", ");
        builder.append("results=").append(this.results().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePollData fromJson(Json json) {
        Builder builder = ImmutablePollData.builder();
        if (json.question != null) {
            builder.question(json.question);
        }
        if (json.answers != null) {
            builder.addAllAnswers(json.answers);
        }
        if (json.expiry != null) {
            builder.expiry(json.expiry);
        }
        if (json.allowMultiselectIsSet) {
            builder.allowMultiselect(json.allowMultiselect);
        }
        if (json.layoutTypeIsSet) {
            builder.layoutType(json.layoutType);
        }
        if (json.results != null) {
            builder.results(json.results);
        }
        return builder.build();
    }

    public static ImmutablePollData of(PollMediaObject question, List<PollAnswerObject> answers, Optional<String> expiry, boolean allowMultiselect, int layoutType, Possible<PollResultObject> results) {
        return ImmutablePollData.of(question, answers, expiry, allowMultiselect, layoutType, results);
    }

    public static ImmutablePollData of(PollMediaObject question, Iterable<? extends PollAnswerObject> answers, Optional<String> expiry, boolean allowMultiselect, int layoutType, Possible<PollResultObject> results) {
        return new ImmutablePollData(question, answers, expiry, allowMultiselect, layoutType, results);
    }

    public static ImmutablePollData copyOf(PollData instance) {
        if (instance instanceof ImmutablePollData) {
            return (ImmutablePollData)instance;
        }
        return ImmutablePollData.builder().from(instance).build();
    }

    public boolean isResultsPresent() {
        return !this.results_absent;
    }

    public PollResultObject resultsOrElse(PollResultObject defaultValue) {
        return !this.results_absent ? this.results_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_QUESTION = 1L;
        private static final long INIT_BIT_ALLOW_MULTISELECT = 2L;
        private static final long INIT_BIT_LAYOUT_TYPE = 4L;
        private long initBits = 7L;
        private Possible<PollResultObject> results_possible = Possible.absent();
        @Nullable
        private PollMediaObject question;
        private List<PollAnswerObject> answers = new ArrayList<PollAnswerObject>();
        @Nullable
        private String expiry;
        private boolean allowMultiselect;
        private int layoutType;

        private Builder() {
        }

        public final Builder from(PollData instance) {
            Objects.requireNonNull(instance, "instance");
            this.question(instance.question());
            this.addAllAnswers(instance.answers());
            Optional<String> expiryOptional = instance.expiry();
            if (expiryOptional.isPresent()) {
                this.expiry(expiryOptional);
            }
            this.allowMultiselect(instance.allowMultiselect());
            this.layoutType(instance.layoutType());
            this.results(instance.results());
            return this;
        }

        @JsonProperty(value="question")
        public final Builder question(PollMediaObject question) {
            this.question = Objects.requireNonNull(question, "question");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addAnswer(PollAnswerObject element) {
            this.answers.add(Objects.requireNonNull(element, "answers element"));
            return this;
        }

        public final Builder addAnswers(PollAnswerObject ... elements) {
            for (PollAnswerObject element : elements) {
                this.answers.add(Objects.requireNonNull(element, "answers element"));
            }
            return this;
        }

        @JsonProperty(value="answers")
        public final Builder answers(Iterable<? extends PollAnswerObject> elements) {
            this.answers.clear();
            return this.addAllAnswers(elements);
        }

        public final Builder addAllAnswers(Iterable<? extends PollAnswerObject> elements) {
            for (PollAnswerObject pollAnswerObject : elements) {
                this.answers.add(Objects.requireNonNull(pollAnswerObject, "answers element"));
            }
            return this;
        }

        public final Builder expiry(String expiry) {
            this.expiry = Objects.requireNonNull(expiry, "expiry");
            return this;
        }

        @JsonProperty(value="expiry")
        public final Builder expiry(Optional<String> expiry) {
            this.expiry = expiry.orElse(null);
            return this;
        }

        @JsonProperty(value="allow_multiselect")
        public final Builder allowMultiselect(boolean allowMultiselect) {
            this.allowMultiselect = allowMultiselect;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="layout_type")
        public final Builder layoutType(int layoutType) {
            this.layoutType = layoutType;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="results")
        public Builder results(Possible<PollResultObject> value) {
            this.results_possible = value;
            return this;
        }

        public Builder results(PollResultObject value) {
            this.results_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutablePollData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePollData(null, this.question, ImmutablePollData.createUnmodifiableList(true, this.answers), this.expiry, this.allowMultiselect, this.layoutType, this.results_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("question");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("allowMultiselect");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("layoutType");
            }
            return "Cannot build PollData, some of required attributes are not set " + attributes;
        }

        private Possible<PollResultObject> results_build() {
            return this.results_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements PollData {
        @Nullable
        PollMediaObject question;
        @Nullable
        List<PollAnswerObject> answers = Collections.emptyList();
        @Nullable
        Optional<String> expiry = Optional.empty();
        boolean allowMultiselect;
        boolean allowMultiselectIsSet;
        int layoutType;
        boolean layoutTypeIsSet;
        Possible<PollResultObject> results = Possible.absent();

        Json() {
        }

        @JsonProperty(value="question")
        public void setQuestion(PollMediaObject question) {
            this.question = question;
        }

        @JsonProperty(value="answers")
        public void setAnswers(List<PollAnswerObject> answers) {
            this.answers = answers;
        }

        @JsonProperty(value="expiry")
        public void setExpiry(Optional<String> expiry) {
            this.expiry = expiry;
        }

        @JsonProperty(value="allow_multiselect")
        public void setAllowMultiselect(boolean allowMultiselect) {
            this.allowMultiselect = allowMultiselect;
            this.allowMultiselectIsSet = true;
        }

        @JsonProperty(value="layout_type")
        public void setLayoutType(int layoutType) {
            this.layoutType = layoutType;
            this.layoutTypeIsSet = true;
        }

        @JsonProperty(value="results")
        public void setResults(Possible<PollResultObject> results) {
            this.results = results;
        }

        @Override
        public PollMediaObject question() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PollAnswerObject> answers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> expiry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean allowMultiselect() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int layoutType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<PollResultObject> results() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build PollData, attribute initializers form cycle " + attributes;
        }
    }
}

