/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ApplicationCommandPermissionsData;
import discord4j.discordjson.json.PartialGuildApplicationCommandPermissionsData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutablePartialGuildApplicationCommandPermissionsData
implements PartialGuildApplicationCommandPermissionsData {
    private final String id;
    private final List<ApplicationCommandPermissionsData> permissions;

    private ImmutablePartialGuildApplicationCommandPermissionsData(String id, Iterable<? extends ApplicationCommandPermissionsData> permissions) {
        this.id = Objects.requireNonNull(id, "id");
        this.permissions = ImmutablePartialGuildApplicationCommandPermissionsData.createUnmodifiableList(false, ImmutablePartialGuildApplicationCommandPermissionsData.createSafeList(permissions, true, false));
    }

    private ImmutablePartialGuildApplicationCommandPermissionsData(ImmutablePartialGuildApplicationCommandPermissionsData original, String id, List<ApplicationCommandPermissionsData> permissions) {
        this.id = id;
        this.permissions = permissions;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="permissions")
    public List<ApplicationCommandPermissionsData> permissions() {
        return this.permissions;
    }

    public final ImmutablePartialGuildApplicationCommandPermissionsData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePartialGuildApplicationCommandPermissionsData(this, newValue, this.permissions);
    }

    public final ImmutablePartialGuildApplicationCommandPermissionsData withPermissions(ApplicationCommandPermissionsData ... elements) {
        List<ApplicationCommandPermissionsData> newValue = ImmutablePartialGuildApplicationCommandPermissionsData.createUnmodifiableList(false, ImmutablePartialGuildApplicationCommandPermissionsData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePartialGuildApplicationCommandPermissionsData(this, this.id, newValue);
    }

    public final ImmutablePartialGuildApplicationCommandPermissionsData withPermissions(Iterable<? extends ApplicationCommandPermissionsData> elements) {
        if (this.permissions == elements) {
            return this;
        }
        List<ApplicationCommandPermissionsData> newValue = ImmutablePartialGuildApplicationCommandPermissionsData.createUnmodifiableList(false, ImmutablePartialGuildApplicationCommandPermissionsData.createSafeList(elements, true, false));
        return new ImmutablePartialGuildApplicationCommandPermissionsData(this, this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePartialGuildApplicationCommandPermissionsData && this.equalTo(0, (ImmutablePartialGuildApplicationCommandPermissionsData)another);
    }

    private boolean equalTo(int synthetic, ImmutablePartialGuildApplicationCommandPermissionsData another) {
        return this.id.equals(another.id) && this.permissions.equals(another.permissions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.permissions.hashCode();
        return h;
    }

    public String toString() {
        return "PartialGuildApplicationCommandPermissionsData{id=" + this.id + ", permissions=" + this.permissions + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePartialGuildApplicationCommandPermissionsData fromJson(Json json) {
        Builder builder = ImmutablePartialGuildApplicationCommandPermissionsData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.permissions != null) {
            builder.addAllPermissions(json.permissions);
        }
        return builder.build();
    }

    public static ImmutablePartialGuildApplicationCommandPermissionsData of(String id, List<ApplicationCommandPermissionsData> permissions) {
        return ImmutablePartialGuildApplicationCommandPermissionsData.of(id, permissions);
    }

    public static ImmutablePartialGuildApplicationCommandPermissionsData of(String id, Iterable<? extends ApplicationCommandPermissionsData> permissions) {
        return new ImmutablePartialGuildApplicationCommandPermissionsData(id, permissions);
    }

    public static ImmutablePartialGuildApplicationCommandPermissionsData copyOf(PartialGuildApplicationCommandPermissionsData instance) {
        if (instance instanceof ImmutablePartialGuildApplicationCommandPermissionsData) {
            return (ImmutablePartialGuildApplicationCommandPermissionsData)instance;
        }
        return ImmutablePartialGuildApplicationCommandPermissionsData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        private List<ApplicationCommandPermissionsData> permissions = new ArrayList<ApplicationCommandPermissionsData>();

        private Builder() {
        }

        public final Builder from(PartialGuildApplicationCommandPermissionsData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.addAllPermissions(instance.permissions());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPermission(ApplicationCommandPermissionsData element) {
            this.permissions.add(Objects.requireNonNull(element, "permissions element"));
            return this;
        }

        public final Builder addPermissions(ApplicationCommandPermissionsData ... elements) {
            for (ApplicationCommandPermissionsData element : elements) {
                this.permissions.add(Objects.requireNonNull(element, "permissions element"));
            }
            return this;
        }

        @JsonProperty(value="permissions")
        public final Builder permissions(Iterable<? extends ApplicationCommandPermissionsData> elements) {
            this.permissions.clear();
            return this.addAllPermissions(elements);
        }

        public final Builder addAllPermissions(Iterable<? extends ApplicationCommandPermissionsData> elements) {
            for (ApplicationCommandPermissionsData applicationCommandPermissionsData : elements) {
                this.permissions.add(Objects.requireNonNull(applicationCommandPermissionsData, "permissions element"));
            }
            return this;
        }

        public ImmutablePartialGuildApplicationCommandPermissionsData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePartialGuildApplicationCommandPermissionsData(null, this.id, ImmutablePartialGuildApplicationCommandPermissionsData.createUnmodifiableList(true, this.permissions));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build PartialGuildApplicationCommandPermissionsData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements PartialGuildApplicationCommandPermissionsData {
        @Nullable
        String id;
        @Nullable
        List<ApplicationCommandPermissionsData> permissions = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="permissions")
        public void setPermissions(List<ApplicationCommandPermissionsData> permissions) {
            this.permissions = permissions;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ApplicationCommandPermissionsData> permissions() {
            throw new UnsupportedOperationException();
        }
    }
}

