/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.GuildScheduledEventData;
import discord4j.discordjson.json.GuildScheduledEventEntityMetadataData;
import discord4j.discordjson.json.RecurrenceRuleData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableGuildScheduledEventData
implements GuildScheduledEventData {
    private final long id_value;
    private final long guildId_value;
    private final long channelId_value;
    private final boolean channelId_present;
    private final long creatorId_value;
    private final boolean creatorId_absent;
    private final boolean creatorId_isNull;
    private final String name;
    private final String description_value;
    private final boolean description_absent;
    private final Instant scheduledStartTime;
    @Nullable
    private final Instant scheduledEndTime;
    private final int privacyLevel;
    private final int status;
    private final int entityType;
    private final long entityId_value;
    private final boolean entityId_present;
    @Nullable
    private final GuildScheduledEventEntityMetadataData entityMetadata;
    private final UserData creator_value;
    private final boolean creator_absent;
    private final Integer userCount_value;
    private final boolean userCount_absent;
    private final String image_value;
    private final boolean image_absent;
    @Nullable
    private final RecurrenceRuleData recurrenceRule;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGuildScheduledEventData(Id id, Id guildId, Optional<Id> channelId, Possible<Optional<Id>> creatorId, String name, Possible<Optional<String>> description, Instant scheduledStartTime, Optional<? extends Instant> scheduledEndTime, int privacyLevel, int status, int entityType, Optional<Id> entityId, Optional<? extends GuildScheduledEventEntityMetadataData> entityMetadata, Possible<UserData> creator, Possible<Integer> userCount, Possible<Optional<String>> image, Optional<? extends RecurrenceRuleData> recurrenceRule) {
        Id id$impl = id;
        Id guildId$impl = guildId;
        Optional<Id> channelId$impl = channelId;
        Possible<Optional<Id>> creatorId$impl = creatorId;
        this.name = Objects.requireNonNull(name, "name");
        Possible<Optional<String>> description$impl = description;
        this.scheduledStartTime = Objects.requireNonNull(scheduledStartTime, "scheduledStartTime");
        this.scheduledEndTime = scheduledEndTime.orElse(null);
        this.privacyLevel = privacyLevel;
        this.status = status;
        this.entityType = entityType;
        Optional<Id> entityId$impl = entityId;
        this.entityMetadata = entityMetadata.orElse(null);
        Possible<UserData> creator$impl = creator;
        Possible<Integer> userCount$impl = userCount;
        Possible<Optional<String>> image$impl = image;
        this.recurrenceRule = recurrenceRule.orElse(null);
        this.id_value = id$impl.asLong();
        this.guildId_value = guildId$impl.asLong();
        this.channelId_value = channelId$impl.map(Id::asLong).orElse(0L);
        this.channelId_present = channelId$impl.isPresent();
        this.creatorId_value = Possible.flatOpt(creatorId$impl).map(Id::asLong).orElse(0L);
        this.creatorId_absent = creatorId$impl.isAbsent();
        this.creatorId_isNull = !creatorId$impl.isAbsent() && !((Optional)creatorId$impl.get()).isPresent();
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.entityId_value = entityId$impl.map(Id::asLong).orElse(0L);
        this.entityId_present = entityId$impl.isPresent();
        this.creator_value = creator$impl.toOptional().orElse(null);
        this.creator_absent = creator$impl.isAbsent();
        this.userCount_value = userCount$impl.toOptional().orElse(null);
        this.userCount_absent = userCount$impl.isAbsent();
        this.image_value = Possible.flatOpt(image$impl).orElse(null);
        this.image_absent = image$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableGuildScheduledEventData(ImmutableGuildScheduledEventData original, Id id, Id guildId, Optional<Id> channelId, Possible<Optional<Id>> creatorId, String name, Possible<Optional<String>> description, Instant scheduledStartTime, @Nullable Instant scheduledEndTime, int privacyLevel, int status, int entityType, Optional<Id> entityId, @Nullable GuildScheduledEventEntityMetadataData entityMetadata, Possible<UserData> creator, Possible<Integer> userCount, Possible<Optional<String>> image, @Nullable RecurrenceRuleData recurrenceRule) {
        Id id$impl = id;
        Id guildId$impl = guildId;
        Optional<Id> channelId$impl = channelId;
        Possible<Optional<Id>> creatorId$impl = creatorId;
        this.name = name;
        Possible<Optional<String>> description$impl = description;
        this.scheduledStartTime = scheduledStartTime;
        this.scheduledEndTime = scheduledEndTime;
        this.privacyLevel = privacyLevel;
        this.status = status;
        this.entityType = entityType;
        Optional<Id> entityId$impl = entityId;
        this.entityMetadata = entityMetadata;
        Possible<UserData> creator$impl = creator;
        Possible<Integer> userCount$impl = userCount;
        Possible<Optional<String>> image$impl = image;
        this.recurrenceRule = recurrenceRule;
        this.id_value = id$impl.asLong();
        this.guildId_value = guildId$impl.asLong();
        this.channelId_value = channelId$impl.map(Id::asLong).orElse(0L);
        this.channelId_present = channelId$impl.isPresent();
        this.creatorId_value = Possible.flatOpt(creatorId$impl).map(Id::asLong).orElse(0L);
        this.creatorId_absent = creatorId$impl.isAbsent();
        this.creatorId_isNull = !creatorId$impl.isAbsent() && !((Optional)creatorId$impl.get()).isPresent();
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.entityId_value = entityId$impl.map(Id::asLong).orElse(0L);
        this.entityId_present = entityId$impl.isPresent();
        this.creator_value = creator$impl.toOptional().orElse(null);
        this.creator_absent = creator$impl.isAbsent();
        this.userCount_value = userCount$impl.toOptional().orElse(null);
        this.userCount_absent = userCount$impl.isAbsent();
        this.image_value = Possible.flatOpt(image$impl).orElse(null);
        this.image_absent = image$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="channel_id")
    public Optional<Id> channelId() {
        return this.channelId_present ? Optional.of(Id.of((long)this.channelId_value)) : Optional.empty();
    }

    @Override
    @JsonProperty(value="creator_id")
    public Possible<Optional<Id>> creatorId() {
        if (this.creatorId_absent) {
            return Possible.absent();
        }
        if (this.creatorId_isNull) {
            return Possible.of(Optional.empty());
        }
        return Possible.of(Optional.of(Id.of((long)this.creatorId_value)));
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public Possible<Optional<String>> description() {
        return this.description_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.description_value));
    }

    @Override
    @JsonProperty(value="scheduled_start_time")
    public Instant scheduledStartTime() {
        return this.scheduledStartTime;
    }

    @Override
    @JsonProperty(value="scheduled_end_time")
    public Optional<Instant> scheduledEndTime() {
        return Optional.ofNullable(this.scheduledEndTime);
    }

    @Override
    @JsonProperty(value="privacy_level")
    public int privacyLevel() {
        return this.privacyLevel;
    }

    @Override
    @JsonProperty(value="status")
    public int status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="entity_type")
    public int entityType() {
        return this.entityType;
    }

    @Override
    @JsonProperty(value="entity_id")
    public Optional<Id> entityId() {
        return this.entityId_present ? Optional.of(Id.of((long)this.entityId_value)) : Optional.empty();
    }

    @Override
    @JsonProperty(value="entity_metadata")
    public Optional<GuildScheduledEventEntityMetadataData> entityMetadata() {
        return Optional.ofNullable(this.entityMetadata);
    }

    @Override
    @JsonProperty(value="creator")
    public Possible<UserData> creator() {
        return this.creator_absent ? Possible.absent() : Possible.of((Object)this.creator_value);
    }

    @Override
    @JsonProperty(value="user_count")
    public Possible<Integer> userCount() {
        return this.userCount_absent ? Possible.absent() : Possible.of((Object)this.userCount_value);
    }

    @Override
    @JsonProperty(value="image")
    public Possible<Optional<String>> image() {
        return this.image_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.image_value));
    }

    @Override
    @JsonProperty(value="recurrence_rule")
    public Optional<RecurrenceRuleData> recurrenceRule() {
        return Optional.ofNullable(this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableGuildScheduledEventData(this, newValue, this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableGuildScheduledEventData(this, newValue, this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableGuildScheduledEventData(this, this.id(), newValue, this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableGuildScheduledEventData(this, this.id(), newValue, this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withChannelId(Optional<Id> value) {
        Optional<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), newValue, this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withChannelId(long value) {
        Optional<Id> newValue = Optional.of(Id.of((long)value));
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), newValue, this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withCreatorId(Possible<Optional<Id>> value) {
        Possible<Optional<Id>> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), newValue, this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    @Deprecated
    public ImmutableGuildScheduledEventData withCreatorId(@Nullable Long value) {
        Possible newValue = value == null ? Possible.of(Optional.empty()) : Possible.of(Optional.of(Id.of((long)value)));
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), (Possible<Optional<Id>>)newValue, this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withCreatorIdOrNull(@Nullable Long value) {
        Possible newValue = value == null ? Possible.of(Optional.empty()) : Possible.of(Optional.of(Id.of((long)value)));
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), (Possible<Optional<Id>>)newValue, this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public final ImmutableGuildScheduledEventData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), newValue, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withDescription(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, newValue, this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    @Deprecated
    public ImmutableGuildScheduledEventData withDescription(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, (Possible<Optional<String>>)newValue, this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withDescriptionOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, (Possible<Optional<String>>)newValue, this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public final ImmutableGuildScheduledEventData withScheduledStartTime(Instant value) {
        if (this.scheduledStartTime == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "scheduledStartTime");
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), newValue, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public final ImmutableGuildScheduledEventData withScheduledEndTime(Instant value) {
        Instant newValue = Objects.requireNonNull(value, "scheduledEndTime");
        if (this.scheduledEndTime == newValue) {
            return this;
        }
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, newValue, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public final ImmutableGuildScheduledEventData withScheduledEndTime(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.scheduledEndTime == value) {
            return this;
        }
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, value, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public final ImmutableGuildScheduledEventData withPrivacyLevel(int value) {
        if (this.privacyLevel == value) {
            return this;
        }
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, value, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public final ImmutableGuildScheduledEventData withStatus(int value) {
        if (this.status == value) {
            return this;
        }
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, value, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public final ImmutableGuildScheduledEventData withEntityType(int value) {
        if (this.entityType == value) {
            return this;
        }
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, value, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withEntityId(Optional<Id> value) {
        Optional<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, newValue, this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withEntityId(long value) {
        Optional<Id> newValue = Optional.of(Id.of((long)value));
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, newValue, this.entityMetadata, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public final ImmutableGuildScheduledEventData withEntityMetadata(GuildScheduledEventEntityMetadataData value) {
        GuildScheduledEventEntityMetadataData newValue = Objects.requireNonNull(value, "entityMetadata");
        if (this.entityMetadata == newValue) {
            return this;
        }
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), newValue, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public final ImmutableGuildScheduledEventData withEntityMetadata(Optional<? extends GuildScheduledEventEntityMetadataData> optional) {
        GuildScheduledEventEntityMetadataData value = optional.orElse(null);
        if (this.entityMetadata == value) {
            return this;
        }
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), value, this.creator(), this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withCreator(Possible<UserData> value) {
        Possible<UserData> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, newValue, this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withCreator(UserData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, (Possible<UserData>)newValue, this.userCount(), this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withUserCount(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), newValue, this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withUserCount(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), (Possible<Integer>)newValue, this.image(), this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withImage(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), newValue, this.recurrenceRule);
    }

    @Deprecated
    public ImmutableGuildScheduledEventData withImage(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), (Possible<Optional<String>>)newValue, this.recurrenceRule);
    }

    public ImmutableGuildScheduledEventData withImageOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), (Possible<Optional<String>>)newValue, this.recurrenceRule);
    }

    public final ImmutableGuildScheduledEventData withRecurrenceRule(RecurrenceRuleData value) {
        RecurrenceRuleData newValue = Objects.requireNonNull(value, "recurrenceRule");
        if (this.recurrenceRule == newValue) {
            return this;
        }
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), newValue);
    }

    public final ImmutableGuildScheduledEventData withRecurrenceRule(Optional<? extends RecurrenceRuleData> optional) {
        RecurrenceRuleData value = optional.orElse(null);
        if (this.recurrenceRule == value) {
            return this;
        }
        return new ImmutableGuildScheduledEventData(this, this.id(), this.guildId(), this.channelId(), this.creatorId(), this.name, this.description(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId(), this.entityMetadata, this.creator(), this.userCount(), this.image(), value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildScheduledEventData && this.equalTo(0, (ImmutableGuildScheduledEventData)another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildScheduledEventData another) {
        return Objects.equals(this.id_value, another.id_value) && Objects.equals(this.guildId_value, another.guildId_value) && this.channelId().equals(another.channelId()) && this.creatorId().equals(another.creatorId()) && this.name.equals(another.name) && this.description().equals(another.description()) && this.scheduledStartTime.equals(another.scheduledStartTime) && Objects.equals(this.scheduledEndTime, another.scheduledEndTime) && this.privacyLevel == another.privacyLevel && this.status == another.status && this.entityType == another.entityType && this.entityId().equals(another.entityId()) && Objects.equals(this.entityMetadata, another.entityMetadata) && this.creator().equals(another.creator()) && this.userCount().equals(another.userCount()) && this.image().equals(another.image()) && Objects.equals(this.recurrenceRule, another.recurrenceRule);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + this.channelId().hashCode();
        h += (h << 5) + this.creatorId().hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description().hashCode();
        h += (h << 5) + this.scheduledStartTime.hashCode();
        h += (h << 5) + Objects.hashCode(this.scheduledEndTime);
        h += (h << 5) + this.privacyLevel;
        h += (h << 5) + this.status;
        h += (h << 5) + this.entityType;
        h += (h << 5) + this.entityId().hashCode();
        h += (h << 5) + Objects.hashCode(this.entityMetadata);
        h += (h << 5) + this.creator().hashCode();
        h += (h << 5) + this.userCount().hashCode();
        h += (h << 5) + this.image().hashCode();
        h += (h << 5) + Objects.hashCode(this.recurrenceRule);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GuildScheduledEventData{");
        builder.append("id=").append(Objects.toString(this.id_value));
        builder.append(", ");
        builder.append("guildId=").append(Objects.toString(this.guildId_value));
        builder.append(", ");
        builder.append("channelId=").append(this.channelId().toString());
        builder.append(", ");
        builder.append("creatorId=").append(this.creatorId().toString());
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("description=").append(this.description().toString());
        builder.append(", ");
        builder.append("scheduledStartTime=").append(this.scheduledStartTime);
        if (this.scheduledEndTime != null) {
            builder.append(", ");
            builder.append("scheduledEndTime=").append(this.scheduledEndTime);
        }
        builder.append(", ");
        builder.append("privacyLevel=").append(this.privacyLevel);
        builder.append(", ");
        builder.append("status=").append(this.status);
        builder.append(", ");
        builder.append("entityType=").append(this.entityType);
        builder.append(", ");
        builder.append("entityId=").append(this.entityId().toString());
        if (this.entityMetadata != null) {
            builder.append(", ");
            builder.append("entityMetadata=").append(this.entityMetadata);
        }
        builder.append(", ");
        builder.append("creator=").append(this.creator().toString());
        builder.append(", ");
        builder.append("userCount=").append(this.userCount().toString());
        builder.append(", ");
        builder.append("image=").append(this.image().toString());
        if (this.recurrenceRule != null) {
            builder.append(", ");
            builder.append("recurrenceRule=").append(this.recurrenceRule);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildScheduledEventData fromJson(Json json) {
        Builder builder = ImmutableGuildScheduledEventData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.creatorId != null) {
            builder.creatorId(json.creatorId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.scheduledStartTime != null) {
            builder.scheduledStartTime(json.scheduledStartTime);
        }
        if (json.scheduledEndTime != null) {
            builder.scheduledEndTime(json.scheduledEndTime);
        }
        if (json.privacyLevelIsSet) {
            builder.privacyLevel(json.privacyLevel);
        }
        if (json.statusIsSet) {
            builder.status(json.status);
        }
        if (json.entityTypeIsSet) {
            builder.entityType(json.entityType);
        }
        if (json.entityId != null) {
            builder.entityId(json.entityId);
        }
        if (json.entityMetadata != null) {
            builder.entityMetadata(json.entityMetadata);
        }
        if (json.creator != null) {
            builder.creator(json.creator);
        }
        if (json.userCount != null) {
            builder.userCount(json.userCount);
        }
        if (json.image != null) {
            builder.image(json.image);
        }
        if (json.recurrenceRule != null) {
            builder.recurrenceRule(json.recurrenceRule);
        }
        return builder.build();
    }

    public static ImmutableGuildScheduledEventData of(Id id, Id guildId, Optional<Id> channelId, Possible<Optional<Id>> creatorId, String name, Possible<Optional<String>> description, Instant scheduledStartTime, Optional<? extends Instant> scheduledEndTime, int privacyLevel, int status, int entityType, Optional<Id> entityId, Optional<? extends GuildScheduledEventEntityMetadataData> entityMetadata, Possible<UserData> creator, Possible<Integer> userCount, Possible<Optional<String>> image, Optional<? extends RecurrenceRuleData> recurrenceRule) {
        return new ImmutableGuildScheduledEventData(id, guildId, channelId, creatorId, name, description, scheduledStartTime, scheduledEndTime, privacyLevel, status, entityType, entityId, entityMetadata, creator, userCount, image, recurrenceRule);
    }

    public static ImmutableGuildScheduledEventData copyOf(GuildScheduledEventData instance) {
        if (instance instanceof ImmutableGuildScheduledEventData) {
            return (ImmutableGuildScheduledEventData)instance;
        }
        return ImmutableGuildScheduledEventData.builder().from(instance).build();
    }

    public boolean isChannelIdPresent() {
        return this.channelId_present;
    }

    public long channelIdOrElse(long defaultValue) {
        return this.channelId_present ? this.channelId_value : defaultValue;
    }

    public boolean isCreatorIdPresent() {
        return !this.creatorId_absent;
    }

    public long creatorIdOrElse(long defaultValue) {
        return !this.creatorId_absent ? this.creatorId_value : defaultValue;
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public boolean isEntityIdPresent() {
        return this.entityId_present;
    }

    public long entityIdOrElse(long defaultValue) {
        return this.entityId_present ? this.entityId_value : defaultValue;
    }

    public boolean isCreatorPresent() {
        return !this.creator_absent;
    }

    public UserData creatorOrElse(UserData defaultValue) {
        return !this.creator_absent ? this.creator_value : defaultValue;
    }

    public boolean isUserCountPresent() {
        return !this.userCount_absent;
    }

    public Integer userCountOrElse(Integer defaultValue) {
        return !this.userCount_absent ? this.userCount_value : defaultValue;
    }

    public boolean isImagePresent() {
        return !this.image_absent;
    }

    public String imageOrElse(String defaultValue) {
        return !this.image_absent ? this.image_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SCHEDULED_START_TIME = 2L;
        private static final long INIT_BIT_PRIVACY_LEVEL = 4L;
        private static final long INIT_BIT_STATUS = 8L;
        private static final long INIT_BIT_ENTITY_TYPE = 16L;
        private long initBits = 31L;
        private Id id_id = null;
        private Id guildId_id = null;
        private Optional<Id> channelId_optional = Optional.empty();
        private Possible<Optional<Id>> creatorId_possible = Possible.absent();
        private Possible<Optional<String>> description_possible = Possible.absent();
        private Optional<Id> entityId_optional = Optional.empty();
        private Possible<UserData> creator_possible = Possible.absent();
        private Possible<Integer> userCount_possible = Possible.absent();
        private Possible<Optional<String>> image_possible = Possible.absent();
        @Nullable
        private String name;
        @Nullable
        private Instant scheduledStartTime;
        @Nullable
        private Instant scheduledEndTime;
        private int privacyLevel;
        private int status;
        private int entityType;
        @Nullable
        private GuildScheduledEventEntityMetadataData entityMetadata;
        @Nullable
        private RecurrenceRuleData recurrenceRule;

        private Builder() {
        }

        public final Builder from(GuildScheduledEventData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.guildId(instance.guildId());
            this.channelId(instance.channelId());
            this.creatorId(instance.creatorId());
            this.name(instance.name());
            this.description(instance.description());
            this.scheduledStartTime(instance.scheduledStartTime());
            Optional<Instant> scheduledEndTimeOptional = instance.scheduledEndTime();
            if (scheduledEndTimeOptional.isPresent()) {
                this.scheduledEndTime(scheduledEndTimeOptional);
            }
            this.privacyLevel(instance.privacyLevel());
            this.status(instance.status());
            this.entityType(instance.entityType());
            this.entityId(instance.entityId());
            Optional<GuildScheduledEventEntityMetadataData> entityMetadataOptional = instance.entityMetadata();
            if (entityMetadataOptional.isPresent()) {
                this.entityMetadata(entityMetadataOptional);
            }
            this.creator(instance.creator());
            this.userCount(instance.userCount());
            this.image(instance.image());
            Optional<RecurrenceRuleData> recurrenceRuleOptional = instance.recurrenceRule();
            if (recurrenceRuleOptional.isPresent()) {
                this.recurrenceRule(recurrenceRuleOptional);
            }
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_optional = Optional.of(Id.of((String)value));
            return this;
        }

        public Builder channelId(long value) {
            this.channelId_optional = Optional.of(Id.of((long)value));
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Optional<Id> value) {
            this.channelId_optional = value;
            return this;
        }

        public Builder creatorId(String value) {
            this.creatorId_possible = Possible.of(Optional.of(Id.of((String)value)));
            return this;
        }

        public Builder creatorId(long value) {
            this.creatorId_possible = Possible.of(Optional.of(Id.of((long)value)));
            return this;
        }

        public Builder creatorId(Id value) {
            this.creatorId_possible = Possible.of(Optional.of(value));
            return this;
        }

        @JsonProperty(value="creator_id")
        public Builder creatorId(Possible<Optional<Id>> value) {
            this.creatorId_possible = value;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="description")
        public Builder description(Possible<Optional<String>> value) {
            this.description_possible = value;
            return this;
        }

        @Deprecated
        public Builder description(@Nullable String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder descriptionOrNull(@Nullable String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="scheduled_start_time")
        public final Builder scheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = Objects.requireNonNull(scheduledStartTime, "scheduledStartTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder scheduledEndTime(Instant scheduledEndTime) {
            this.scheduledEndTime = Objects.requireNonNull(scheduledEndTime, "scheduledEndTime");
            return this;
        }

        @JsonProperty(value="scheduled_end_time")
        public final Builder scheduledEndTime(Optional<? extends Instant> scheduledEndTime) {
            this.scheduledEndTime = scheduledEndTime.orElse(null);
            return this;
        }

        @JsonProperty(value="privacy_level")
        public final Builder privacyLevel(int privacyLevel) {
            this.privacyLevel = privacyLevel;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(int status) {
            this.status = status;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="entity_type")
        public final Builder entityType(int entityType) {
            this.entityType = entityType;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder entityId(String value) {
            this.entityId_optional = Optional.of(Id.of((String)value));
            return this;
        }

        public Builder entityId(long value) {
            this.entityId_optional = Optional.of(Id.of((long)value));
            return this;
        }

        @JsonProperty(value="entity_id")
        public Builder entityId(Optional<Id> value) {
            this.entityId_optional = value;
            return this;
        }

        public final Builder entityMetadata(GuildScheduledEventEntityMetadataData entityMetadata) {
            this.entityMetadata = Objects.requireNonNull(entityMetadata, "entityMetadata");
            return this;
        }

        @JsonProperty(value="entity_metadata")
        public final Builder entityMetadata(Optional<? extends GuildScheduledEventEntityMetadataData> entityMetadata) {
            this.entityMetadata = entityMetadata.orElse(null);
            return this;
        }

        @JsonProperty(value="creator")
        public Builder creator(Possible<UserData> value) {
            this.creator_possible = value;
            return this;
        }

        public Builder creator(UserData value) {
            this.creator_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="user_count")
        public Builder userCount(Possible<Integer> value) {
            this.userCount_possible = value;
            return this;
        }

        public Builder userCount(Integer value) {
            this.userCount_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="image")
        public Builder image(Possible<Optional<String>> value) {
            this.image_possible = value;
            return this;
        }

        @Deprecated
        public Builder image(@Nullable String value) {
            this.image_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder imageOrNull(@Nullable String value) {
            this.image_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public final Builder recurrenceRule(RecurrenceRuleData recurrenceRule) {
            this.recurrenceRule = Objects.requireNonNull(recurrenceRule, "recurrenceRule");
            return this;
        }

        @JsonProperty(value="recurrence_rule")
        public final Builder recurrenceRule(Optional<? extends RecurrenceRuleData> recurrenceRule) {
            this.recurrenceRule = recurrenceRule.orElse(null);
            return this;
        }

        public ImmutableGuildScheduledEventData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildScheduledEventData(null, this.id_build(), this.guildId_build(), this.channelId_build(), this.creatorId_build(), this.name, this.description_build(), this.scheduledStartTime, this.scheduledEndTime, this.privacyLevel, this.status, this.entityType, this.entityId_build(), this.entityMetadata, this.creator_build(), this.userCount_build(), this.image_build(), this.recurrenceRule);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scheduledStartTime");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("privacyLevel");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("entityType");
            }
            return "Cannot build GuildScheduledEventData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }

        private Optional<Id> channelId_build() {
            return this.channelId_optional;
        }

        private Possible<Optional<Id>> creatorId_build() {
            return this.creatorId_possible;
        }

        private Possible<Optional<String>> description_build() {
            return this.description_possible;
        }

        private Optional<Id> entityId_build() {
            return this.entityId_optional;
        }

        private Possible<UserData> creator_build() {
            return this.creator_possible;
        }

        private Possible<Integer> userCount_build() {
            return this.userCount_possible;
        }

        private Possible<Optional<String>> image_build() {
            return this.image_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GuildScheduledEventData {
        @Nullable
        Id id;
        @Nullable
        Id guildId;
        Optional<Id> channelId = Optional.empty();
        Possible<Optional<Id>> creatorId = Possible.absent();
        @Nullable
        String name;
        Possible<Optional<String>> description = Possible.absent();
        @Nullable
        Instant scheduledStartTime;
        @Nullable
        Optional<Instant> scheduledEndTime = Optional.empty();
        int privacyLevel;
        boolean privacyLevelIsSet;
        int status;
        boolean statusIsSet;
        int entityType;
        boolean entityTypeIsSet;
        Optional<Id> entityId = Optional.empty();
        @Nullable
        Optional<GuildScheduledEventEntityMetadataData> entityMetadata = Optional.empty();
        Possible<UserData> creator = Possible.absent();
        Possible<Integer> userCount = Possible.absent();
        Possible<Optional<String>> image = Possible.absent();
        @Nullable
        Optional<RecurrenceRuleData> recurrenceRule = Optional.empty();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Optional<Id> channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="creator_id")
        public void setCreatorId(Possible<Optional<Id>> creatorId) {
            this.creatorId = creatorId;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(Possible<Optional<String>> description) {
            this.description = description;
        }

        @JsonProperty(value="scheduled_start_time")
        public void setScheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
        }

        @JsonProperty(value="scheduled_end_time")
        public void setScheduledEndTime(Optional<Instant> scheduledEndTime) {
            this.scheduledEndTime = scheduledEndTime;
        }

        @JsonProperty(value="privacy_level")
        public void setPrivacyLevel(int privacyLevel) {
            this.privacyLevel = privacyLevel;
            this.privacyLevelIsSet = true;
        }

        @JsonProperty(value="status")
        public void setStatus(int status) {
            this.status = status;
            this.statusIsSet = true;
        }

        @JsonProperty(value="entity_type")
        public void setEntityType(int entityType) {
            this.entityType = entityType;
            this.entityTypeIsSet = true;
        }

        @JsonProperty(value="entity_id")
        public void setEntityId(Optional<Id> entityId) {
            this.entityId = entityId;
        }

        @JsonProperty(value="entity_metadata")
        public void setEntityMetadata(Optional<GuildScheduledEventEntityMetadataData> entityMetadata) {
            this.entityMetadata = entityMetadata;
        }

        @JsonProperty(value="creator")
        public void setCreator(Possible<UserData> creator) {
            this.creator = creator;
        }

        @JsonProperty(value="user_count")
        public void setUserCount(Possible<Integer> userCount) {
            this.userCount = userCount;
        }

        @JsonProperty(value="image")
        public void setImage(Possible<Optional<String>> image) {
            this.image = image;
        }

        @JsonProperty(value="recurrence_rule")
        public void setRecurrenceRule(Optional<RecurrenceRuleData> recurrenceRule) {
            this.recurrenceRule = recurrenceRule;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Id> channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<Id>> creatorId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant scheduledStartTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> scheduledEndTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int privacyLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int entityType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Id> entityId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GuildScheduledEventEntityMetadataData> entityMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<UserData> creator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Integer> userCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> image() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<RecurrenceRuleData> recurrenceRule() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildScheduledEventData, attribute initializers form cycle " + attributes;
        }
    }
}

