/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.GroupDMCreateRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableGroupDMCreateRequest
implements GroupDMCreateRequest {
    private final List<String> accessTokens;
    private final Map<String, String> nicks;

    private ImmutableGroupDMCreateRequest(Iterable<String> accessTokens, Map<String, ? extends String> nicks) {
        this.accessTokens = ImmutableGroupDMCreateRequest.createUnmodifiableList(false, ImmutableGroupDMCreateRequest.createSafeList(accessTokens, true, false));
        this.nicks = ImmutableGroupDMCreateRequest.createUnmodifiableMap(true, false, nicks);
    }

    private ImmutableGroupDMCreateRequest(ImmutableGroupDMCreateRequest original, List<String> accessTokens, Map<String, String> nicks) {
        this.accessTokens = accessTokens;
        this.nicks = nicks;
    }

    @Override
    @JsonProperty(value="access_tokens")
    public List<String> accessTokens() {
        return this.accessTokens;
    }

    @Override
    @JsonProperty(value="nicks")
    public Map<String, String> nicks() {
        return this.nicks;
    }

    public final ImmutableGroupDMCreateRequest withAccessTokens(String ... elements) {
        List<String> newValue = ImmutableGroupDMCreateRequest.createUnmodifiableList(false, ImmutableGroupDMCreateRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGroupDMCreateRequest(this, newValue, this.nicks);
    }

    public final ImmutableGroupDMCreateRequest withAccessTokens(Iterable<String> elements) {
        if (this.accessTokens == elements) {
            return this;
        }
        List<String> newValue = ImmutableGroupDMCreateRequest.createUnmodifiableList(false, ImmutableGroupDMCreateRequest.createSafeList(elements, true, false));
        return new ImmutableGroupDMCreateRequest(this, newValue, this.nicks);
    }

    public final ImmutableGroupDMCreateRequest withNicks(Map<String, ? extends String> entries) {
        if (this.nicks == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableGroupDMCreateRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableGroupDMCreateRequest(this, this.accessTokens, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroupDMCreateRequest && this.equalTo(0, (ImmutableGroupDMCreateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupDMCreateRequest another) {
        return this.accessTokens.equals(another.accessTokens) && this.nicks.equals(another.nicks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.accessTokens.hashCode();
        h += (h << 5) + this.nicks.hashCode();
        return h;
    }

    public String toString() {
        return "GroupDMCreateRequest{accessTokens=" + this.accessTokens + ", nicks=" + this.nicks + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGroupDMCreateRequest fromJson(Json json) {
        Builder builder = ImmutableGroupDMCreateRequest.builder();
        if (json.accessTokens != null) {
            builder.addAllAccessTokens(json.accessTokens);
        }
        if (json.nicks != null) {
            builder.putAllNicks(json.nicks);
        }
        return builder.build();
    }

    public static ImmutableGroupDMCreateRequest of(List<String> accessTokens, Map<String, String> nicks) {
        return ImmutableGroupDMCreateRequest.of(accessTokens, nicks);
    }

    public static ImmutableGroupDMCreateRequest of(Iterable<String> accessTokens, Map<String, ? extends String> nicks) {
        return new ImmutableGroupDMCreateRequest(accessTokens, nicks);
    }

    public static ImmutableGroupDMCreateRequest copyOf(GroupDMCreateRequest instance) {
        if (instance instanceof ImmutableGroupDMCreateRequest) {
            return (ImmutableGroupDMCreateRequest)instance;
        }
        return ImmutableGroupDMCreateRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private List<String> accessTokens = new ArrayList<String>();
        private Map<String, String> nicks = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(GroupDMCreateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllAccessTokens(instance.accessTokens());
            this.putAllNicks(instance.nicks());
            return this;
        }

        public final Builder addAccessToken(String element) {
            this.accessTokens.add(Objects.requireNonNull(element, "accessTokens element"));
            return this;
        }

        public final Builder addAccessTokens(String ... elements) {
            for (String element : elements) {
                this.accessTokens.add(Objects.requireNonNull(element, "accessTokens element"));
            }
            return this;
        }

        @JsonProperty(value="access_tokens")
        public final Builder accessTokens(Iterable<String> elements) {
            this.accessTokens.clear();
            return this.addAllAccessTokens(elements);
        }

        public final Builder addAllAccessTokens(Iterable<String> elements) {
            for (String element : elements) {
                this.accessTokens.add(Objects.requireNonNull(element, "accessTokens element"));
            }
            return this;
        }

        public final Builder putNick(String key, String value) {
            this.nicks.put(Objects.requireNonNull(key, "nicks key"), Objects.requireNonNull(value, value == null ? "nicks value for key: " + key : null));
            return this;
        }

        public final Builder putNick(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.nicks.put(Objects.requireNonNull(k, "nicks key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "nicks value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="nicks")
        public final Builder nicks(Map<String, ? extends String> entries) {
            this.nicks.clear();
            return this.putAllNicks(entries);
        }

        public final Builder putAllNicks(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.nicks.put(Objects.requireNonNull(k, "nicks key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "nicks value for key: " + k : null));
            }
            return this;
        }

        public ImmutableGroupDMCreateRequest build() {
            return new ImmutableGroupDMCreateRequest(null, ImmutableGroupDMCreateRequest.createUnmodifiableList(true, this.accessTokens), ImmutableGroupDMCreateRequest.createUnmodifiableMap(false, false, this.nicks));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GroupDMCreateRequest {
        @Nullable
        List<String> accessTokens = Collections.emptyList();
        @Nullable
        Map<String, String> nicks = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="access_tokens")
        public void setAccessTokens(List<String> accessTokens) {
            this.accessTokens = accessTokens;
        }

        @JsonProperty(value="nicks")
        public void setNicks(Map<String, String> nicks) {
            this.nicks = nicks;
        }

        @Override
        public List<String> accessTokens() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> nicks() {
            throw new UnsupportedOperationException();
        }
    }
}

